package com.icetech.fee.dao.merchant;

import com.icetech.fee.domain.entity.merchant.DiscountDay;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * DiscountDayDAO继承基类
 */
@Repository
public interface DiscountDayDao {
    int deleteByPrimaryKey(Integer id);

    int insert(DiscountDay record);

    int insertSelective(DiscountDay record);

    DiscountDay selectByPrimaryKey(Integer id);

    int updateByPrimaryKeySelective(DiscountDay record);

    int updateByPrimaryKey(DiscountDay record);

    DiscountDay selectValidDiscountDay(@Param("plateNum") String plateNum, @Param("parkId") Long parkId,
                                       @Param("payTime") String payTime);

    DiscountDay selectDiscountDay(@Param("discountNo") String discountNo, @Param("parkId") Long parkId);

    DiscountDay findValidExistedDisCountDay(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("nowTime") Date nowTime);

    DiscountDay selectLastByPlateNum(@Param("plateNum") String plateNum, @Param("parkId") Long parkId);

    /**
     * 获取未释放的按天优免优惠券
     *
     * @param discountNo
     * @param parkId
     * @return
     */
    List<DiscountDay> selectDiscountDayByRelease(@Param("discountNo") String discountNo, @Param("parkId") Long parkId);

    /**
     * 根据车牌号和优惠模板ID查询优惠记录
     *
     * @param parkId
     * @param plateNum
     * @param merchantDisId
     * @return
     */
    DiscountDay findByPlateAndDisId(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("merchantDisId") Long merchantDisId);

    DiscountDay findLastDisDayByPlateAndOnceDay(@Param("parkId") Long parkId, @Param("plateNum") String plateNum);

    /**
     * 查询最近过期的数据
     * @param queryId
     * @param startTime
     * @return
     */
    List<DiscountDay> selectExpireDiscounts(@Param("queryId")Integer queryId,@Param("startTime")Date startTime);

}
