/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.fee.service.vip.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.VipTypeDao;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.domain.response.VipInfoDto;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.fee.dao.vip.VipInfoDao;
import com.icetech.fee.dao.vip.VipPlateDao;
import com.icetech.fee.dao.vip.VipRecordDao;
import com.icetech.fee.domain.entity.vip.VipInfo;
import com.icetech.fee.domain.entity.vip.VipPlate;
import com.icetech.fee.domain.entity.vip.VipRecord;
import com.icetech.fee.domain.vo.VipInfoDetail;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VipCarServiceImpl
implements VipCarService {
    private static final Logger log = LoggerFactory.getLogger(VipCarServiceImpl.class);
    @Autowired
    private VipInfoDao vipInfoDao;
    @Autowired
    private VipTypeDao vipTypeDao;
    @Autowired
    private VipRecordDao vipRecordDao;
    @Resource
    private VipPlateDao vipPlateDao;

    public ObjectResponse<VipType> getValidVipCar(Long parkId, String plateNum, Long regionId) {
        VipInfo vipInfo = this.vipInfoDao.selectExpirationDateByPlateNum(parkId, plateNum, regionId);
        if (vipInfo != null) {
            int typeId = vipInfo.getTypeId();
            VipType vipType = this.vipTypeDao.selectByPrimaryKey(Integer.valueOf(typeId));
            return ObjectResponse.success((Object)vipType);
        }
        return ObjectResponse.failed((String)"404", (String)CodeConstants.getName((String)"404"));
    }

    public ObjectResponse<VipType> getRecentVipCar(Long parkId, String plateNum, Long regionId) {
        VipInfo vipInfo = this.vipInfoDao.selectRecentVipCarByPlateNum(parkId, plateNum, regionId);
        if (vipInfo != null) {
            int typeId = vipInfo.getTypeId();
            VipType vipType = this.vipTypeDao.selectByPrimaryKey(Integer.valueOf(typeId));
            return ObjectResponse.success((Object)vipType);
        }
        return ObjectResponse.failed((String)"404", (String)CodeConstants.getName((String)"404"));
    }

    public ObjectResponse<VipRecord> getOperatorRecordById(Long id) {
        VipRecord vipRecord = this.vipRecordDao.selectByPrimaryKey(id.intValue());
        if (vipRecord != null) {
            return ObjectResponse.success((Object)vipRecord);
        }
        return ObjectResponse.failed((String)"404", (String)CodeConstants.getName((String)"404"));
    }

    public ObjectResponse<List<VipInfoDto>> getValidByParkId(Long parkId) {
        List<VipInfoDto> vipInfoDtos = this.vipInfoDao.selectValidByParkId(parkId);
        if (vipInfoDtos != null && vipInfoDtos.size() > 0) {
            return ObjectResponse.success(vipInfoDtos);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<VipInfoDto>> getValidByIds(List<String> idList) {
        List<VipInfoDto> vipInfoDtos = this.vipInfoDao.selectValidByIds(idList);
        if (vipInfoDtos != null && vipInfoDtos.size() > 0) {
            return ObjectResponse.success(vipInfoDtos);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<VipTypeDto> getVipTypeById(Integer typeId) {
        VipTypeDto vipType = this.vipTypeDao.selectById(typeId);
        if (vipType != null) {
            return ObjectResponse.success((Object)vipType);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<VipInfoDetail> getVipInfoDetailById(int vipInfoId) {
        VipInfoDetail detail = this.vipInfoDao.selectWithTypeById(vipInfoId);
        if (detail == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)detail);
    }

    public ObjectResponse<List<VipPlate>> getVipPlatesByInfoId(long vipInfoId) {
        VipPlate param = new VipPlate();
        param.setVipId(Long.valueOf(vipInfoId));
        List plates = this.vipPlateDao.selectList((Wrapper)Wrappers.lambdaQuery((Object)param));
        if (CollectionUtils.isEmpty((Collection)plates)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)plates);
    }

    public ObjectResponse<List<Long>> getRecordIdListByIds(List<Long> ids) {
        List<Long> recordIds = this.vipRecordDao.getRecordIdListByIds(ids);
        if (recordIds != null && recordIds.size() > 0) {
            return ObjectResponse.success(recordIds);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<VipTypeDto>> getVipTypeByParkId(Long parkId) {
        List list = this.vipTypeDao.selectVipTypsByParkId(parkId);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return ObjectResponse.success((Object)list);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<VipType> getVipFeeTypeByParkId(Long parkId) {
        VipType vipType = this.vipTypeDao.selectVipFeeTypeByParkId(parkId);
        if (vipType == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)vipType);
    }

    public ObjectResponse<Boolean> addVipType(VipType vipType) {
        return this.vipTypeDao.insert(vipType) > 0 ? ObjectResponse.success((Object)Boolean.TRUE) : ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<VipInfo> getVipInfoByParkIdAndTypeId(Long parkId, Integer vipId) {
        VipInfo vipInfo = this.vipInfoDao.selectVipInfoByParkIdAndTypeId(parkId, vipId);
        return vipInfo == null ? ObjectResponse.failed((String)"404") : ObjectResponse.success((Object)vipInfo);
    }

    public ObjectResponse<Boolean> addVipInfo(VipInfo vipInfo) {
        return this.vipInfoDao.insert(vipInfo) > 0 ? ObjectResponse.success((Object)true) : ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Boolean> addVipRecord(VipRecord vipRecord) {
        return this.vipRecordDao.insert(vipRecord) > 0 ? ObjectResponse.success((Object)true) : ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Boolean> updateVipInfo(VipInfo vipInfo) {
        return this.vipInfoDao.updateByPrimaryKeySelective(vipInfo) > 0 ? ObjectResponse.success((Object)true) : ObjectResponse.failed((String)"404");
    }

    public List<VipRecord> getVipRecordsByVipId(Integer parkId, Integer vipId) {
        return this.vipRecordDao.getVipRecordsByVipId(parkId, vipId);
    }
}

