/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.fee.service.monthcar.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.cloudcenter.api.month.MonthrenewePubcheckService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.response.MonthInfoDto;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRegionDao;
import com.icetech.fee.dao.monthcar.MonthrenewePubcheckMapper;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthrenewePubcheck;
import com.icetech.park.domain.entity.park.Park;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonthrenewePubcheckServiceImpl
extends BaseServiceImpl<MonthrenewePubcheckMapper, MonthrenewePubcheck>
implements MonthrenewePubcheckService {
    @Autowired
    private MonthrenewePubcheckMapper monthrenewePubcheckMapper;
    @Autowired
    private ParkService parkService;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthRegionDao monthRegionDao;

    public MonthrenewePubcheck getMonthrenewePubcheckById(Long id) {
        return (MonthrenewePubcheck)this.getById(id);
    }

    public Boolean addMonthrenewePubcheck(MonthrenewePubcheck entity) {
        return this.save(entity);
    }

    public Boolean modifyMonthrenewePubcheck(MonthrenewePubcheck entity) {
        return this.updateById(entity);
    }

    public Boolean removeMonthrenewePubcheckById(Long id) {
        return this.removeById(id);
    }

    public List<MonthInfoDto> selectMonthInfo(Integer mpUserId) {
        List<MonthrenewePubcheck> monthrenewePubcheckes = this.monthrenewePubcheckMapper.selectInfoByMp(mpUserId);
        ArrayList monthInfoDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(monthrenewePubcheckes)) {
            monthrenewePubcheckes.forEach(monthrenewePubcheck -> {
                Park park = (Park)this.parkService.findByParkId(Long.valueOf(monthrenewePubcheck.getParkId().intValue())).getData();
                MonthProduct monthProduct = this.monthProductDao.selectById(monthrenewePubcheck.getProductId().intValue());
                MonthInfoDto monthInfoDto = new MonthInfoDto();
                monthInfoDto.setParkCode(park.getParkCode());
                monthInfoDto.setParkName(park.getParkName());
                monthInfoDto.setCardOwner(monthrenewePubcheck.getCardOwner());
                monthInfoDto.setPlateNumber(monthrenewePubcheck.getPlateNum());
                monthInfoDto.setPlotCount(monthrenewePubcheck.getPlotCount().intValue());
                monthInfoDto.setStartTime(monthrenewePubcheck.getStartTime());
                monthInfoDto.setEndTime(monthrenewePubcheck.getEndTime());
                if (monthrenewePubcheck.getCardOpertype() == 1) {
                    monthInfoDto.setStatus(98);
                }
                if (monthrenewePubcheck.getCardOpertype() == 3) {
                    monthInfoDto.setStatus(99);
                }
                monthInfoDto.setProductName(monthProduct.getName());
                monthInfoDto.setProductId(monthProduct.getId());
                monthInfoDto.setPlotNum(monthrenewePubcheck.getPlotCount().toString());
                monthInfoDto.setPhone(monthrenewePubcheck.getPhone());
                monthInfoDto.setCardProperty(monthrenewePubcheck.getCardProperty());
                monthInfoDto.setCardOpertype(monthrenewePubcheck.getCardOpertype());
                monthInfoDtos.add(monthInfoDto);
            });
        }
        return monthInfoDtos;
    }

    public MonthrenewePubcheck selectByTradeNo(String tradeNo) {
        return (MonthrenewePubcheck)this.getOne((Wrapper)Wrappers.lambdaQuery(MonthrenewePubcheck.class).eq(MonthrenewePubcheck::getTradeNo, (Object)tradeNo));
    }
}

