package com.icetech.fee.service.vip.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.fee.dao.vip.VipRegionMapper;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * VIP类型关联区域表 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-11-04
 */
@Service
public class VipRegionServiceImpl extends BaseServiceImpl<VipRegionMapper, VipRegion> implements VipRegionService {

    /**
     * Description: 根据ID查询 VIP类型关联区域表对象信息 <br>
     * Version1.0 2021-11-04 by wanggang创建
     *
     * @param id 对象id
     * @return VipRegion
     */
    @Override
    public VipRegion getVipRegionById(Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  VIP类型关联区域表对象信息 <br>
     * Version1.0 2021-11-04 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addVipRegion(VipRegion entity) {
        return save(entity);
    }

    /**
     * Description: 修改 VIP类型关联区域表对象信息 <br>
     * Version1.0 2021-11-04 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyVipRegion(VipRegion entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  VIP类型关联区域表对象信息 <br>
     * Version1.0 2021-11-04 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeVipRegionById(Long id) {
        return removeById(id);
    }

    @Override
    public List<VipRegion> getVipRegionsListByVipTypeId(Integer vipTypeId) {
        return list(Wrappers.lambdaQuery(VipRegion.class)
                .eq(VipRegion::getTypeId, vipTypeId));
    }

    @Override
    public VipRegion getOneByVipTypeIdAndRegionId(Integer vipTypeId, Long regionId) {
        if (regionId == null) {
            return list(Wrappers.lambdaQuery(VipRegion.class)
                    .eq(VipRegion::getTypeId, vipTypeId)
            ).stream().filter(Objects::nonNull)
                    .findFirst()
                    .orElse(null);
        }
        return list(Wrappers.lambdaQuery(VipRegion.class)
                .eq(VipRegion::getTypeId, vipTypeId)
                .and(query -> query.eq(VipRegion::getRegionId, regionId)
                        .or().eq(VipRegion::getRegionId, 0))
        ).stream().filter(Objects::nonNull)
                .findFirst()
                .orElse(null);

    }


}
