package com.icetech.fee.service.vip.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.domain.response.VipInfoDto;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.fee.dao.vip.VipInfoDao;
import com.icetech.fee.dao.vip.VipPlateDao;
import com.icetech.fee.dao.vip.VipRecordDao;
import com.icetech.basics.dao.VipTypeDao;
import com.icetech.fee.domain.entity.vip.VipInfo;
import com.icetech.fee.domain.entity.vip.VipPlate;
import com.icetech.fee.domain.entity.vip.VipRecord;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.fee.domain.vo.VipInfoDetail;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

import javax.annotation.Resource;

@Service
@Slf4j
public class VipCarServiceImpl implements VipCarService {
    @Autowired
    private VipInfoDao vipInfoDao;
    @Autowired
    private VipTypeDao vipTypeDao;
    @Autowired
    private VipRecordDao vipRecordDao;
    @Resource
    private VipPlateDao vipPlateDao;

    @Override
    public ObjectResponse<VipType> getValidVipCar(Long parkId, String plateNum, Long regionId) {
        //查询有效期内的VIP车辆
        VipInfo vipInfo = vipInfoDao.selectExpirationDateByPlateNum(parkId,plateNum, regionId);
        if (vipInfo != null){
            int typeId = vipInfo.getTypeId();
            VipType vipType = vipTypeDao.selectByPrimaryKey(typeId);
            return ObjectResponse.success(vipType);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
    }

    @Override
    public ObjectResponse<VipType> getRecentVipCar(Long parkId, String plateNum, Long regionId) {
        //查询最近的的VIP车辆
        VipInfo vipInfo = vipInfoDao.selectRecentVipCarByPlateNum(parkId,plateNum, regionId);
        if (vipInfo != null){
            int typeId = vipInfo.getTypeId();
            VipType vipType = vipTypeDao.selectByPrimaryKey(typeId);
            return ObjectResponse.success(vipType);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
    }

    @Override
    public ObjectResponse<VipRecord> getOperatorRecordById(Long id) {
        VipRecord vipRecord = vipRecordDao.selectByPrimaryKey(id.intValue());
        if (vipRecord != null){
            return ObjectResponse.success(vipRecord);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
        }
    }

    @Override
    public ObjectResponse<List<VipInfoDto>> getValidByParkId(Long parkId) {
        List<VipInfoDto> vipInfoDtos = vipInfoDao.selectValidByParkId(parkId);
        if (vipInfoDtos != null && vipInfoDtos.size() > 0){
            return ObjectResponse.success(vipInfoDtos);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<List<VipInfoDto>> getValidByIds(List<String> idList) {
        List<VipInfoDto> vipInfoDtos = vipInfoDao.selectValidByIds(idList);
        if (vipInfoDtos != null && vipInfoDtos.size() > 0){
            return ObjectResponse.success(vipInfoDtos);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<VipTypeDto> getVipTypeById(Integer typeId) {
        VipTypeDto vipType = vipTypeDao.selectById(typeId);
        if (vipType != null){
            return ObjectResponse.success(vipType);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<VipInfoDetail> getVipInfoDetailById(int vipInfoId) {
        VipInfoDetail detail = vipInfoDao.selectWithTypeById(vipInfoId);
        if (detail == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }

        return ObjectResponse.success(detail);
    }

    @Override
    public ObjectResponse<List<VipPlate>> getVipPlatesByInfoId(long vipInfoId) {
        VipPlate param = new VipPlate();
        param.setVipId(vipInfoId);
        List<VipPlate> plates = vipPlateDao.selectList(Wrappers.lambdaQuery(param));
        if (CollectionUtils.isEmpty(plates)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }

        return ObjectResponse.success(plates);
    }

    @Override
    public ObjectResponse<List<Long>> getRecordIdListByIds(List<Long> ids) {
        List<Long> recordIds = vipRecordDao.getRecordIdListByIds(ids);
        if (recordIds != null && recordIds.size() > 0){
            return ObjectResponse.success(recordIds);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<List<VipTypeDto>> getVipTypeByParkId(Long parkId) {
        List<VipTypeDto> list = vipTypeDao.selectVipTypsByParkId(parkId);
        if (CollectionUtils.isNotEmpty(list)){
            return ObjectResponse.success(list);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<VipType> getVipFeeTypeByParkId(Long parkId) {
        VipType vipType = vipTypeDao.selectVipFeeTypeByParkId(parkId);
        if (vipType == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(vipType);
    }

    @Override
    public ObjectResponse<Boolean> addVipType(VipType vipType) {
        return vipTypeDao.insert(vipType) > 0 ?ObjectResponse.success(Boolean.TRUE) : ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    public ObjectResponse<VipInfo> getVipInfoByParkIdAndTypeId(Long parkId, Integer vipId) {
        VipInfo vipInfo = vipInfoDao.selectVipInfoByParkIdAndTypeId(parkId, vipId);
        return vipInfo == null ? ObjectResponse.failed(CodeConstants.ERROR_404) : ObjectResponse.success(vipInfo);
    }

    @Override
    public ObjectResponse<Boolean> addVipInfo(VipInfo vipInfo) {
        return vipInfoDao.insert(vipInfo) > 0 ? ObjectResponse.success(true) : ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    public ObjectResponse<Boolean> addVipRecord(VipRecord vipRecord) {
        return vipRecordDao.insert(vipRecord) > 0 ? ObjectResponse.success(true) : ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    public ObjectResponse<Boolean> updateVipInfo(VipInfo vipInfo) {
        return vipInfoDao.updateByPrimaryKeySelective(vipInfo) > 0 ? ObjectResponse.success(true) : ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    public List<VipRecord> getVipRecordsByVipId(Integer parkId, Integer vipId) {
        return vipRecordDao.getVipRecordsByVipId(parkId, vipId);
    }

}
