package com.icetech.fee.service.monthcar.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.cloudcenter.api.month.MonthrenewePubcheckService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.response.MonthInfoDto;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRegionDao;
import com.icetech.fee.dao.monthcar.MonthrenewePubcheckMapper;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthrenewePubcheck;
import com.icetech.park.domain.entity.park.Park;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 月卡续费审核表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-12-31
 */
@Service
public class MonthrenewePubcheckServiceImpl extends BaseServiceImpl<MonthrenewePubcheckMapper, MonthrenewePubcheck> implements MonthrenewePubcheckService {
    @Autowired
    private MonthrenewePubcheckMapper monthrenewePubcheckMapper;
    @Autowired
    private ParkService parkService;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthRegionDao monthRegionDao;
    /**
     * Description: 根据ID查询 月卡续费审核表对象信息 <br>
     * Version1.0 2021-12-31 by wanggang创建
     *
     * @param id 对象id
     * @return MonthrenewePubcheck
     */
    @Override
    public MonthrenewePubcheck getMonthrenewePubcheckById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  月卡续费审核表对象信息 <br>
     * Version1.0 2021-12-31 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addMonthrenewePubcheck (MonthrenewePubcheck entity) {
        return save(entity);
    }

    /**
     * Description: 修改 月卡续费审核表对象信息 <br>
     * Version1.0 2021-12-31 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyMonthrenewePubcheck (MonthrenewePubcheck entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  月卡续费审核表对象信息 <br>
     * Version1.0 2021-12-31 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeMonthrenewePubcheckById (Long id) {
        return removeById(id);
    }

    @Override
    public List<MonthInfoDto> selectMonthInfo(Integer mpUserId) {
        List<MonthrenewePubcheck> monthrenewePubcheckes = monthrenewePubcheckMapper.selectInfoByMp(mpUserId);
        List<MonthInfoDto> monthInfoDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(monthrenewePubcheckes)){
            monthrenewePubcheckes.forEach(monthrenewePubcheck -> {
                Park park = parkService.findByParkId(Long.valueOf(monthrenewePubcheck.getParkId())).getData();
                MonthProduct monthProduct = monthProductDao.selectById(monthrenewePubcheck.getProductId());
                MonthInfoDto monthInfoDto = new MonthInfoDto();
                monthInfoDto.setParkCode(park.getParkCode());
                monthInfoDto.setParkName(park.getParkName());
                monthInfoDto.setCardOwner(monthrenewePubcheck.getCardOwner());
                monthInfoDto.setPlateNumber(monthrenewePubcheck.getPlateNum());
                monthInfoDto.setPlotCount(monthrenewePubcheck.getPlotCount());
                monthInfoDto.setStartTime(monthrenewePubcheck.getStartTime());
                monthInfoDto.setEndTime(monthrenewePubcheck.getEndTime());
                if (monthrenewePubcheck.getCardOpertype() == 1){
                    monthInfoDto.setStatus(98);
                }
                if (monthrenewePubcheck.getCardOpertype() == 3){
                    monthInfoDto.setStatus(99);
                }
                monthInfoDto.setProductName(monthProduct.getName());
                monthInfoDto.setProductId(monthProduct.getId());
                monthInfoDto.setPlotNum(monthrenewePubcheck.getPlotCount().toString());
                monthInfoDto.setPhone(monthrenewePubcheck.getPhone());
                monthInfoDto.setCardProperty(monthrenewePubcheck.getCardProperty());
                monthInfoDto.setCardOpertype(monthrenewePubcheck.getCardOpertype());
                monthInfoDtos.add(monthInfoDto);
            });
        }
        return monthInfoDtos;
    }

    @Override
    public MonthrenewePubcheck selectByTradeNo(String tradeNo) {
        return getOne(Wrappers.lambdaQuery(MonthrenewePubcheck.class).eq(MonthrenewePubcheck::getTradeNo,tradeNo));
    }

}
