package com.icetech.fee.service.monthcar.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.fee.dao.monthcar.MonthProductRegionMapper;
import com.icetech.fee.domain.entity.monthcar.MonthProductRegion;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.fee.service.monthcar.MonthProductRegionService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 月卡套餐关联区域表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-07-07
 */
@Service
public class MonthProductRegionServiceImpl extends BaseServiceImpl<MonthProductRegionMapper, MonthProductRegion> implements MonthProductRegionService {

    @Autowired
    private ParkRegionDao parkRegionDao;
    /**
     * Description: 根据ID查询 月卡套餐关联区域表对象信息 <br>
     * Version1.0 2022-07-07 by wangzhiwei创建
     *
     * @param id 对象id
     * @return MonthProductRegion
     */
    @Override
    public MonthProductRegion getMonthProductRegionById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  月卡套餐关联区域表对象信息 <br>
     * Version1.0 2022-07-07 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addMonthProductRegion (MonthProductRegion entity) {
        return save(entity);
    }

    /**
     * Description: 修改 月卡套餐关联区域表对象信息 <br>
     * Version1.0 2022-07-07 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyMonthProductRegion (MonthProductRegion entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  月卡套餐关联区域表对象信息 <br>
     * Version1.0 2022-07-07 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeMonthProductRegionById (Long id) {
        return removeById(id);
    }

    @Override
    public String getRegionName(Long productId) {
        List<MonthProductRegion> monthProductRegions = list(Wrappers.lambdaQuery(MonthProductRegion.class).eq(MonthProductRegion::getProductId, productId));
        String regionName = "";
        if (CollectionUtils.isNotEmpty(monthProductRegions)){
            List<Integer> regionIds = monthProductRegions.stream().map(MonthProductRegion::getRegionId).collect(Collectors.toList());
            List<ParkRegion> parkRegions = parkRegionDao.selectBatchIds(regionIds);
            regionName = StrUtil.join("/",parkRegions.stream().map(ParkRegion::getRegionName).collect(Collectors.toList()));
        }
        if (StrUtil.isEmpty(regionName)){
            regionName = "全车场";
        }
        return regionName;
    }

    @Override
    public List<Integer> getRegionIds(Long productId) {
        List<MonthProductRegion> monthProductRegions = list(Wrappers.lambdaQuery(MonthProductRegion.class).eq(MonthProductRegion::getProductId, productId));
        if (CollectionUtils.isNotEmpty(monthProductRegions)){
            return monthProductRegions.stream().map(MonthProductRegion::getRegionId).collect(Collectors.toList());
        }
        return Lists.newArrayList();
  }
}
