package com.icetech.fee.service.monthcar;

import com.icetech.fee.domain.entity.monthcar.MonthProductRegion;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.util.List;

/**
 * 月卡套餐关联区域表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-07-07
 */
public interface MonthProductRegionService extends IBaseService<MonthProductRegion> {

    /**
     * Description: 根据ID查询 月卡套餐关联区域表对象信息 <br>
     * Version1.0 2022-07-07 by wangzhiwei创建
     *
     * @param id 对象id
     * @return MonthProductRegion
     */
    MonthProductRegion getMonthProductRegionById (Long id);

    /**
     * Description: 新增  月卡套餐关联区域表对象信息 <br>
     * Version1.0 2022-07-07 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addMonthProductRegion (MonthProductRegion entity);

    /**
     * Description: 修改 月卡套餐关联区域表对象信息 <br>
     * Version1.0 2022-07-07 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyMonthProductRegion (MonthProductRegion entity);

    /**
     * Description: 删除  月卡套餐关联区域表对象信息 <br>
     * Version1.0 2022-07-07 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeMonthProductRegionById (Long id);


    /**
     * 获取区域名称
     * @param productId
     * @return
     */
    String getRegionName(Long productId);

    /**
     * 获取区域id
     * @param productId
     * @return
     */
    List<Integer> getRegionIds(Long productId);
}
