package com.icetech.fee.dao.vip;

import com.icetech.cloudcenter.domain.response.VipInfoDto;
import com.icetech.fee.domain.entity.vip.VipInfo;
import com.icetech.fee.domain.vo.VipInfoDetail;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.List;

public interface VipInfoDao {
    int deleteByPrimaryKey(Integer id);

    int insert(VipInfo record);

    int insertSelective(VipInfo record);

    VipInfo selectByPrimaryKey(Integer id);

    int updateByPrimaryKeySelective(VipInfo record);

    int updateByPrimaryKey(VipInfo record);

    /**
     * 查询有效期内的vip车辆
     *
     * @param parkId
     * @param plateNum
     * @param regionId
     * @return
     */
    VipInfo selectExpirationDateByPlateNum(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("regionId") Long regionId);

    /**
     * @param parkId
     * @param plateNum
     * @param regionId
     * @return
     */
    VipInfo selectRecentVipCarByPlateNum(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("regionId") Long regionId);

    /**
     * 查询有效VIP信息，暂时只查全免类型
     *
     * @param parkId
     * @return
     */
    List<VipInfoDto> selectValidByParkId(Long parkId);

    /**
     * 模糊查询有效VIP
     *
     * @param parkId
     * @param partOfPlateList
     * @return
     */
    String fuzzyValidatePlate(@Param("parkId") Long parkId, @Param("partOfPlateList") List<String> partOfPlateList);

    VipInfoDetail selectWithTypeById(@Param("vipInfoId") int vipInfoId);

    List<VipInfoDto> selectValidByIds(@Param("ids") List<String> ids);

    List<VipInfo> selectUnexpireds(@Param("parkId") Long parkId, @Param("maxEndDate") LocalDate maxEndDate);


    VipInfo selectVipInfoByParkIdAndTypeId(@Param("parkId") Long parkId, @Param("vipId") Integer vipId);
}
