package com.icetech.fee.dao.storecard;

import com.icetech.cloudcenter.domain.response.StoreCardCountDto;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.fee.domain.entity.storecard.StoreCardPlate;
import com.icetech.db.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * TODO
 *
 * @author zhangpengzhan
 * @date 2020/8/3 9:56
 * @description: 储值卡信息表
 */
public interface StoreCardDao extends BaseDao<StoreCard> {

    /**
     * 根据储值卡号查询储值卡信息
     * @param id
     * @return
     */
    StoreCard selectByCardId(@Param("id") Integer id);

    /**
     *
     * @param parkIds
     * @param parkIds
     * @param parkIds
     * @return
     */
    StoreCardCountDto countStoreCarReport(@Param("parkIds") List<Long> parkIds, @Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 根据储值卡号批量查询储值卡信息
     * @param storeCardPlates
     * @return
     */
    List<StoreCard> selectByCardPlates(@Param("storeCardPlates") List<StoreCardPlate> storeCardPlates);

    /**
     * 更新储值卡余额信息
     * @param storeCard
     * @return
     */
    Integer updateBalance(@Param("storeCard") StoreCard storeCard);

    /**
     * 查询有效储值卡
     * @param parkId
     * @param plateNum
     * @return
     */
    StoreCard selectValidateCard(@Param("parkId") Long parkId, @Param("plateNum") String plateNum);
}
