package com.icetech.fee.dao.monthcar;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 月卡操作记录表
 *
 * Created by xuxueli on '2019-07-08 14:16:01'.
 */
@Repository
public interface MonthRecordDao extends SuperMapper<MonthRecord> {
    default List<MonthRecord> selectByMonthId(long monthInfoId) {
        return selectList(Wrappers.lambdaQuery(MonthRecord.class).eq(MonthRecord::getMonthId, monthInfoId).orderByAsc(MonthRecord::getId));
    }

    /**
     * 通过月卡id列表 查询操作记录ID列表
     * @param ids
     * @return
     */
    default List<Long> getRecordIdListByIds(List<Long> ids) {
        return selectColumnList(MonthRecord::getId, Wrappers.lambdaQuery(MonthRecord.class).in(MonthRecord::getMonthId, ids));
    }
}
