package com.icetech.fee.dao.monthcar;

import com.icetech.fee.domain.entity.monthcar.MonthPlate;
import com.icetech.fee.domain.entity.monthcar.MonthSpace;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface MonthPlateDao {
    /**
     * 插入
     */
    int insert(MonthPlate monthPlate);

    /**
     * 插入车位数
     *
     * @param monthSpace
     * @return
     */
    int insertSpace(MonthSpace monthSpace);

    /**
     * 更新
     */
    int update(MonthPlate monthPlate);

    /**
     * 获取月卡车牌个数
     *
     * @param monthId
     * @return
     */
    int countByMonthId(Long monthId);

    /**
     * 查询车牌号(仅车牌信息)
     *
     * @param monthId
     * @return
     */
    List<String> selectByMonthId(Long monthId);
    /**
     * 查询月卡车绑定信息(所有信息)
     *
     * @param monthId
     * @return
     */
    List<MonthPlate> selectAllByMonthId(Long monthId);

    /**
     * 查询车牌号
     *
     * @param monthIdList
     * @return
     */
    List<MonthPlate> selectByMonthIds(@Param("monthIdList") List<Long> monthIdList);

    /**
     * 通过车牌获取月卡车牌
     *
     * @param plateNums
     * @return
     */
    List<MonthPlate> selectMonthIdByPlateNums(@Param("plateNums") List<String> plateNums);

    /**
     * 查询月卡车绑定信息
     *
     * @param monthId
     * @param current_num
     * @return
     */
    MonthPlate selectByMonthIdAndPlate(@Param("monthId") long monthId, @Param("plateNum") String current_num);

    /**
     * 根据车场ID和所属人查询
     *
     * @param parkId 车场ID
     * @param owner  所属人
     * @return 返回结果集
     */
    List<MonthPlate> selectByParkIdAndOwner(@Param("parkId") Long parkId, @Param("owner") String owner);
}
