package com.icetech.fee.dao.monthcar;

import com.icetech.cloudcenter.domain.response.MonthOrderCountDto;
import com.icetech.park.domain.dto.InvoiceParksDto;
import com.icetech.cloudcenter.domain.response.MonthOrderDto;
import com.icetech.cloudcenter.domain.response.MpMonthInvoiceResponse;
import com.icetech.cloudcenter.domain.response.OrderDto;
import com.icetech.fee.domain.entity.monthcar.MonthOrder;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 *
 *
 * Created by xuxueli on '2019-06-27 11:23:55'.
 */
@Component
public interface MonthOrderDao {

    /**
     * 新增
     */
    int insert(@Param("monthOrder") MonthOrder monthOrder);

    /**
     * 删除
     */
    int delete(@Param("id") int id);

    /**
     * 更新
     */
    int update(@Param("monthOrder") MonthOrder monthOrder);

    /**
     * Load查询
     */
    MonthOrder load(@Param("id") int id);

    MonthOrderDto getMonthOrderDetail(@Param("id") Long id);

    MonthOrderDto getMonthOrderDetailByTradeno(@Param("tradeNo") String tradeNo);

    MonthOrder getMonthOrderByTradeNo(@Param("tradeNo") String tradeNo);


    /**
     * 获取月卡续租的订单信息
     * @param plateNum
     * @param startTime
     * @param endTime
     * @return
     */
    List<OrderDto> selectMpOrderByPlateNum(@Param("mpUserId") Integer mpUserId,@Param("plateNum") String plateNum, @Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     * 获取月卡交易订单列表
     * @param mpUserId
     * @param startTime
     * @param endTime
     * @return
     */
    List<MonthOrderDto> selectMonthOrderList(@Param("mpUserId") Integer mpUserId,@Param("optionTypes") List<Integer> optionTypes,@Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     * 查询月卡交易订单
     * @param accountId
     * @param plateNum
     * @param bizType
     * @param startTime
     * @param endTime
     * @return
     */
    List<MonthOrderDto> selectMonthOrderListV2(@Param("accountId") Long accountId,@Param("plateNum") String plateNum,@Param("bizType") Integer bizType,@Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     * 统计月卡订单
     * @param accountId
     * @param plateNum
     * @param bizType
     * @param startTime
     * @param endTime
     * @return
     */
    MonthOrderCountDto countMonthOrder(@Param("accountId") Long accountId,@Param("plateNum") String plateNum,@Param("bizType") Integer bizType,@Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     * 根据订单号查询月卡交易明细
     * @param tradeNo
     * @param payStatus
     * @return
     */
    MonthOrder selectByTradeNoAndPayStatus(@Param("tradeNo")String tradeNo, @Param("payStatus")Integer payStatus);

    /**
     * 查询待开票记录
`     *
     * @param parkId
     * @param startTime
     * @param endTime
     * @param plateNums
     * @return
     */
    List<MpMonthInvoiceResponse> getMonthInvoiceRecords(@Param("parkId") Long parkId,@Param("bizType") Integer bizType, @Param("startTime") Long startTime, @Param("endTime") Long endTime,@Param("accountId") Long accountId, @Param("plateNums")List<String> plateNums);

    /**
     * 查询月卡记录
     * @param accountId
     * @param bizType
     * @param startTime
     * @param endTime
     * @param plateNums
     * @return
     */
    List<InvoiceParksDto> getMonthInvoiceParks(@Param("accountId") Long accountId,@Param("bizType") Integer bizType,@Param("startTime")Long startTime, @Param("endTime")Long endTime, @Param("plateNums")List<String> plateNums);

    /**
     *
     * @param tradeNos
     * @return
     */
    List<MonthOrder> getMonthMonthOrderByTradeNos(@Param("tradeNos")List<String> tradeNos);

    /**
     *
     * @param tradeNos
     */
    int batchUpdateInvoiceStatus(@Param("tradeNos")List<String> tradeNos);

    List<MonthOrder> selectMonthOrderListBy(@Param("parkId")Long parkId, @Param("date") Date date);

}
