package com.icetech.fee.dao.monthcar;

import com.icetech.cloudcenter.domain.request.MonthCarRequest;
import com.icetech.cloudcenter.domain.response.MonthCardDto;
import com.icetech.cloudcenter.domain.response.MonthInfoDto;
import com.icetech.cloudcenter.domain.response.MonthProductDto;
import com.icetech.cloudcenter.domain.response.MonthReportDto;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

public interface MonthInfoDao {
    /**
     * 新增
     */
    int insert(MonthInfo record);

    /**
     * 删除
     */
    int delete(@Param("id") long id);

    /**
     * 更新
     */
    int update(@Param("monthInfo") MonthInfo monthInfo);

    int updateById(MonthInfo monthInfo);

    /**
     * Load查询
     */
    MonthInfo load(@Param("id") long id);

    /**
     * 查询月卡操作记录
     *
     * @param parkId
     * @param plateNumber
     * @param startTime
     * @param endTime
     * @param cardOwner
     * @return
     */
    List<MonthInfoDto> selectMonthRecords(@Param("parkId") String parkId, @Param("plateNumber") String plateNumber, @Param("cardStatus") List<Integer> cardStatus, @Param("startTime") String startTime,
                                          @Param("endTime") String endTime, @Param("cardOwner") String cardOwner,
                                          @Param("telephone") String telephone, @Param("productName") String productName,
                                          @Param("validDay") String validDays, @Param("cardProperty") Integer cardProperty);

    /**
     * 获取详情信息
     *
     * @param id
     * @param recordId
     * @return
     */
    MonthInfoDto selectMonthRecord(@Param("parkId") Long id, @Param("recordId") Integer recordId);

    /**
     * 根据车场ID和车牌号查询有效月卡信息
     *
     * @param parkId
     * @param plateNum
     * @param cardStatus
     * @return
     */
    MonthInfo selectByPlateNum(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("cardStatus") Integer cardStatus);

    MonthInfo selectByRegionPlateNum(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("regionId") Long regionId, @Param("cardStatus") Integer cardStatus);

    /**
     * 查询月卡的扩展信息
     *
     * @param monthCarRequest
     * @return
     */
    MonthInfoDto selectMonthCarExtend(MonthCarRequest monthCarRequest);

    /**
     * 获取月卡开卡记录
     *
     * @param searchKey
     * @return
     */
    List<MonthInfoDto> selectMonthCarList(@Param("searchKey") String searchKey);

    /**
     * 小程序查询月卡信息
     * @param plateNum
     * @param plateNums
     * @return
     */
    List<MonthInfoDto> selectAppletMonthCarListByPlateNum(@Param("plateNum") String plateNum,@Param("plateNums") List<String> plateNums);
    List<MonthInfoDto> selectAppletMonthCarListByPhone(@Param("phone") String phone,@Param("plateNums") List<String> plateNums);

    /**
     * 根据车牌号查询
     * @param searchKey
     * @return
     */
    List<MonthInfoDto> selectMonthCarListByPlateNum(@Param("searchKey") String searchKey);

    /**
     * 获取车场的月卡产品
     *
     * @param parkId
     * @return
     */
    List<MonthProductDto> selectMonthProductByParkId(@Param("parkId") Long parkId);

    /**
     * 查询月卡绑定车牌
     */
    List<String> selectPlateNums(@Param("monthId") long monthId);

    /**
     * 获取月卡绑定的车位
     *
     * @param monthId
     * @return
     */
    List<String> selectSpaces(@Param("monthId") Long monthId);

    int insertMonthPlate(@Param("monthId") long monthId, @Param("plateNum") String plateNum);

    int deleteMonthPlate(@Param("monthId") long monthId);

    int insertMonthSpace(@Param("monthId") long monthId, @Param("space") String space);

    int countMonthRecords(@Param("parkId") String parkId, @Param("plateNumber") String plateNumber, @Param("cardStatus") List<Integer> cardStatus, @Param("startTime") String startTime, @Param("endTime") String endTime,
                          @Param("cardOwner") String cardOwner, @Param("telephone") String telephone, @Param("productName") String productName,
                          @Param("validDay") String validDay, @Param("cardProperty") Integer cardProperty);

    int countMonthRecords(@Param("parkId") Long parkId, @Param("plateNumber") String plateNumber, @Param("cardStatus") List<Integer> cardStatus, @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("cardOwner") String cardOwner);

    MonthInfo selectByMainPlateNum(@Param("parkId") Long parkId, @Param("plateNumber") String carNum);

    MonthReportDto countMonthCarReport(@Param("parkId") String parkId, @Param("startTime") String startTime, @Param("endTime") String endTime);

    MonthReportDto getMonthCardReport(@Param("parkId") String parkId, @Param("startTime") String startTime, @Param("endTime") String endTime);


    List<MonthCardDto> selectValidByParkId(Long parkId);

    List<MonthCardDto> selectValidByIds(@Param("ids") List<String> ids);

    /**
     * 模糊查询有效月卡
     *
     * @param parkId
     * @param partOfPlateList
     * @return
     */
    String fuzzyValidatePlate(@Param("parkId") Long parkId, @Param("partOfPlateList") List<String> partOfPlateList);

    /**
     * 根据月卡id 区域 id查询是否存在区域月卡
     *
     * @param monthId
     * @param regionId
     * @return
     */
    int isConstantMonthRegion(@Param("monthId") Long monthId, @Param("regionId") Long regionId);

    /**
     * 根据车牌获取所有的开卡记录
     *
     * @param plateNums
     * @param parkId
     * @return
     */
    List<MonthInfo> selectMonthCarByPlateNum(@Param("plateNums") List<String> plateNums, @Param("parkId") Long parkId);

    List<MonthCardDto> selectMonthListByParkId(@Param("parkId") Long parkId);

    List<MonthInfoDto> getMpUserMonthInfo(@Param("mpUserId") Integer mpUserId);
    MonthInfo selectByParkIdAndThirdId(@Param("parkId") Long parkId, @Param("thirdMonthId") Long thirdMonthId);

    /**
     * 根据车场ID和归属人查询月卡信息
     * @param parkId 车场ID
     * @param cardOwner 归属人
     * @return 返回月卡信息
     */
    List<MonthInfo> selectByParkIdAndOwner(@Param("parkId") Long parkId, @Param("cardOwner") String cardOwner);

    List<MonthInfo> selectUnexpireds(@Param("parkId") Long parkId, @Param("maxEndDate") LocalDate maxEndDate);

    List<MonthInfo> getMonthInfoBy(@Param("ids") List<Long> ids, @Param("cardStatus") Integer cardStatus, @Param("time") Date time);

    List<MonthInfo> selectMonthInfos(@Param("parkId") Long parkId, @Param("date")Date date);

    /**
     * 查询线上月卡剩余购买数量
     *
     * @param productIds 月卡ID
     * @return int
     */
    List<MonthInfo> getMonthInfosByProductIds(@Param("productIds") List<Long> productIds);

    /**
     * 获取当前车牌&月卡ID的[生效中&带生效]开卡记录
     */
    List<MonthInfo> getMonthInfosByProductIdAndPlateNum(@Param("plateNum") String plateNum, @Param("productId") Integer productId);

}
