package com.icetech.fee.dao.merchant;

import com.icetech.fee.domain.entity.merchant.MerchantDiscount;
import com.icetech.db.dao.BaseDao;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 商户优惠模板表
 *
 * Created by xuxueli on '2019-02-15 14:38:03'.
 */
@Component
public interface MerchantDiscountDao extends BaseDao<MerchantDiscount> {

    /**
     * 查询改商户下的优惠券类型 在有效期内
     * @param merchantId
     * @return
     */
    List<MerchantDiscount> selectByMerchantId(Long merchantId);

    /**
     * 获取按天优免的优惠类型
     * @param merchantId
     * @return
     */
    MerchantDiscount selectDayDisByMerchantId(Long merchantId);

    /**
     * 获取详情信息
     * @param disId
     * @return
     */
    MerchantDiscount findById(Long disId);
}
