package com.icetech.fee.domain.entity.storecard;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

@Data
@TableName("ice_storedcard_used")
public class StoreCardUsed implements Serializable {
    /** 主键自增长id **/
    @TableId("id")
    protected Long id;
    /** 车场id **/
    @TableField("park_id")
    protected Long parkId;
    /** 订单号 **/
    @TableField("order_num")
    protected String orderNum;
    /** 车牌号 **/
    @TableField("plate_num")
    protected String plateNum;
    /** 入场时间 **/
    @TableField("enter_time")
    protected Long enterTime;
    /** 离场时间 **/
    @TableField("exit_time")
    protected Long exitTime;
    /** 支付时间 **/
    @TableField("pay_time")
    protected Date payTime;
    /** 应收金额 **/
    @TableField("total_price")
    protected Double totalPrice;
    /** 优惠金额 **/
    @TableField("discount_price")
    protected Double discountPrice;
    /** 储值卡表id **/
    @TableField("card_id")
    protected Long cardId;
    /** 储值卡扣减前金额 **/
    @TableField("card_before_amount")
    protected Double cardBeforeAmount;
    /** 储值卡扣减金额 **/
    @TableField("card_deduct_amount")
    protected Double cardDeductAmount;
    /** 储值卡扣减后金额 **/
    @TableField("card_after_amount")
    protected Double cardAfterAmount;
    /** 备注 **/
    @TableField("remark")
    protected String remark;
    /** 创建时间 **/
    @TableField("create_time")
    protected Date createTime;
}
