package com.icetech.fee.domain.entity.monthcar;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 月卡信息
 * @author wangzw
 */
@Data
public class MonthInfo implements Serializable {
    /**
     * 主键自增长id
     */
    private Long id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 申办性质 1个人 2公司
     */
    private int cardProperty;

    /**
     * 月卡所属人姓名/公司名称
     */
    private String cardOwner;

    /**
     * 手机号码
     */
    private String phone;

    /**
     * 产品id
     */
    private Long productId;

    /**
     * 主车牌号
     */
    private String mainPlate;

    /**
     * 车位数
     */
    private int plotCount;

    /**
     * 购买数量
     */
    private int count;

    /**
     *
     */
    private BigDecimal saleMoney;

    /**
     *
     */
    private BigDecimal payMoney;

    /**
     * 支付方式(0 现金，1 银行卡 2：微信 3：支付宝)
     */
    private int payMethod;

    /**
     * 月卡有效开始日期
     */
    private Date startTime;

    /**
     * 月卡有效结束日期
     */
    private Date endTime;

    /**
     * 月卡状态 1 生效中 2 待生效 3 已退费 4 已过期 5 冻结
     */
    private int cardStatus;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;
    /**
     * 状态（0：正常，1：删除，默认0）
     */
    private Integer deleteStatus;
    /**
     * 第三方月卡Id
     */
    private Long thirdMonthId;
    /**
     * 集团月卡标识0月卡，1 多车场月卡 默认0
     */
    private Integer moreMonthType;
    /**
     * 集团月卡id
     */
    private Long moreMonthId;

    /**
     * 支付渠道
     * 支付渠道 1 云平台 2：App 3：公众号
     */
    private Integer payChannel;
}
