package com.icetech.fee.domain.entity.monthcar;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 月卡线上开通申请表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-04-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_month_apply_record")
public class MonthApplyRecord implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车主姓名
     */
    private String ownerName;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 诉求描述
     */
    private String remark;

    /**
     * 申请类型 2=月卡续租 5=月卡开卡
     */
    private Integer bizType;

    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    private Long createId;


}
