package com.icetech.fee.domain.entity.merchant;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 商户充值记录表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-06-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_merchant_recharge")
public class MerchantRecharge implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场id
     */
    private Integer parkId;

    /**
     * 商户id
     */
    private Integer merchantId;

    /**
     * 充值金额
     */
    private BigDecimal rechargePrice;

    /**
     * 商户余额
     */
    private BigDecimal balance;

    /**
     * 充值时间
     */
    private Date rechargeTime;

    /**
     * 充值方式,1:saas平台 2:微信小程序
     */
    private Integer rechargeType;

    /**
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 操作人
     */
    private String operator;

    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 实付金额
     */
    private BigDecimal payMoney;

    /**
     * 缴费方式1现金，2微信，3支付宝
     */
    private Integer payWay;


}
