/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.freespace;

import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.service.freespace.UpdateFreeSpaceService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="updateRegionFreeSpaceService")
public class UpdateRegionFreeSpaceServiceImpl
implements UpdateFreeSpaceService {
    private static final Logger log = LoggerFactory.getLogger(UpdateRegionFreeSpaceServiceImpl.class);
    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;

    @Override
    public int resetFreeSpace(Long parkId) {
        List<ParkRegion> parkRegions = this.parkRegionDao.selectByParkid(parkId);
        int i = 0;
        if (parkRegions != null && !parkRegions.isEmpty()) {
            for (ParkRegion parkRegion : parkRegions) {
                i += this.parkRegionDao.updateFreeParkById(parkRegion.getId());
            }
            if (i > 0) {
                this.parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(parkId));
            }
        }
        return i;
    }

    @Override
    public int updateFreeSpace(Long parkId, Long regionId, int freeSpace) {
        if (regionId == null) {
            return 0;
        }
        ParkRegion parkRegionUpdate = new ParkRegion();
        parkRegionUpdate.setId(regionId);
        parkRegionUpdate.setFreePark(Integer.valueOf(freeSpace));
        parkRegionUpdate.setRealFreePark(Integer.valueOf(freeSpace));
        int i = this.parkRegionDao.updateById(parkRegionUpdate);
        if (i > 0) {
            this.parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(parkId));
        }
        return i;
    }

    @Override
    public int addFreeSpace(Long parkId, Long regionId, int num) {
        if (regionId == null) {
            return 0;
        }
        int i = this.parkRegionDao.addFreeSpaceByPark(regionId, num);
        if (i > 0) {
            this.parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(parkId));
        }
        return i;
    }

    @Override
    public int syncFreeSpace(Long parkId, Long regionId) {
        if (regionId == null) {
            return 0;
        }
        int i = this.parkRegionDao.updateFreeParkById(regionId);
        if (i > 0) {
            this.parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(parkId));
        }
        return i;
    }

    @Override
    public int syncFreeSpaceByRegions(Collection<Long> parkIds, Collection<Long> regionIds) {
        int i = this.parkRegionDao.updateFreeParkByIds(regionIds);
        if (i > 0) {
            this.parkFreespaceDao.calculateFreeSpaceByParks(parkIds);
        }
        return i;
    }
}

