/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.factory;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.freespace.UpdateFreeSpaceService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateFreeSpaceServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(UpdateFreeSpaceServiceFactory.class);
    @Resource
    private ParkService parkService;
    @Autowired
    private Map<String, UpdateFreeSpaceService> updateFreeSpaceServiceMap = new HashMap<String, UpdateFreeSpaceService>();

    public UpdateFreeSpaceService getUpdateFreeSpaceService(Long parkId) {
        if (this.isInteriorPark(parkId)) {
            return this.updateFreeSpaceServiceMap.get("updateRegionFreeSpaceService");
        }
        return this.updateFreeSpaceServiceMap.get("updateParkFreeSpaceService");
    }

    private boolean isInteriorPark(Long parkId) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        if (ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            Park park = (Park)parkObjectResponse.getData();
            return Integer.valueOf(1).equals(park.getIsInterior());
        }
        return false;
    }
}

