/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.basics.utils;

public class MapDistanceUtil {
    private static double EARTH_RADIUS = 6371000.0;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lon1, double lat1, double lon2, double lat2) {
        double radLat1 = MapDistanceUtil.rad(lat1);
        double radLat2 = MapDistanceUtil.rad(lat2);
        double a = radLat1 - radLat2;
        double b = MapDistanceUtil.rad(lon1) - MapDistanceUtil.rad(lon2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= EARTH_RADIUS;
        s = Math.round(s * 10000.0) / 10000L;
        return s;
    }

    public static double distance(double centerLon, double centerLat, double targetLon, double targetLat) {
        double jl_jd = 102834.74258026089;
        double jl_wd = 111712.69150641056;
        double b = Math.abs((centerLat - targetLat) * jl_jd);
        double a = Math.abs((centerLon - targetLon) * jl_wd);
        return Math.sqrt(a * a + b * b);
    }
}

