/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.basics.service.other;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.icetech.basics.dao.NotWorkDayMapper;
import com.icetech.basics.domain.entity.NotWorkDay;
import com.icetech.basics.service.other.NotWorkDayService;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NotWorkDayServiceImpl
extends BaseServiceImpl<NotWorkDayMapper, NotWorkDay>
implements NotWorkDayService {
    private static final Logger log = LoggerFactory.getLogger(NotWorkDayServiceImpl.class);
    private static final String url = "https://apis.tianapi.com/jiejiari/index";
    private static final String key = "a784907f951f238bbb427f3d13568d6a";

    @Override
    @Transactional
    public List<String> queryNotDays(Integer year) {
        List notWorkDays = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(NotWorkDay::getYmd, (Object)year)).list();
        if (CollectionUtils.isEmpty((Collection)notWorkDays)) {
            if (year - LocalDate.now().getYear() > 1) {
                throw new ResponseBodyException("404", "\u672a\u53d1\u5e03\u8282\u5047\u65e5\u4fe1\u606f");
            }
            if (year - LocalDate.now().getYear() == 1 && LocalDate.now().getMonthValue() < 12) {
                throw new ResponseBodyException("404", "\u672a\u53d1\u5e03\u8282\u5047\u65e5\u4fe1\u606f");
            }
            List<DayInfo> onlineNotWorkDay = NotWorkDayServiceImpl.getOnlineNotWorkDay(year);
            if (CollectionUtils.isEmpty(onlineNotWorkDay)) {
                throw new ResponseBodyException("404", "\u672a\u83b7\u53d6\u5230\u975e\u5de5\u4f5c\u65e5\u6570\u636e");
            }
            if (onlineNotWorkDay.stream().noneMatch(info -> info.getDate().contains(year + "-10-01"))) {
                throw new ResponseBodyException("404", "\u672a\u53d1\u5e03\u8282\u5047\u65e5\u4fe1\u606f");
            }
            notWorkDays = onlineNotWorkDay.stream().map(info -> {
                NotWorkDay notWorkDay = new NotWorkDay();
                notWorkDay.setYmd(LocalDate.parse(info.getDate(), DateUtils.DEFAULT_DATE_FORMAT));
                return notWorkDay;
            }).collect(Collectors.toList());
            this.saveBatch(notWorkDays);
        }
        return notWorkDays.stream().map(notWorkDay -> notWorkDay.getYmd().format(DateUtils.DEFAULT_DATE_FORMAT)).collect(Collectors.toList());
    }

    public static List<DayInfo> getOnlineNotWorkDay(int year) {
        ArrayList<DayInfo> notWorkDayList = new ArrayList<DayInfo>();
        for (int i = 0; i < 12; ++i) {
            List<DayInfo> noWorkDay = NotWorkDayServiceImpl.getOnlineNotWorkDay(year, i + 1);
            notWorkDayList.addAll(noWorkDay);
        }
        return notWorkDayList;
    }

    public static List<DayInfo> getOnlineNotWorkDay(int year, int month) {
        LocalDate start = LocalDate.of(year, month, 1);
        LocalDate lastDayOfMonth = start.withDayOfMonth(start.lengthOfMonth());
        String fullUrl = "https://apis.tianapi.com/jiejiari/index?key=a784907f951f238bbb427f3d13568d6a&type=3&date=" + DateUtils.DEFAULT_DATE_FORMAT.format(start) + "~" + DateUtils.DEFAULT_DATE_FORMAT.format(lastDayOfMonth);
        String response = HttpUtil.get((String)fullUrl);
        log.info("\u8bf7\u6c42\u5f00\u653e\u63a5\u53e3\u53c2\u6570[{}], \u54cd\u5e94[{}]", (Object)fullUrl, (Object)response);
        if (!StringUtils.startsWith((CharSequence)response, (CharSequence)"{")) {
            log.warn("[\u76d1\u63a7\u57cb\u70b9] \u8bf7\u6c42\u5f00\u653e\u63a5\u53e3\u83b7\u53d6\u975e\u5de5\u4f5c\u65e5\u5931\u8d25, response[{}]", (Object)response);
            return Collections.emptyList();
        }
        JSONObject map = JSON.parseObject((String)response);
        if (map.getIntValue("code", 0) != 200) {
            log.warn("[\u76d1\u63a7\u57cb\u70b9] \u8bf7\u6c42\u5f00\u653e\u63a5\u53e3\u83b7\u53d6\u975e\u5de5\u4f5c\u65e5\u5931\u8d25, response[{}]", (Object)response);
            return Collections.emptyList();
        }
        return map.getJSONObject("result").getJSONArray("list").toList(DayInfo.class, new JSONReader.Feature[0]).stream().filter(info -> DayInfo.DAY_CODE_HOLIDAY.equals(info.getDaycode()) || DayInfo.DAY_CODE_WEEKEND.equals(info.getDaycode())).collect(Collectors.toList());
    }

    private static int convertDateType(Integer dayCode) {
        if (DayInfo.DAY_CODE_HOLIDAY.equals(dayCode)) {
            return NotWorkDay.DATE_TYPE_HOLIDAY;
        }
        if (DayInfo.DAY_CODE_WEEKEND.equals(dayCode)) {
            return NotWorkDay.DATE_TYPE_WEEKEND;
        }
        if (DayInfo.DAY_CODE_SWAPDAY.equals(dayCode)) {
            return NotWorkDay.DATE_TYPE_SWAPDAY;
        }
        return NotWorkDay.DATE_TYPE_WORKDAY;
    }

    private static class DayInfo {
        protected String date;
        protected Integer daycode;
        protected Integer weekday;
        protected String cnweekday;
        protected String lunaryear;
        protected String lunarmonth;
        protected String lunarday;
        protected String info;
        protected Integer start;
        protected Integer now;
        protected Integer end;
        protected String holiday;
        protected String name;
        protected String enname;
        protected Integer isnotwork;
        protected String[] vacation;
        protected String remark;
        protected Integer wage;
        protected String tip;
        protected String rest;
        public static final Integer DAY_CODE_WORKDAY = 0;
        public static final Integer DAY_CODE_HOLIDAY = 1;
        public static final Integer DAY_CODE_WEEKEND = 2;
        public static final Integer DAY_CODE_SWAPDAY = 3;

        public String getDate() {
            return this.date;
        }

        public Integer getDaycode() {
            return this.daycode;
        }

        public Integer getWeekday() {
            return this.weekday;
        }

        public String getCnweekday() {
            return this.cnweekday;
        }

        public String getLunaryear() {
            return this.lunaryear;
        }

        public String getLunarmonth() {
            return this.lunarmonth;
        }

        public String getLunarday() {
            return this.lunarday;
        }

        public String getInfo() {
            return this.info;
        }

        public Integer getStart() {
            return this.start;
        }

        public Integer getNow() {
            return this.now;
        }

        public Integer getEnd() {
            return this.end;
        }

        public String getHoliday() {
            return this.holiday;
        }

        public String getName() {
            return this.name;
        }

        public String getEnname() {
            return this.enname;
        }

        public Integer getIsnotwork() {
            return this.isnotwork;
        }

        public String[] getVacation() {
            return this.vacation;
        }

        public String getRemark() {
            return this.remark;
        }

        public Integer getWage() {
            return this.wage;
        }

        public String getTip() {
            return this.tip;
        }

        public String getRest() {
            return this.rest;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public void setDaycode(Integer daycode) {
            this.daycode = daycode;
        }

        public void setWeekday(Integer weekday) {
            this.weekday = weekday;
        }

        public void setCnweekday(String cnweekday) {
            this.cnweekday = cnweekday;
        }

        public void setLunaryear(String lunaryear) {
            this.lunaryear = lunaryear;
        }

        public void setLunarmonth(String lunarmonth) {
            this.lunarmonth = lunarmonth;
        }

        public void setLunarday(String lunarday) {
            this.lunarday = lunarday;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public void setStart(Integer start) {
            this.start = start;
        }

        public void setNow(Integer now) {
            this.now = now;
        }

        public void setEnd(Integer end) {
            this.end = end;
        }

        public void setHoliday(String holiday) {
            this.holiday = holiday;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setEnname(String enname) {
            this.enname = enname;
        }

        public void setIsnotwork(Integer isnotwork) {
            this.isnotwork = isnotwork;
        }

        public void setVacation(String[] vacation) {
            this.vacation = vacation;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public void setWage(Integer wage) {
            this.wage = wage;
        }

        public void setTip(String tip) {
            this.tip = tip;
        }

        public void setRest(String rest) {
            this.rest = rest;
        }

        public String toString() {
            return "NotWorkDayServiceImpl.DayInfo(date=" + this.getDate() + ", daycode=" + this.getDaycode() + ", weekday=" + this.getWeekday() + ", cnweekday=" + this.getCnweekday() + ", lunaryear=" + this.getLunaryear() + ", lunarmonth=" + this.getLunarmonth() + ", lunarday=" + this.getLunarday() + ", info=" + this.getInfo() + ", start=" + this.getStart() + ", now=" + this.getNow() + ", end=" + this.getEnd() + ", holiday=" + this.getHoliday() + ", name=" + this.getName() + ", enname=" + this.getEnname() + ", isnotwork=" + this.getIsnotwork() + ", vacation=" + Arrays.deepToString(this.getVacation()) + ", remark=" + this.getRemark() + ", wage=" + this.getWage() + ", tip=" + this.getTip() + ", rest=" + this.getRest() + ")";
        }
    }
}

