/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.basics.service.charge;

import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.charge.ChargeDuration;
import com.icetech.basics.domain.entity.charge.ChargeOnce;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.domain.charge.detail.Charge24HourDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeDayNightDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeNaturalDayDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeTypeDetail;
import com.icetech.cloudcenter.domain.charge.dto.ChargeConfigCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.ChargeRuleCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.DayNightChargeCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.DyrationChargeCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.NaturalChargeCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.OnceChargeCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.charge.dto.S24HoursChargeCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.S24HoursRateCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.StepChargeCfgDTO;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFeeParamHolder {
    private static final Logger log = LoggerFactory.getLogger(BaseFeeParamHolder.class);
    protected boolean isBreak;
    protected QueryOrderFeeRequest queryOrderFeeRequest;
    protected QueryOrderFeeResponse queryOrderFeeResponse;
    protected OrderInfo orderInfo;
    protected ParkConfig parkConfig;
    protected Map<Integer, ParkChargeconfig> parkChargeconfigMap = new LinkedHashMap<Integer, ParkChargeconfig>();
    protected Park park;
    protected ChargeService chargeService;
    protected ParkChargeconfigDao parkChargeconfigDao;
    protected VipType vipType;
    protected OrderSumFeeDto orderSumFeeDto;
    protected OrderSonInfo innerOrderSonInfo;
    protected Set<Integer> billIdList;
    protected Set<Integer> innerBillIdList;
    protected String sChargeConfigCfg;
    protected Map<Integer, String> sChargeRuleMap = new HashMap<Integer, String>();
    protected Long startTime;
    protected Long endTime;
    protected Long queryTime;
    protected Long parkTime;
    protected BigDecimal surplusfee;
    protected boolean isMonthCarFee = false;
    protected boolean isCsMonthCarFee;
    protected int csFeeType;
    protected String csStartTime;
    protected String csEndTime;
    protected Long csSwitchTime;
    protected float thisFee;
    protected boolean isUseFreetime;
    protected List<ExtraComputeFeePara> extraComputeFeeParaList = new ArrayList<ExtraComputeFeePara>();

    public String getSChargeConfigCfg(ParkConfig parkConfig) {
        if (this.sChargeConfigCfg == null) {
            ChargeConfigCfgDTO chargeConfigCfgDTO = ChargeConfigCfgDTO.builder().sBill_precision(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getBillPrecision()))).sFreetime_status(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getFreetimeStatus(), (int)2))).sIs_filltime(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getIsFilltime(), (int)1))).sOvertime_bill_type(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getOvertimeBillType(), (int)1))).sIsallowfreetmonce(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getIsallowfreetmonce(), (int)1))).sIsnotgetsmallchange(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getIsnotgetsmallchange(), (int)1))).sSwitch_type(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getSwitchType(), (int)1))).sChargeVersionNum(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getChargeVersionNum()))).build();
            this.sChargeConfigCfg = JsonUtils.toString((Object)chargeConfigCfgDTO);
        }
        return this.sChargeConfigCfg;
    }

    public ChargeRuleCfgDTO getSChargeRuleObj() {
        return this.getSChargeRuleObj(this.getParkChargeConfig());
    }

    public ChargeRuleCfgDTO getSChargeRuleObj(Integer billId) {
        return this.getSChargeRuleObj(this.parkChargeconfigMap.get(billId));
    }

    public ChargeRuleCfgDTO getSChargeRuleObj(ParkChargeconfig parkChargeconfig) {
        ObjectResponse charge24chargeObjectResponse;
        ChargeRuleCfgDTO chargeRuleCfg = new ChargeRuleCfgDTO();
        chargeRuleCfg.setSBilltypecode(parkChargeconfig.getBilltypecode());
        chargeRuleCfg.setSBilltype(parkChargeconfig.getBilltype());
        if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u901a\u7528\u81ea\u7136\u5929.type) {
            ObjectResponse naturaldayObjectResponse = this.chargeService.getNaturalday(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess((Response)naturaldayObjectResponse)) {
                ChargeNaturalDayDetail data1 = (ChargeNaturalDayDetail)naturaldayObjectResponse.getData();
                NaturalChargeCfgDTO naturalChargeCfgDTO = NaturalChargeCfgDTO.builder().sFreetime(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getFreetime()))).sDaynightmaxfeeusing(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getDaynightmaxfeeusing()))).sDaynightmaxfee(data1.getDaynightmaxfee()).sMaxfeetype(data1.getMaxFeeType()).sDaynightmaxfee_big(data1.getDaynightmaxfeeBig()).sBillmethod(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getBillmethod()))).sNoworkBillmethod(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getNoworkBillmethod()))).sIsspecialdaycharge(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getIsspecialdaycharge(), (int)2))).build();
                ChargeTypeDetail workdayDetail = data1.getWorkdayDetail();
                ChargeTypeDetail holidayDetail = data1.getHolidayDetail();
                if (NumberUtils.toPrimitive((Integer)workdayDetail.getChargeType()) == 1) {
                    OnceChargeCfgDTO onceChargeCfgDTO = this.buildOnceChargeCfg(workdayDetail);
                    naturalChargeCfgDTO.setSWork_OnceCharge(onceChargeCfgDTO);
                } else {
                    DyrationChargeCfgDTO dyrationChargeCfgDTO = this.buildDyrationChargeCfg(workdayDetail);
                    naturalChargeCfgDTO.setSWork_DyrationCharge(dyrationChargeCfgDTO);
                }
                if (Integer.valueOf(1).equals(data1.getIsspecialdaycharge())) {
                    if (NumberUtils.toPrimitive((Integer)holidayDetail.getChargeType()) == 1) {
                        OnceChargeCfgDTO onceChargeCfgDTO2 = this.buildOnceChargeCfg(holidayDetail);
                        naturalChargeCfgDTO.setSNoWork_OnceCharge(onceChargeCfgDTO2);
                    } else {
                        DyrationChargeCfgDTO dyrationChargeCfgDTO2 = this.buildDyrationChargeCfg(holidayDetail);
                        naturalChargeCfgDTO.setSNoWork_DyrationCharge(dyrationChargeCfgDTO2);
                    }
                }
                chargeRuleCfg.setSNaturalCharge(naturalChargeCfgDTO);
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u767d\u5929\u591c\u95f4\u6536\u8d39.type) {
            ObjectResponse chargeDaynightObjectResponse = this.chargeService.getDaynight(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess((Response)chargeDaynightObjectResponse)) {
                ChargeDayNightDetail data1 = (ChargeDayNightDetail)chargeDaynightObjectResponse.getData();
                DayNightChargeCfgDTO dayNightChargeCfgDTO = DayNightChargeCfgDTO.builder().sBillmethodday(data1.getBillmethodday()).sBillmethodnight(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getBillmethodnight()))).sFreetime(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getFreetime()))).sDaynightmaxfeeusing(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getDaynightmaxfeeusing()))).sMaxfeetype(data1.getMaxFeeType()).sDaynightmaxfee(data1.getDaynightmaxfee()).sDaynightmaxfee_big(data1.getDaynightmaxfeeBig()).sDaybegin(data1.getDaybegin()).sNightbegin(data1.getNightbegin()).sDaymaxfeeusing(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getDaymaxfeeusing(), (int)2))).sDaymaxfee(data1.getDaymaxfee()).sDaymaxfee_big(data1.getDaymaxfeeBig()).sNightmaxfeeusing(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getNightmaxfeeusing(), (int)2))).sNightmaxfee(data1.getNightmaxfee()).sNightmaxfee_big(data1.getNightmaxfeeBig()).build();
                ChargeTypeDetail dayDetail = data1.getDailyDetail();
                ChargeTypeDetail nightlyDetail = data1.getNightlyDetail();
                if (NumberUtils.toPrimitive((Integer)dayDetail.getChargeType()) == 1) {
                    OnceChargeCfgDTO onceChargeCfgDTO = this.buildOnceChargeCfg(dayDetail);
                    dayNightChargeCfgDTO.setSDay_OnceCharge(onceChargeCfgDTO);
                } else {
                    DyrationChargeCfgDTO dyrationChargeCfgDTO = this.buildDyrationChargeCfg(dayDetail);
                    dayNightChargeCfgDTO.setSDay_DyrationCharge(dyrationChargeCfgDTO);
                }
                if (NumberUtils.toPrimitive((Integer)nightlyDetail.getChargeType()) == 1) {
                    OnceChargeCfgDTO onceChargeCfgDTO2 = this.buildOnceChargeCfg(nightlyDetail);
                    dayNightChargeCfgDTO.setSNight_OnceCharge(onceChargeCfgDTO2);
                } else {
                    DyrationChargeCfgDTO dyrationChargeCfgDTO2 = this.buildDyrationChargeCfg(nightlyDetail);
                    dayNightChargeCfgDTO.setSNight_DyrationCharge(dyrationChargeCfgDTO2);
                }
                chargeRuleCfg.setSDayNightCharge(dayNightChargeCfgDTO);
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u4e8c\u5341\u56db\u5c0f\u65f6\u8ba1\u8d39.type && ObjectResponse.isSuccess((Response)(charge24chargeObjectResponse = this.chargeService.get24Hours(parkChargeconfig.getBilltypecode())))) {
            Charge24HourDetail data1 = (Charge24HourDetail)charge24chargeObjectResponse.getData();
            S24HoursChargeCfgDTO s24HoursChargeCfgDTO = S24HoursChargeCfgDTO.builder().sFreetime(data1.getFreetime()).sDaynightmaxfeeusing(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getDaynightmaxfeeusing()))).sMaxfeetype(data1.getMaxFeeType()).sDaynightmaxfee(data1.getDaynightmaxfee()).sDaynightmaxfee_big(data1.getDaynightmaxfeeBig()).sDivisionTime(data1.getDivisionTime()).sIsOverTimeSet(Integer.valueOf(NumberUtils.toPrimitive((Integer)data1.getIsOverTimeSet(), (int)2))).sFeeSpanTimeStep(data1.getFeespantimestep()).sFeeSpanRateStep(data1.getFeespanratestep()).sFeeSpanRateStep_big(data1.getFeespanratestepBig()).build();
            List chargeDetails = data1.getChargeDetails();
            if (CollectionUtils.isNotEmpty((Collection)chargeDetails)) {
                List charge24RuleDetails = chargeDetails.stream().map(charge24chargeSet -> S24HoursRateCfgDTO.builder().sRecordStatus(Integer.valueOf(charge24chargeSet.getFeespantime() % data1.getDivisionTime() == 0 ? 1 : 0)).sFeeSpanTime(charge24chargeSet.getFeespantime()).sFeeSpanRate(charge24chargeSet.getFeespanrate()).sFeeSpanRate_big(charge24chargeSet.getFeespanrateBig()).build()).collect(Collectors.toList());
                s24HoursChargeCfgDTO.setSRateCfg(charge24RuleDetails);
            }
            chargeRuleCfg.setS24HoursCharge(s24HoursChargeCfgDTO);
        }
        return chargeRuleCfg;
    }

    public String getSChargeRule(ParkChargeconfig parkChargeconfig) {
        String sChargeRule = this.sChargeRuleMap.get(parkChargeconfig.getId());
        if (sChargeRule == null) {
            sChargeRule = JsonUtils.toString((Object)this.getSChargeRuleObj(parkChargeconfig));
            this.sChargeRuleMap.put(parkChargeconfig.getId(), sChargeRule);
        }
        return sChargeRule;
    }

    protected DyrationChargeCfgDTO buildDyrationChargeCfg(ChargeTypeDetail workdayDetail) {
        ChargeDuration duration = workdayDetail.getDuration();
        if (duration == null) {
            duration = new ChargeDuration();
        }
        DyrationChargeCfgDTO dyrationChargeCfgDTO = DyrationChargeCfgDTO.builder().sIsOverTimeSet(Integer.valueOf(NumberUtils.toPrimitive((Integer)duration.getIsOverTimeSet(), (int)2))).sOverTime(duration.getOverTime()).sFeeSpanTime(duration.getFeespantime()).sFeeSpanRate(duration.getFeespanrate()).sFeeSpanRate_big(duration.getFeespanrateBig()).build();
        List periodDurations = workdayDetail.getPeriodDurations();
        if (CollectionUtils.isNotEmpty((Collection)periodDurations)) {
            List stepChargeDetailList = periodDurations.stream().map(dura -> StepChargeCfgDTO.builder().sRecordStatus(Integer.valueOf(1)).sStartTimeModule(dura.getStartTimeModule()).sEndTimeModule(dura.getEndTimeModule()).sFeeSpanTime(dura.getFeespantime()).sFeeSpanRate(dura.getFeespanrate()).sFeeSpanRate_big(dura.getFeespanrateBig()).build()).collect(Collectors.toList());
            dyrationChargeCfgDTO.setSStepChargeCfg(stepChargeDetailList);
        }
        return dyrationChargeCfgDTO;
    }

    protected OnceChargeCfgDTO buildOnceChargeCfg(ChargeTypeDetail workdayDetail) {
        ChargeOnce once = workdayDetail.getOnce();
        if (once == null) {
            throw new ResponseBodyException("3001", "\u6309\u6b21\u8ba1\u8d39\u89c4\u5219\u4e0d\u5b8c\u6574");
        }
        return OnceChargeCfgDTO.builder().sIsopenoncecharge(Integer.valueOf(NumberUtils.toPrimitive((Integer)once.getIsopenoncecharge(), (int)1))).sOncechargefee(once.getOncechargefee()).sOncechargefee_big(once.getOncechargefeeBig()).sIsopenother2(Integer.valueOf(NumberUtils.toPrimitive((Integer)once.getIsopenother2(), (int)2))).sTimeFrame(once.getTimeFrame()).sTimeFrameOncefee(once.getTimeFrameOncefee()).sTimeFrameOncefee_big(once.getTimeFrameOncefeeBig()).sOtherTimeFrameOncefee(once.getOtherTimeframeOncefee()).sOtherTimeFrameOncefee_big(once.getOtherTimeframeOncefeeBig()).sIsattachoption(Integer.valueOf(NumberUtils.toPrimitive((Integer)once.getIsattachoption(), (int)2))).sOverTime(once.getOverTime()).sAddOvernightFee(once.getAddOvernightFee()).sAddOvernightFee_big(once.getAddOvernightFeeBig()).build();
    }

    public void addExtraFeePara(ExtraComputeFeePara extraComputeFeePara) {
        this.extraComputeFeeParaList.add(extraComputeFeePara);
    }

    public void addAllExtraFeePara(List<ExtraComputeFeePara> extraComputeFeeParas) {
        this.extraComputeFeeParaList.addAll(extraComputeFeeParas);
    }

    public void putParkChargeConfig(Integer billId, ParkChargeconfig parkChargeconfig) {
        this.parkChargeconfigMap.put(billId, parkChargeconfig);
    }

    public ParkChargeconfig getParkChargeConfig() {
        Map.Entry<Integer, ParkChargeconfig> firstEntry = this.parkChargeconfigMap.entrySet().iterator().next();
        if (firstEntry == null) {
            return null;
        }
        return firstEntry.getValue();
    }

    public ParkChargeconfig getParkChargeConfig(Integer billId) {
        ParkChargeconfig parkChargeConfig = this.parkChargeconfigMap.get(billId);
        if (parkChargeConfig == null) {
            parkChargeConfig = this.parkChargeconfigDao.selectByPrimaryKey(billId);
            this.parkChargeconfigMap.put(billId, parkChargeConfig);
        }
        return parkChargeConfig;
    }

    public boolean isBreak() {
        return this.isBreak;
    }

    public QueryOrderFeeRequest getQueryOrderFeeRequest() {
        return this.queryOrderFeeRequest;
    }

    public QueryOrderFeeResponse getQueryOrderFeeResponse() {
        return this.queryOrderFeeResponse;
    }

    public OrderInfo getOrderInfo() {
        return this.orderInfo;
    }

    public ParkConfig getParkConfig() {
        return this.parkConfig;
    }

    public Map<Integer, ParkChargeconfig> getParkChargeconfigMap() {
        return this.parkChargeconfigMap;
    }

    public Park getPark() {
        return this.park;
    }

    public ChargeService getChargeService() {
        return this.chargeService;
    }

    public ParkChargeconfigDao getParkChargeconfigDao() {
        return this.parkChargeconfigDao;
    }

    public VipType getVipType() {
        return this.vipType;
    }

    public OrderSumFeeDto getOrderSumFeeDto() {
        return this.orderSumFeeDto;
    }

    public OrderSonInfo getInnerOrderSonInfo() {
        return this.innerOrderSonInfo;
    }

    public Set<Integer> getBillIdList() {
        return this.billIdList;
    }

    public Set<Integer> getInnerBillIdList() {
        return this.innerBillIdList;
    }

    public String getSChargeConfigCfg() {
        return this.sChargeConfigCfg;
    }

    public Map<Integer, String> getSChargeRuleMap() {
        return this.sChargeRuleMap;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Long getQueryTime() {
        return this.queryTime;
    }

    public Long getParkTime() {
        return this.parkTime;
    }

    public BigDecimal getSurplusfee() {
        return this.surplusfee;
    }

    public boolean isMonthCarFee() {
        return this.isMonthCarFee;
    }

    public boolean isCsMonthCarFee() {
        return this.isCsMonthCarFee;
    }

    public int getCsFeeType() {
        return this.csFeeType;
    }

    public String getCsStartTime() {
        return this.csStartTime;
    }

    public String getCsEndTime() {
        return this.csEndTime;
    }

    public Long getCsSwitchTime() {
        return this.csSwitchTime;
    }

    public float getThisFee() {
        return this.thisFee;
    }

    public boolean isUseFreetime() {
        return this.isUseFreetime;
    }

    public List<ExtraComputeFeePara> getExtraComputeFeeParaList() {
        return this.extraComputeFeeParaList;
    }

    public void setBreak(boolean isBreak) {
        this.isBreak = isBreak;
    }

    public void setQueryOrderFeeRequest(QueryOrderFeeRequest queryOrderFeeRequest) {
        this.queryOrderFeeRequest = queryOrderFeeRequest;
    }

    public void setQueryOrderFeeResponse(QueryOrderFeeResponse queryOrderFeeResponse) {
        this.queryOrderFeeResponse = queryOrderFeeResponse;
    }

    public void setOrderInfo(OrderInfo orderInfo) {
        this.orderInfo = orderInfo;
    }

    public void setParkConfig(ParkConfig parkConfig) {
        this.parkConfig = parkConfig;
    }

    public void setParkChargeconfigMap(Map<Integer, ParkChargeconfig> parkChargeconfigMap) {
        this.parkChargeconfigMap = parkChargeconfigMap;
    }

    public void setPark(Park park) {
        this.park = park;
    }

    public void setChargeService(ChargeService chargeService) {
        this.chargeService = chargeService;
    }

    public void setParkChargeconfigDao(ParkChargeconfigDao parkChargeconfigDao) {
        this.parkChargeconfigDao = parkChargeconfigDao;
    }

    public void setVipType(VipType vipType) {
        this.vipType = vipType;
    }

    public void setOrderSumFeeDto(OrderSumFeeDto orderSumFeeDto) {
        this.orderSumFeeDto = orderSumFeeDto;
    }

    public void setInnerOrderSonInfo(OrderSonInfo innerOrderSonInfo) {
        this.innerOrderSonInfo = innerOrderSonInfo;
    }

    public void setBillIdList(Set<Integer> billIdList) {
        this.billIdList = billIdList;
    }

    public void setInnerBillIdList(Set<Integer> innerBillIdList) {
        this.innerBillIdList = innerBillIdList;
    }

    public void setSChargeConfigCfg(String sChargeConfigCfg) {
        this.sChargeConfigCfg = sChargeConfigCfg;
    }

    public void setSChargeRuleMap(Map<Integer, String> sChargeRuleMap) {
        this.sChargeRuleMap = sChargeRuleMap;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setQueryTime(Long queryTime) {
        this.queryTime = queryTime;
    }

    public void setParkTime(Long parkTime) {
        this.parkTime = parkTime;
    }

    public void setSurplusfee(BigDecimal surplusfee) {
        this.surplusfee = surplusfee;
    }

    public void setMonthCarFee(boolean isMonthCarFee) {
        this.isMonthCarFee = isMonthCarFee;
    }

    public void setCsMonthCarFee(boolean isCsMonthCarFee) {
        this.isCsMonthCarFee = isCsMonthCarFee;
    }

    public void setCsFeeType(int csFeeType) {
        this.csFeeType = csFeeType;
    }

    public void setCsStartTime(String csStartTime) {
        this.csStartTime = csStartTime;
    }

    public void setCsEndTime(String csEndTime) {
        this.csEndTime = csEndTime;
    }

    public void setCsSwitchTime(Long csSwitchTime) {
        this.csSwitchTime = csSwitchTime;
    }

    public void setThisFee(float thisFee) {
        this.thisFee = thisFee;
    }

    public void setUseFreetime(boolean isUseFreetime) {
        this.isUseFreetime = isUseFreetime;
    }

    public void setExtraComputeFeeParaList(List<ExtraComputeFeePara> extraComputeFeeParaList) {
        this.extraComputeFeeParaList = extraComputeFeeParaList;
    }

    public String toString() {
        return "BaseFeeParamHolder(isBreak=" + this.isBreak() + ", queryOrderFeeRequest=" + this.getQueryOrderFeeRequest() + ", queryOrderFeeResponse=" + this.getQueryOrderFeeResponse() + ", orderInfo=" + this.getOrderInfo() + ", parkConfig=" + this.getParkConfig() + ", parkChargeconfigMap=" + this.getParkChargeconfigMap() + ", park=" + this.getPark() + ", chargeService=" + this.getChargeService() + ", parkChargeconfigDao=" + this.getParkChargeconfigDao() + ", vipType=" + this.getVipType() + ", orderSumFeeDto=" + this.getOrderSumFeeDto() + ", innerOrderSonInfo=" + this.getInnerOrderSonInfo() + ", billIdList=" + this.getBillIdList() + ", innerBillIdList=" + this.getInnerBillIdList() + ", sChargeConfigCfg=" + this.getSChargeConfigCfg() + ", sChargeRuleMap=" + this.getSChargeRuleMap() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", queryTime=" + this.getQueryTime() + ", parkTime=" + this.getParkTime() + ", surplusfee=" + this.getSurplusfee() + ", isMonthCarFee=" + this.isMonthCarFee() + ", isCsMonthCarFee=" + this.isCsMonthCarFee() + ", csFeeType=" + this.getCsFeeType() + ", csStartTime=" + this.getCsStartTime() + ", csEndTime=" + this.getCsEndTime() + ", csSwitchTime=" + this.getCsSwitchTime() + ", thisFee=" + this.getThisFee() + ", isUseFreetime=" + this.isUseFreetime() + ", extraComputeFeeParaList=" + this.getExtraComputeFeeParaList() + ")";
    }

    public static class ExtraComputeFeePara {
        protected Long startTime;
        protected Long endTime;
        protected boolean isCsMonthCarFee;
        protected int csFeeType;
        protected String csStartTime;
        protected String csEndTime;
        protected Long csSwitchTime;
        protected Integer billId;

        public static ExtraComputeFeeParaBuilder builder() {
            return new ExtraComputeFeeParaBuilder();
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public boolean isCsMonthCarFee() {
            return this.isCsMonthCarFee;
        }

        public int getCsFeeType() {
            return this.csFeeType;
        }

        public String getCsStartTime() {
            return this.csStartTime;
        }

        public String getCsEndTime() {
            return this.csEndTime;
        }

        public Long getCsSwitchTime() {
            return this.csSwitchTime;
        }

        public Integer getBillId() {
            return this.billId;
        }

        public ExtraComputeFeePara setStartTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public ExtraComputeFeePara setEndTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public ExtraComputeFeePara setCsMonthCarFee(boolean isCsMonthCarFee) {
            this.isCsMonthCarFee = isCsMonthCarFee;
            return this;
        }

        public ExtraComputeFeePara setCsFeeType(int csFeeType) {
            this.csFeeType = csFeeType;
            return this;
        }

        public ExtraComputeFeePara setCsStartTime(String csStartTime) {
            this.csStartTime = csStartTime;
            return this;
        }

        public ExtraComputeFeePara setCsEndTime(String csEndTime) {
            this.csEndTime = csEndTime;
            return this;
        }

        public ExtraComputeFeePara setCsSwitchTime(Long csSwitchTime) {
            this.csSwitchTime = csSwitchTime;
            return this;
        }

        public ExtraComputeFeePara setBillId(Integer billId) {
            this.billId = billId;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtraComputeFeePara)) {
                return false;
            }
            ExtraComputeFeePara other = (ExtraComputeFeePara)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCsMonthCarFee() != other.isCsMonthCarFee()) {
                return false;
            }
            if (this.getCsFeeType() != other.getCsFeeType()) {
                return false;
            }
            Long this$startTime = this.getStartTime();
            Long other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            Long this$endTime = this.getEndTime();
            Long other$endTime = other.getEndTime();
            if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
                return false;
            }
            Long this$csSwitchTime = this.getCsSwitchTime();
            Long other$csSwitchTime = other.getCsSwitchTime();
            if (this$csSwitchTime == null ? other$csSwitchTime != null : !((Object)this$csSwitchTime).equals(other$csSwitchTime)) {
                return false;
            }
            Integer this$billId = this.getBillId();
            Integer other$billId = other.getBillId();
            if (this$billId == null ? other$billId != null : !((Object)this$billId).equals(other$billId)) {
                return false;
            }
            String this$csStartTime = this.getCsStartTime();
            String other$csStartTime = other.getCsStartTime();
            if (this$csStartTime == null ? other$csStartTime != null : !this$csStartTime.equals(other$csStartTime)) {
                return false;
            }
            String this$csEndTime = this.getCsEndTime();
            String other$csEndTime = other.getCsEndTime();
            return !(this$csEndTime == null ? other$csEndTime != null : !this$csEndTime.equals(other$csEndTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExtraComputeFeePara;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCsMonthCarFee() ? 79 : 97);
            result = result * 59 + this.getCsFeeType();
            Long $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            Long $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            Long $csSwitchTime = this.getCsSwitchTime();
            result = result * 59 + ($csSwitchTime == null ? 43 : ((Object)$csSwitchTime).hashCode());
            Integer $billId = this.getBillId();
            result = result * 59 + ($billId == null ? 43 : ((Object)$billId).hashCode());
            String $csStartTime = this.getCsStartTime();
            result = result * 59 + ($csStartTime == null ? 43 : $csStartTime.hashCode());
            String $csEndTime = this.getCsEndTime();
            result = result * 59 + ($csEndTime == null ? 43 : $csEndTime.hashCode());
            return result;
        }

        public String toString() {
            return "BaseFeeParamHolder.ExtraComputeFeePara(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", isCsMonthCarFee=" + this.isCsMonthCarFee() + ", csFeeType=" + this.getCsFeeType() + ", csStartTime=" + this.getCsStartTime() + ", csEndTime=" + this.getCsEndTime() + ", csSwitchTime=" + this.getCsSwitchTime() + ", billId=" + this.getBillId() + ")";
        }

        public ExtraComputeFeePara(Long startTime, Long endTime, boolean isCsMonthCarFee, int csFeeType, String csStartTime, String csEndTime, Long csSwitchTime, Integer billId) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.isCsMonthCarFee = isCsMonthCarFee;
            this.csFeeType = csFeeType;
            this.csStartTime = csStartTime;
            this.csEndTime = csEndTime;
            this.csSwitchTime = csSwitchTime;
            this.billId = billId;
        }

        public ExtraComputeFeePara() {
        }

        public static class ExtraComputeFeeParaBuilder {
            private Long startTime;
            private Long endTime;
            private boolean isCsMonthCarFee;
            private int csFeeType;
            private String csStartTime;
            private String csEndTime;
            private Long csSwitchTime;
            private Integer billId;

            ExtraComputeFeeParaBuilder() {
            }

            public ExtraComputeFeeParaBuilder startTime(Long startTime) {
                this.startTime = startTime;
                return this;
            }

            public ExtraComputeFeeParaBuilder endTime(Long endTime) {
                this.endTime = endTime;
                return this;
            }

            public ExtraComputeFeeParaBuilder isCsMonthCarFee(boolean isCsMonthCarFee) {
                this.isCsMonthCarFee = isCsMonthCarFee;
                return this;
            }

            public ExtraComputeFeeParaBuilder csFeeType(int csFeeType) {
                this.csFeeType = csFeeType;
                return this;
            }

            public ExtraComputeFeeParaBuilder csStartTime(String csStartTime) {
                this.csStartTime = csStartTime;
                return this;
            }

            public ExtraComputeFeeParaBuilder csEndTime(String csEndTime) {
                this.csEndTime = csEndTime;
                return this;
            }

            public ExtraComputeFeeParaBuilder csSwitchTime(Long csSwitchTime) {
                this.csSwitchTime = csSwitchTime;
                return this;
            }

            public ExtraComputeFeeParaBuilder billId(Integer billId) {
                this.billId = billId;
                return this;
            }

            public ExtraComputeFeePara build() {
                return new ExtraComputeFeePara(this.startTime, this.endTime, this.isCsMonthCarFee, this.csFeeType, this.csStartTime, this.csEndTime, this.csSwitchTime, this.billId);
            }

            public String toString() {
                return "BaseFeeParamHolder.ExtraComputeFeePara.ExtraComputeFeeParaBuilder(startTime=" + this.startTime + ", endTime=" + this.endTime + ", isCsMonthCarFee=" + this.isCsMonthCarFee + ", csFeeType=" + this.csFeeType + ", csStartTime=" + this.csStartTime + ", csEndTime=" + this.csEndTime + ", csSwitchTime=" + this.csSwitchTime + ", billId=" + this.billId + ")";
            }
        }
    }
}

