/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.basics.service.blacklist.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.dao.blacklist.BlacklistDao;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.request.BlacklistBatchDeleteParam;
import com.icetech.cloudcenter.api.IBatchDownSendService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.utils.RedisUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="blacklistService")
public class BlacklistServiceImpl
extends BaseServiceImpl<BlacklistDao, Blacklist>
implements BlacklistService {
    private static final Logger log = LoggerFactory.getLogger(BlacklistServiceImpl.class);
    @Autowired
    private BlacklistDao blacklistDao;
    @Autowired
    private SendInfoService sendInfoService;
    @Autowired
    private IBatchDownSendService batchDownSendService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;

    public ObjectResponse<Blacklist> getById(Long id) {
        Blacklist blacklist = this.blacklistDao.load(id);
        if (blacklist != null) {
            return ObjectResponse.success((Object)blacklist);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Blacklist> getValidByPlate(Long parkId, String plateNum) {
        Blacklist blacklist = this.blacklistDao.selectValidByPlate(parkId, plateNum);
        if (blacklist != null) {
            return ObjectResponse.success((Object)blacklist);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<Blacklist>> getValidByParkId(Long parkId) {
        List<Blacklist> blacklists = this.blacklistDao.selectValidByParkId(parkId);
        if (blacklists != null && blacklists.size() > 0) {
            return ObjectResponse.success(blacklists);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<Blacklist>> getValidByParkId(Long parkId, Date createTime) {
        List<Blacklist> blacklists = this.blacklistDao.selectValidByParkIdAndCreateTime(parkId, createTime);
        if (blacklists != null && blacklists.size() > 0) {
            return ObjectResponse.success(blacklists);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<Blacklist>> getValidByIds(List<String> idList) {
        List<Blacklist> blacklists = this.blacklistDao.selectValidByIds(idList);
        if (blacklists != null && blacklists.size() > 0) {
            return ObjectResponse.success(blacklists);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<Blacklist>> getByIds(List<Long> idList) {
        List<Blacklist> blacklists = this.blacklistDao.selectByIds(idList);
        if (blacklists != null && blacklists.size() > 0) {
            return ObjectResponse.success(blacklists);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Integer> addBlackList(Blacklist blacklist) {
        return ObjectResponse.success((Object)this.blacklistDao.insert(blacklist));
    }

    public ObjectResponse<Blacklist> selectByParkIdAndThirdId(Long parkId, Long thirdBlackId) {
        return ObjectResponse.returnNotFoundIfNull((Object)this.blacklistDao.selectByParkIdAndThirdId(parkId, thirdBlackId));
    }

    public ObjectResponse<Void> deleteBlackList(List<Long> parkIds, BlacklistBatchDeleteParam blacklistBatchDeleteParam) {
        String version;
        if (Objects.isNull(blacklistBatchDeleteParam) || CollectionUtils.isEmpty((Collection)blacklistBatchDeleteParam.getBlacklistIds())) {
            return ObjectResponse.failed((String)"404");
        }
        ObjectResponse parkConfigResp = this.parkService.getParkConfig(blacklistBatchDeleteParam.getParkCode());
        ParkConfig parkConfig = (ParkConfig)parkConfigResp.getData();
        if (parkConfig.getDataCollection() == 2 && (version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(parkConfig.getParkId()), String.class)) != null && PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c2540.getIndex()) {
            return ObjectResponse.failed((String)"500", (String)"\u8ba1\u8d39\u7cfb\u7edf\u7248\u672c\u4e0d\u652f\u6301");
        }
        ObjectResponse allOnline = this.parkDeviceService.isAllOnline(parkConfig.getParkId(), 1, parkConfig.getDataCollection().intValue());
        if (!ObjectResponse.isSuccess((Response)allOnline) || !((Boolean)allOnline.getData()).booleanValue()) {
            return ObjectResponse.failed((String)"500", (String)"\u76f8\u673a\u4e0d\u5728\u7ebf");
        }
        ObjectResponse<List<Blacklist>> blacklistResponse = this.getByIds(blacklistBatchDeleteParam.getBlacklistIds());
        if (!ObjectResponse.isSuccess(blacklistResponse)) {
            return ObjectResponse.failed((String)"404");
        }
        List blacklistIds = ((List)blacklistResponse.getData()).stream().filter(t -> t.getStatus() == 0).filter(t -> parkIds.contains(-1L) || parkIds.contains(t.getParkId())).map(t -> t.getId().longValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(blacklistIds)) {
            return ObjectResponse.failed((String)"404");
        }
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(Blacklist.class).eq(Blacklist::getStatus, (Object)0)).in(Blacklist::getId, blacklistIds);
        Blacklist update = new Blacklist();
        update.setStatus(Integer.valueOf(1));
        this.blacklistDao.update(update, (Wrapper)wrapper);
        List sendInfoList = ((List)blacklistResponse.getData()).stream().filter(t -> blacklistIds.contains(t.getId().longValue())).map(t -> new SendInfo(t.getParkId(), Long.valueOf(t.getId().longValue()), DownServiceEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getServiceType())).collect(Collectors.toList());
        this.sendInfoService.batchInsert(sendInfoList);
        List sendRequestList = sendInfoList.stream().map(t -> {
            SendRequest sendRequest = new SendRequest();
            sendRequest.setParkId(t.getParkId());
            sendRequest.setServiceId(t.getServiceId());
            sendRequest.setServiceType(t.getServiceType());
            sendRequest.setTaskId(t.getId());
            return sendRequest;
        }).collect(Collectors.toList());
        this.batchDownSendService.execute(sendRequestList);
        return ObjectResponse.success();
    }

    public ObjectResponse<Blacklist> addBlacklist(Blacklist blacklist) {
        this.save(blacklist);
        return ObjectResponse.success((Object)blacklist);
    }

    public ObjectResponse<Boolean> updateBlacklist(Blacklist blacklist) {
        boolean result = this.updateById(blacklist);
        return ObjectResponse.success((Object)result);
    }

    public ObjectResponse<Boolean> deleteBlacklistById(Long id) {
        boolean result = this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate((Class)this.getEntityClass()).set(Blacklist::getStatus, (Object)1)).eq(Blacklist::getId, (Object)id));
        return ObjectResponse.success((Object)result);
    }

    public ObjectResponse<List<Blacklist>> selectListByParkIdAndPlateNums(Long parkId, List<String> carNumberList) {
        List blacklists = this.blacklistDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(Blacklist.class).eq(Blacklist::getParkId, (Object)parkId)).eq(Blacklist::getStatus, (Object)0)).in(Blacklist::getPlate, carNumberList));
        if (CollectionUtils.isEmpty((Collection)blacklists)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)blacklists);
    }
}

