package com.icetech.park.service.freespace;

import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.park.dao.park.ParkFreespaceDao;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.Collections;

@Slf4j
@Service("updateParkFreeSpaceService")
public class UpdateParkFreeSpaceServiceImpl implements UpdateFreeSpaceService {

    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;

    @Override
    public int resetFreeSpace(Long parkId) {
        int i = parkFreespaceDao.syncFreeSpaceByPark(parkId);
        if (i > 0) {
            syncOutRegionFreeSpace(parkId);
        }
        return i;
    }

    @Override
    public int updateFreeSpace(Long parkId, Long regionId, int freeSpace) {
        int i = parkFreespaceDao.updateFreeSpaceByPark(parkId, freeSpace);
        if (i > 0) {
            syncOutRegionFreeSpace(parkId);
        }
        return i;
    }

    @Override
    public int addFreeSpace(Long parkId, Long regionId, int num) {
        int i = parkFreespaceDao.addFreeSpaceByPark(parkId, num);
        if (i > 0) {
            syncOutRegionFreeSpace(parkId);
        }
        return i;
    }

    @Override
    public int syncFreeSpace(Long parkId, Long regionId) {
        int i = parkFreespaceDao.syncFreeSpaceByPark(parkId);
        if (i > 0) {
            syncOutRegionFreeSpace(parkId);
        }
        return i;
    }

    @Override
    public int syncFreeSpaceByParks(Collection<Long> parkIds) {
        int i = parkFreespaceDao.syncFreeSpaceByParks(parkIds);
        if (i > 0) {
            syncOutRegionFreeSpace(parkIds);
        }
        return i;
    }
    private void syncOutRegionFreeSpace(Long parkId) {
        ParkRegion parkRegion = parkRegionDao.selectOutByParkid(parkId);
        if (parkRegion != null) {
            parkRegionDao.updateFreeSpaceByRegions(Collections.singleton(parkRegion.getId()));
        }
    }
    private void syncOutRegionFreeSpace(Collection<Long> parkIds) {
        for (Long parkId : parkIds) {
            ParkRegion parkRegion = parkRegionDao.selectOutByParkid(parkId);
            if (parkRegion != null) {
                parkRegionDao.updateFreeSpaceByRegions(Collections.singleton(parkRegion.getId()));
            }
        }
    }
}
