package com.icetech.park.service.freespace;

import java.util.Collection;

public interface UpdateFreeSpaceService {

    /**
     * 按照总车位减在场的方式重置空车位
     * @param parkId 车场ID
     * @return 影响行数
     */
    int resetFreeSpace(Long parkId);
    /**
     * 更新空车位到指定的数值
     * @param parkId 车场ID
     * @param regionId 区域ID
     * @param freeSpace 空车位
     * @return 影响行数
     */
    int updateFreeSpace(Long parkId, Long regionId, int freeSpace);
    /**
     * 累加空车位
     * @param parkId 车场ID
     * @param regionId 区域ID
     * @param num 计算数
     * @return 影响行数
     */
    int addFreeSpace(Long parkId, Long regionId, int num);
    /**
     * 总车位减在场
     * @param parkId 车场ID
     * @param regionId 区域ID
     * @return 影响行数
     */
    int syncFreeSpace(Long parkId, Long regionId);
    /**
     * 批量总车位减在场
     * @param parkIds 车场ID
     * @return 影响行数
     */
    default int syncFreeSpaceByParks(Collection<Long> parkIds) {
        return 0;
    }
    default int syncFreeSpaceByRegions(Collection<Long> parkIds, Collection<Long> regionIds) {
        return 0;
    }

}
