package com.icetech.park.service.factory;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.freespace.UpdateFreeSpaceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
/**
 * 获取更新空车位的实现类
 * @author fangct
 */
@Slf4j
@Component
public class UpdateFreeSpaceServiceFactory {

    @Resource
    private ParkService parkService;
    @Autowired
    private Map<String, UpdateFreeSpaceService> updateFreeSpaceServiceMap = new HashMap<>();

    /**
     * 获取更新空车位的实现类
     * @param parkId 车场ID
     * @return 具体实现类
     */
    public UpdateFreeSpaceService getUpdateFreeSpaceService(Long parkId) {
        if (isInteriorPark(parkId)) {
           return updateFreeSpaceServiceMap.get("updateRegionFreeSpaceService");
        } else {
           return updateFreeSpaceServiceMap.get("updateParkFreeSpaceService");
        }
    }

    private boolean isInteriorPark(Long parkId) {
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
        if (ObjectResponse.isSuccess(parkObjectResponse)) {
            Park park = parkObjectResponse.getData();
            return Integer.valueOf(1).equals(park.getIsInterior());
        }
        return false;
    }
}
