package com.icetech.park.dao.park;

import java.util.Collection;
import java.util.Map;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.common.utils.NumberUtils;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 空车位信息表 Mapper 接口
 * </p>
 *
 * @author wangzw
 * @since 2018-11-26
 */
public interface ParkFreespaceDao extends SuperMapper<ParkFreespace> {
    default int selectParkFree(Long parkId) {
        Integer freeSpace = selectOneColumn(ParkFreespace::getFreeSpace, Wrappers.lambdaQuery(ParkFreespace.class).eq(ParkFreespace::getParkId, parkId));
        return NumberUtils.toPrimitive(freeSpace);
    }

    int updateFreeSpaceByPark(@Param("parkId") long parkId, @Param("freeSpace") int freeSpace);

    int addFreeSpaceByPark(@Param("parkId") long parkId, @Param("num") int num);

    int addFreeSpaceByParks(@Param("parkIds") Collection<Long> parkIds, @Param("num") int num);

    @Deprecated
    int addFreeSpaceByParkMap(@Param("parkIdMap") Map<Long, Integer> parkIdMap);

    int syncFreeSpaceByPark(@Param("parkId") long parkId);

    int syncFreeSpaceByParks(@Param("parkIds") Collection<Long> parkIds);

    @Deprecated
    int updateFreeSpace(@Param("parkId") Long parkId);

    /**
     * 更新空车位：所有区域的空车位之和
     * @param parkIds 车场ID
     * @return 影响行数
     */
    int calculateFreeSpaceByParks(@Param("parkIds") Collection<Long> parkIds);
}
