package com.icetech.basics.service.park.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.icetech.basics.config.GrayProperties;
import com.icetech.basics.dao.area.AreaCityDao;
import com.icetech.basics.dao.area.AreaDistrictDao;
import com.icetech.basics.dao.charge.ChargeDyrationDao;
import com.icetech.basics.dao.charge.ChargeNaturaldayDao;
import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.dao.dictionary.DictionaryItemDao;
import com.icetech.basics.dao.park.OpeningDao;
import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.dao.park.RegionChargeconfigDao;
import com.icetech.basics.domain.dto.ChargeConfigDTO;
import com.icetech.basics.domain.dto.DictionaryItemDto;
import com.icetech.basics.domain.entity.AreaCity;
import com.icetech.basics.domain.entity.AreaDistrict;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.basics.domain.entity.charge.Charge24charge;
import com.icetech.basics.domain.entity.charge.ChargeDaynight;
import com.icetech.basics.domain.entity.charge.ChargeDuration;
import com.icetech.basics.domain.entity.charge.ChargeNaturalday;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.dictionary.DictionaryItem;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.domain.entity.park.Opening;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.park.IParkTrusteeshipService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.SaasUserParkService;
import com.icetech.cloudcenter.api.third.ThirdParkService;
import com.icetech.cloudcenter.domain.charge.detail.Charge24HourDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeDayNightDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeNaturalDayDetail;
import com.icetech.cloudcenter.domain.charge.dto.ChargeRuleCfgDTO;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.park.ChangPingParkUser;
import com.icetech.cloudcenter.domain.park.ParkAllInfo;
import com.icetech.cloudcenter.domain.park.ParkConfigInfo;
import com.icetech.cloudcenter.domain.park.ParkInfo;
import com.icetech.cloudcenter.domain.park.ParkList;
import com.icetech.cloudcenter.domain.park.ParkListGroup;
import com.icetech.cloudcenter.domain.park.query.ParkDistanceInfo;
import com.icetech.cloudcenter.domain.park.query.ParkDistanceParam;
import com.icetech.cloudcenter.domain.park.query.ParkQuery;
import com.icetech.cloudcenter.domain.park.ChangPingParkUser;
import com.icetech.cloudcenter.domain.park.ParkAllInfo;
import com.icetech.cloudcenter.domain.park.ParkConfigInfo;
import com.icetech.cloudcenter.domain.park.ParkInfo;
import com.icetech.cloudcenter.domain.park.ParkList;
import com.icetech.cloudcenter.domain.park.ParkListGroup;
import com.icetech.cloudcenter.domain.park.query.ParkSpaceInfo;
import com.icetech.cloudcenter.domain.park.query.ParkVisitInfo;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.response.AisleDto;
import com.icetech.cloudcenter.domain.response.MonthProductDto;
import com.icetech.cloudcenter.domain.response.OrganizationTreeDto;
import com.icetech.cloudcenter.domain.response.ParkAreaDetailDto;
import com.icetech.cloudcenter.domain.response.ParkDto;
import com.icetech.cloudcenter.domain.response.ParkPlotsDto;
import com.icetech.cloudcenter.domain.response.PassWayDto;
import com.icetech.cloudcenter.domain.vo.ParkChargeRuleVO;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.SpringUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.domain.entity.ParkTrusteeship;
import com.icetech.park.domain.entity.park.InitBstPark;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.domain.entity.park.ParkMessage;
import com.icetech.park.service.factory.UpdateFreeSpaceServiceFactory;
import com.icetech.park.service.freespace.UpdateFreeSpaceService;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.domain.entity.third.ThirdPark;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.service.third.SendInfoServiceImpl;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.user.dao.UserDefultAisleDao;
import com.icetech.user.domain.entity.user.SaasUser;
import com.icetech.user.domain.entity.user.SaasUserPark;
import com.icetech.user.domain.entity.user.UserDefultAisle;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service("parkService")
public class ParkServiceImpl extends BaseServiceImpl<ParkDao, BasePark> implements ParkService {
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private ParkConfigDao parkConfigDao;
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private SaasUserParkService saasUserParkService;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private ChargeDyrationDao chargeDyrationDao;
    @Autowired
    private ChargeNaturaldayDao chargeNaturaldayDao;
    @Autowired
    private RegionChargeconfigDao regionChargeconfigDao;
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private OpeningDao openingDao;
    @Autowired
    private DictionaryItemDao dictionaryItemDao;
    @Autowired
    private UserDefultAisleDao userDefultAisleDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private MqPushService mqPushService;
    @Resource
    private RedisHandle redisHandle;
    @Autowired
    private ThirdParkService thirdParkService;
    @Autowired
    private AreaCityDao areaCityDao;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private GrayProperties grayProperties;
    @Autowired
    private ParkFreeSpaceService parkFreeSpaceService;
    @Autowired
    private UpdateFreeSpaceServiceFactory updateFreeSpaceServiceFactory;
    @Autowired
    private ParkService parkService;
    @Value("${mor.videoUrl:default}")
    private String morVideoUrl;
    //最高级机构ID
    private static final Long HIGHEST_INST = 1L;

    @Autowired
    private AreaDistrictDao areaDistrictDao;


    @Override
    public ObjectResponse<List<ParkRegion>> selectRegionById(Long parkId) {
        List<ParkRegion> parkRegions = parkRegionDao.selectByParkid(parkId);
        return ObjectResponse.success(parkRegions);
    }

    @Override
    public ObjectResponse<ParkRegion> getParkRegionById(Long id) {
        ParkRegion parkRegion = parkRegionDao.selectById(id);
        if (parkRegion != null){
            return ObjectResponse.success(parkRegion);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public List<ParkMessage> findAllBy() {
        return parkDao.findAllBy();
    }

    @Override
    public List<Park> fidAll() {
        return parkDao.findAll();
    }


    @Override
    public ObjectResponse modifyUserDefultAisle(String aisleCode, Integer userId) {
        UserDefultAisle userDefultAisle = userDefultAisleDao.selectByUserId(userId);
        int update;
        if(Objects.isNull(userDefultAisle)){
            UserDefultAisle userDefultAisle1 = new UserDefultAisle();
            userDefultAisle1.setAisleCode(aisleCode);
            userDefultAisle1.setUserId(userId);
            userDefultAisle1.setCreateTime(new Date());
            update = userDefultAisleDao.insert(userDefultAisle1);
        }else{
            userDefultAisle.setAisleCode(aisleCode);
            userDefultAisle.setUpdateTime(new Date());
            update = userDefultAisleDao.update(userDefultAisle);
        }
        if(update > 0){
            return ObjectResponse.success();
        }
        return ObjectResponse.failed(CodeConstants.ERROR);
    }

    @Override
    public ObjectResponse<List<PassWayDto>> getUserDefultAisle(Integer userId) {
        UserDefultAisle userDefultAisle = userDefultAisleDao.selectByUserId(userId);
        List<ParkInoutdevice> parkInoutdevices = new ArrayList<>();
        if(!Objects.isNull(userDefultAisle)){
            String aisleCode = userDefultAisle.getAisleCode();
            if(StringUtil.isNotEmpty(aisleCode)){
                String[] split = aisleCode.split(",");
                for (String s : split) {
                    ParkInoutdevice parkInoutdevice = getInoutDeviceByCode(s).getData();
                    parkInoutdevices.add(parkInoutdevice);
                }
                if (!parkInoutdevices.isEmpty()){
                    return ObjectResponse.success(setResponse(parkInoutdevices));
                }
            }
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    public ObjectResponse<PassWayDto> findWayDetailByvid(String vid) {
        PassWayDto p = new PassWayDto();
        List<ParkDevice> parkDevices1 = parkDeviceDao.selectWayDetailByvid(vid);
        if(parkDevices1.size() > 0){
            ParkDevice parkDevice = parkDevices1.get(0);
            Park park = findByParkId(parkDevice.getParkId()).getData();
            ParkInoutdevice parkInoutdevice = getInoutDeviceById(Long.valueOf(parkDevice.getChannelId())).getData();
            p.setAisleCode(parkInoutdevice.getInandoutCode());
            p.setParkCode(park.getParkCode());
            p.setType(parkInoutdevice.getInandoutType());
            p.setAisleName(parkInoutdevice.getInandoutName());
            p.setParkName(park.getParkName());
            List<Integer> status = new ArrayList<>();
            status.add(1);
            List<Integer> deviceType = new ArrayList<>();
            deviceType.add(6);
            List<String> inandoutCode = new ArrayList<>();
            inandoutCode.add(parkInoutdevice.getInandoutCode());
            List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceList(parkInoutdevice.getParkId(), inandoutCode, status, deviceType);
            if(parkDevices.size() > 0){
                p.setVideoUrl(parkDevices.get(0).getVideoUrl());
            } else {
                ParkDevice morDevice = parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(), 9, null);
                if (morDevice != null) {
                    p.setIceMorSn(morDevice.getSerialNumber());
                    p.setIceMorVideoUrl(String.format(morVideoUrl, parkDevice.getSerialNumber()));
                }
            }
            // 托管数据查询
            setParkTrusteeshipStatus(p, parkInoutdevice);
        }

        return ObjectResponse.success(p);
    }

    private void setParkTrusteeshipStatus(PassWayDto p, ParkInoutdevice parkInoutdevice) {
        ParkTrusteeship parkTrusteeship = SpringUtils.getBean(IParkTrusteeshipService.class).getParkTrusteeshipByParkId(parkInoutdevice.getParkId()).getData();
        if (Objects.nonNull(parkTrusteeship)) {
            Date currentDate = new Date();
            p.setTrusteeshipStatus(DateUtil.compare(currentDate, parkTrusteeship.getStartTime()) < 0 ? 1 : (DateUtil.compare(currentDate,
                    parkTrusteeship.getStartTime()) > 0 && DateUtil.compare(currentDate, parkTrusteeship.getEndTime()) < 0 ? 2 : 3) );
            p.setTrusteeshipEndTime(parkTrusteeship.getEndTime());
        } else {
            p.setTrusteeshipStatus(0);
        }
    }

    @Override
    public ObjectResponse<List<ParkDto>> selectParkByname(String name) {
        List<ParkDto> rlist = new ArrayList<>();
        List<Park> parks = parkDao.selectByName(name);
        for (int i = 0; i < parks.size(); i++) {
            ParkDto p = new ParkDto();
            Park park = parks.get(i);
            p.setId(park.getId());
            p.setParkCode(park.getParkCode());
            p.setParkName(park.getParkName());
            rlist.add(p);
        }
        return ObjectResponse.success(rlist);
    }

    /**
     * 结果组装
     * @param parkInoutdevices
     * @return
     */
    private List<PassWayDto> setResponse(List<ParkInoutdevice> parkInoutdevices ){
        List<PassWayDto> rlist = new ArrayList<>();
        for (int i = 0; i < parkInoutdevices.size(); i++) {
            ParkInoutdevice parkInoutdevice = parkInoutdevices.get(i);
            PassWayDto p = new PassWayDto();
            if (parkInoutdevice == null){
                continue;
            }
            Park park = findByParkId(parkInoutdevice.getParkId()).getData();
            p.setId(parkInoutdevice.getId());
            p.setParkCode(park.getParkCode());
            p.setParkName(park.getParkName());
            p.setType(parkInoutdevice.getInandoutType());
            p.setAisleCode(parkInoutdevice.getInandoutCode());
            p.setAisleName(parkInoutdevice.getInandoutName());
            List<Integer> status = new ArrayList<>();
            status.add(1);
            status.add(2);
            List<Integer> deviceType = new ArrayList<>();
            deviceType.add(4);
            deviceType.add(6);
            deviceType.add(1);
            deviceType.add(9);
            List<String> inandoutCode = new ArrayList<>();
            inandoutCode.add(parkInoutdevice.getInandoutCode());
            List<Integer> deviceFail = new ArrayList<>();
            // 托管数据查询
            setParkTrusteeshipStatus(p, parkInoutdevice);
            List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceList(parkInoutdevice.getParkId(), inandoutCode, status, deviceType);
            for (int j = 0; j < parkDevices.size(); j++) {
                ParkDevice parkDevice = parkDevices.get(j);
                if (parkDevice.getType() == 1) {
                    p.setStatus(parkDevice.getStatus());
                    p.setIp(parkDevice.getIp());
                    p.setPort(parkDevice.getPort());
                }
                if (parkDevice.getType() == 4 && Objects.nonNull(parkDevice.getVoicevendorType()) && parkDevice.getVoicevendorType() == 2) {
                    p.setVoiceDeviceId(parkDevice.getSerialNumber());
                }
                if (parkDevice.getType() == 4 && Objects.nonNull(parkDevice.getVoicevendorType()) && parkDevice.getVoicevendorType() == 1) {
                    p.setYuneasyNumber(parkDevice.getSerialNumber());
                }
                if (parkDevice.getType() == 6) {
                    p.setVStatus(parkDevice.getStatus());
                    p.setVideoUrl(parkDevice.getVideoUrl());
                    String redisKey = RedisConstants.PREFIX_YSY_TOKEN + parkInoutdevice.getParkId() + ":" + parkDevice.getDeviceNo();
                    String accessToken = redisTemplate.opsForValue().get(redisKey);
                    log.info("setResponse  >  {}", accessToken);
                    if (TextUtils.isEmpty(accessToken)) {
                        //异步更新token,数据库里的url还能再顶两天，也许第一次显示token过期
                        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> parkDeviceService.updateConsoleTokenForRedis(parkDevice)));
                    }
                }
                if (parkDevice.getType() == 9) {
                    p.setIceMorSn(parkDevice.getSerialNumber());
                    p.setIceMorVideoUrl(String.format(morVideoUrl, parkDevice.getSerialNumber()));
                }
                if (ObjectUtils.isEmpty(parkDevice.getStatus())||parkDevice.getStatus() != 1  ){
                    deviceFail.add(parkDevice.getType());
                }
            }
            p.setStatusFail(deviceFail);
            rlist.add(p);
        }
        return rlist;
    }


    @Override
    public ObjectResponse<List<PassWayDto>> getPassageWayInfo(int id, int type,Integer userId) {
        List<ParkInoutdevice> parkInoutdevices = new ArrayList<>();
        String parkids = parkDao.selectParkOrgByUserId(userId, 2);//当前用户下的车场id
        if (StringUtils.isBlank(parkids)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "当前用户下无车场权限");
        }
        String[] userpark = parkids.split(",");
        //机构
        if (type == 1) {
            String integers = parkDao.selectInstitutionIdsByPid(id);
            String idStrs = integers.replace("$,", "");
            String[] split = idStrs.split(",");
            List list = Arrays.asList(split);
            List<Park> parkList = parkDao.selectByInstitutionIds(list);
            for (int i = 0; i < parkList.size(); i++) {
                Park park = parkList.get(i);
                for (int j = 0; j <userpark.length ; j++) {
                    if(userpark[j].equals(String.valueOf(park.getId()))){
                        parkInoutdevices.addAll(parkInoutdeviceDao.selectByParkId(park.getId()));
                    }
                }
            }
        } else if (type == 2) {//车场
            parkInoutdevices = parkInoutdeviceDao.selectByParkId((long) id);
        }
        return ObjectResponse.success(setResponse(parkInoutdevices));
    }

    @Override
    public ObjectResponse<List<OrganizationTreeDto>> selectOrganizationTree(Integer userId) {
        List<OrganizationTreeDto> olist = new ArrayList<>();
        List<Long> parkList = getParkListByUserId(userId);
        if (CollectionUtils.isEmpty(parkList)) {
            return ObjectResponse.success(olist);
        }
        List<OrganizationTreeDto> plist = parkDao.selectParksDetails(StrUtil.join(",", parkList));
        List<OrganizationTreeDto> orgList = parkDao.selectAllOrganiz();
        //判断车场是否有机构（某个机构只有一个车场情况下）---- 特殊情况
        for (OrganizationTreeDto treeDto : plist) {
            int pId = treeDto.getPId();
            Optional<OrganizationTreeDto> first = orgList.stream().filter(organizationTreeDto ->
                    Integer.parseInt(organizationTreeDto.getId()) == pId).findFirst();
            if (first.isPresent() && olist.contains(first.get())) {
                continue;
            }
            first.ifPresent(olist::add);
        }
        olist.addAll(plist);
        Collections.sort(olist);
        return ObjectResponse.success(olist);
    }

    @Override
    public ObjectResponse<List<OrganizationTreeDto>> selectAllOrganiz() {
        return ObjectResponse.success(parkDao.selectAllOrganiz());
    }

    @Override
    public ObjectResponse<Park> findByParkId(Long parkId) {
        String cacheKey = RedisKeyConstants.KEY_PREFIX_PARK_ID + parkId;
        Park park = redisHandle.cacheObject(cacheKey, Park.class, () -> parkDao.selectParkById(parkId), RedisKeyConstants.EXPIRE_PARK_INFO);
        if (park == null) {
            log.info("[车场信息查询]根据parkId未找到车场信息. parkId[{}]", parkId);
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(park);
    }

    @Override
    public ObjectResponse<Park> findByParkCode(String parkCode) {
        if (StringUtils.isBlank(parkCode)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        String cacheKey = RedisKeyConstants.KEY_PREFIX_PARK_CODE + parkCode;
        Park park = redisHandle.cacheObject(cacheKey, Park.class, () -> parkDao.selectByCode(parkCode), RedisKeyConstants.EXPIRE_PARK_INFO);
        if (park == null) {
            log.info("[车场信息查询]根据parkCode未找到车场信息. parkCode[{}]", parkCode);
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(park);
    }

    @Override
    public ObjectResponse<Long> getFreeByParkCode(String parkCode) {
        Long freeTime = parkConfigDao.selectFreeTimeByParkCode(parkCode);
        if (freeTime != null) {
            return ObjectResponse.success(freeTime);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<List<BasePark>> getBaseParkList(Collection<Long> parkIds) {
        List<BasePark> parks = list(getLambdaQueryWrapper().in(BasePark::getId, parkIds));
        if (CollectionUtils.isNotEmpty(parks)) {
            return ObjectResponse.success(parks);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<List<BasePark>> getBaseParkName(String name, Collection<Long> parkIds, Integer limit) {
        List<BasePark> parks = list(getLambdaQueryWrapper()
                .like(StringUtils.isNotEmpty(name), BasePark::getParkName, name)
                .in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L), BasePark::getId, parkIds)
                .last(limit > -1, " limit " + limit));
        return ObjectResponse.success(parks);
    }

    @Override
    public ObjectResponse<Boolean> reportParkInfo() {

        return null;
    }

    @Override
    public ObjectResponse<ParkPlotsDto> countParkPlots(String parkIdList) {
        ParkPlotsDto parkPlotsDto = parkDao.countParkPlots(parkIdList);
        if (parkPlotsDto != null) {
            return ObjectResponse.success(parkPlotsDto);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<List<ParkAreaDetailDto>> countParkPlotsByArea(String parkIdList) {
        List<ParkAreaDetailDto> parkAreaDetailDtos = parkDao.countParkPlotsByArea(parkIdList);
        if (parkAreaDetailDtos != null) {
            return ObjectResponse.success(parkAreaDetailDtos);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<List<ParkDto>> getParkList(Integer userId) {
        return getParkList(userId, null);
    }

    @Override
    public ObjectResponse<List<ParkDto>> getParkListLimit(Integer userId,String key) {
        if (userId == null) {
            return ObjectResponse.returnNotFoundIfNull(null);
        }
        List<Long> parkIds = getParkListByUserId(userId);
        if (CollectionUtils.isEmpty(parkIds)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        if (parkIds.get(0) == -1){
            List<Park> parks = parkDao.selectByParkIdsAndParkNameLimit(null, key);
            List<ParkDto> parkDtos = Lists.newArrayList();
            parks.forEach(park -> {
                ParkDto parkDto = new ParkDto();
                parkDto.setId(park.getId());
                parkDto.setParkCode(park.getParkCode());
                parkDto.setParkName(park.getParkName());
                parkDto.setDataCollection(getParkDataCollection(park.getId(), null));
                parkDtos.add(parkDto);
            });
            return ObjectResponse.success(setOtherFilds(parkDtos));
        }
        List<Park> parks = parkDao.selectByParkIdsAndParkNameLimit(parkIds, key);
        if (CollectionUtils.isEmpty(parks)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        List<ParkDto> parkDtos = Lists.newArrayList();
        parks.forEach(park -> {
            ParkDto parkDto = new ParkDto();
            parkDto.setId(park.getId());
            parkDto.setParkCode(park.getParkCode());
            parkDto.setParkName(park.getParkName());
            parkDtos.add(parkDto);
        });
        return ObjectResponse.success(setOtherFilds(parkDtos));
    }

    @Override
    public List<Long> getParkListByUserId(Integer userId) {
        String cacheKey = RedisKeyConstants.KEY_PREFIX_USER_PARKS + userId;
        return redisHandle.cacheList(cacheKey, Long.class, () -> selectUserParks(userId),
                RedisKeyConstants.EXPIRE_USER_PARKS);
    }

    @Override
    public List<Long> getParkListByUserId(Integer userId, String parkCode, String parkName) {
        List<Long> parkIds = getParkListByUserId(userId);
        if (CollectionUtils.isEmpty(parkIds)) {
            return parkIds;
        }
        if (StringUtils.isNotEmpty(parkCode)) {
            ObjectResponse<Park> parkObjectResponse = findByParkCode(parkCode);
            if (ObjectResponse.isSuccess(parkObjectResponse)) {
                Park park = parkObjectResponse.getData();
                if (parkIds.get(0) == -1) {
                    parkIds = Collections.singletonList(park.getId());
                } else {
                    if (parkIds.contains(park.getId())) {
                        parkIds = Collections.singletonList(park.getId());
                    } else {
                        parkIds = new ArrayList<>();
                    }
                }
            } else {
                parkIds = new ArrayList<>();
            }
        }
        if (StringUtils.isNotEmpty(parkName)) {
            BasePark park = selectLimitOne(Wrappers.lambdaQuery(BasePark.class).eq(BasePark::getParkName, parkName));
            if (park != null) {
                if (parkIds.get(0) == -1) {
                    parkIds = Collections.singletonList(park.getId());
                } else {
                    if (parkIds.contains(park.getId())) {
                        parkIds = Collections.singletonList(park.getId());
                    } else {
                        parkIds = new ArrayList<>();
                    }
                }
            } else {
                parkIds = new ArrayList<>();
            }
        }
        return parkIds;
    }

    private List<Long> selectUserParks(Integer userId) {
        //查询用户下的所有车场信息
        SaasUserPark saasUserPark = new SaasUserPark();
        saasUserPark.setUserId(userId);
        List<SaasUserPark> saasUserParks = saasUserParkService.list(saasUserPark);
        if (CollectionUtils.isEmpty(saasUserParks)){
            return new ArrayList<>();
        }
        List<Long> institutionIds = saasUserParks.stream()
                .filter(sp -> Integer.valueOf(1).equals(sp.getType()) && sp.getInstitutionId() != null)
                .map(SaasUserPark::getInstitutionId)
                .map(Integer::longValue)
                .collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(institutionIds) && institutionIds.contains(HIGHEST_INST)) {
            return Collections.singletonList(-1L);
        }
        List<Long> parkIds = saasUserParks.stream()
                .filter(sp -> Integer.valueOf(2).equals(sp.getType()) && sp.getParkId() != null)
                .map(SaasUserPark::getParkId)
                .map(Integer::longValue)
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(parkIds)) {
            parkIds = Lists.newArrayList();
        }
        if (CollectionUtils.isNotEmpty(institutionIds)) {
            //获取用户所有管辖的机构和子机构ID
            List<Long> allInstitutionIds = saasUserDao.selectAllInstitutionIdsByIds(institutionIds);
            if (CollectionUtils.isNotEmpty(allInstitutionIds)) {
                //获取机构下的所有车场信息
                List<Park> parks = parkDao.selectByInstitutionIds(allInstitutionIds);
                //查询当前用户下的车场
                if (CollectionUtils.isNotEmpty(parks)) {
                    List<Long> newParkIds = parks.stream().map(Park::getId).collect(Collectors.toList());
                    parkIds.addAll(newParkIds);
                }
                parkIds = parkIds.stream().distinct().collect(Collectors.toList());
            }
        }
        //没有车场权限，返回无内容的集合
        if (CollectionUtils.isEmpty(parkIds)){
            return new ArrayList<>();
        } else {
            return parkIds;
        }
    }


    private List<ParkDto> setOtherFilds(List<ParkDto> parkDtos){
        try {
            if (CollectionUtil.isEmpty(parkDtos)){
                return parkDtos;
            }
            List<Long> parkIds= parkDtos.stream().map(ParkDto::getId).collect(Collectors.toList());
            List<ParkConfig> parkConfigs = parkConfigDao.selectList(Wrappers.lambdaQuery(ParkConfig.class).in(ParkConfig::getParkId, parkIds));
            parkDtos.forEach(parkDto -> {
                parkConfigs.forEach(parkConfig -> {
                    if (parkDto.getId().equals(parkConfig.getParkId())){
                        parkDto.setDataCollection(parkConfig.getDataCollection());
                    }
                });
            });
        }catch (Exception e){
            log.error("[车场列表查询设置字段报错]",e);
        }
        return parkDtos;
    }
    @Override
    public ObjectResponse<List<ParkDto>> getParkList(Integer userId, List<Long> parkIds, String parkNameKey) {
        if (CollectionUtil.isEmpty(parkIds)){
            return getParkList(userId, parkNameKey);
        }else{
            List<Park> parks = parkDao.selectByParkIdsAndParkName(parkIds, parkNameKey);
            List<ParkDto> parkDtos = Lists.newArrayList();
            parks.forEach(park -> {
                ParkDto parkDto = new ParkDto();
                parkDto.setId(park.getId());
                parkDto.setParkCode(park.getParkCode());
                parkDto.setParkName(park.getParkName());
                parkDtos.add(parkDto);
            });
            return ObjectResponse.success(parkDtos);
        }
    }

    private ObjectResponse<List<ParkDto>> getParkList(Integer userId, String key) {
        if (userId == null) {
            return ObjectResponse.returnNotFoundIfNull(null);
        }
        List<Long> parkIds = getParkListByUserId(userId);
        if (CollectionUtils.isEmpty(parkIds)) {
            return ObjectResponse.returnNotFoundIfNull(null);
        }
        if (parkIds.get(0) == -1){
            List<Park> parks = parkDao.selectByParkIdsAndParkName(null, key);
            List<ParkDto> parkDtos = Lists.newArrayList();
            parks.forEach(park -> {
                ParkDto parkDto = new ParkDto();
                parkDto.setId(park.getId());
                parkDto.setParkCode(park.getParkCode());
                parkDto.setParkName(park.getParkName());
                parkDtos.add(parkDto);
            });
            return ObjectResponse.success(parkDtos);
        }
        List<Park> parks = parkDao.selectByParkIdsAndParkName(parkIds, key);
        if (CollectionUtils.isEmpty(parks)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        List<ParkDto> parkDtos = Lists.newArrayList();
        parks.forEach(park -> {
            ParkDto parkDto = new ParkDto();
            parkDto.setId(park.getId());
            parkDto.setParkCode(park.getParkCode());
            parkDto.setParkName(park.getParkName());
            parkDtos.add(parkDto);
        });
        return ObjectResponse.success(parkDtos);
    }

    @Override
    public ObjectResponse<List<AisleDto>> getAisleList(String parkCode, Integer type) {
        ObjectResponse<Park> parkResp = findByParkCode(parkCode);
        if (parkResp.getData() == null) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        List<ParkInoutdevice> parkInoutdevices = parkInoutdeviceDao.selectByParkIdAndType(parkResp.getData().getId(), type);
        if (CollectionUtils.isEmpty(parkInoutdevices)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        List<AisleDto> aisleDtos = Lists.newArrayList();
        parkInoutdevices.forEach(parkInoutdevice -> {
            AisleDto aisleDto = new AisleDto();
            aisleDto.setId(parkInoutdevice.getId());
            aisleDto.setParkId(parkInoutdevice.getParkId());
            aisleDto.setAisleCode(parkInoutdevice.getInandoutCode());
            aisleDto.setAisleName(parkInoutdevice.getInandoutName());
            aisleDto.setIsMaster(parkInoutdevice.getIsMaster());
            aisleDtos.add(aisleDto);
        });
        return ObjectResponse.success(aisleDtos);
    }

    @Override
    public ObjectResponse<List<ParkInoutdevice>> getChannelByType(Long parkId, Integer type) {
        List<ParkInoutdevice> parkInoutdevices = parkInoutdeviceDao.selectByParkIdAndType(parkId, type);
        if (CollectionUtils.isEmpty(parkInoutdevices)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        } else {
            return ObjectResponse.success(parkInoutdevices);
        }
    }

    @Override
    public ObjectResponse<List<ParkInoutdevice>> getAllChannel(Long parkId) {
        List<ParkInoutdevice> parkInoutdevices = parkInoutdeviceDao.selectByParkId(parkId);
        if (CollectionUtils.isEmpty(parkInoutdevices)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        } else {
            return ObjectResponse.success(parkInoutdevices);
        }
    }

    @Override
    public ObjectResponse<ParkInoutdevice> getChannelInfo(Long parkId, String serialNumber) {
        ObjectResponse<ParkDevice> deviceResp = parkDeviceService.getDeviceBySerialNumber(serialNumber);
        if (deviceResp == null || deviceResp.getData() == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }

        return getInoutDeviceById(deviceResp.getData().getChannelId().longValue());
    }

    @Override
    public ObjectResponse<ParkConfig> getParkConfig(Long parkId) {
        String cacheKey = RedisKeyConstants.KEY_PREFIX_PARK_CONFIG_PARK + parkId;
        ParkConfig parkConfig = redisHandle.cacheObject(cacheKey, ParkConfig.class, () -> parkConfigDao.selectByParkId(parkId), RedisKeyConstants.EXPIRE_PARK_CONFIG);
        if (parkConfig == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(parkConfig);
    }

    @Override
    public ObjectResponse<ParkConfig> getParkConfig(String parkCode) {
        String cacheKey = RedisKeyConstants.KEY_PREFIX_PARK_CONFIG_PARK_CODE + parkCode;
        ParkConfig parkConfig = redisHandle.cacheObject(cacheKey, ParkConfig.class, () -> {
            ObjectResponse<Park> parkResp = findByParkCode(parkCode);
            if (!ObjectResponse.isSuccess(parkResp)) return null;
            ParkConfig data = parkConfigDao.selectByParkId(parkResp.getData().getId());
            return data;
        }, RedisKeyConstants.EXPIRE_PARK_CONFIG);
        if (parkConfig == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(parkConfig);
    }

    @Override
    public ObjectResponse<Map<Long, ParkConfig>> getParkConfigs(Collection<Long> parkIds) {
        List<ParkConfig> configs = new ArrayList<>(parkIds.size());
        for (Long parkId : parkIds) {
            ObjectResponse<ParkConfig> configResp = getParkConfig(parkId);
            if (ObjectResponse.isSuccess(configResp)) {
                configs.add(configResp.getData());
            }
        }
        if (CollectionUtils.isEmpty(configs)) return ObjectResponse.failed(CodeConstants.ERROR_404);
        return ObjectResponse.success(configs.stream().collect(Collectors.toMap(ParkConfig::getParkId, Function.identity(), (older, newer) -> newer)));
    }

    @Override
    public ObjectResponse<ParkInoutdevice> getInoutDeviceById(Long id) {
        String cacheKey = RedisKeyConstants.KEY_PREFIX_PARK_CHANNEL + id;
        if (grayProperties.isCacheEnable()) cacheKey = RedisKeyConstants.KEY_PREFIX_GRAY + cacheKey;
        ParkInoutdevice parkInoutdevice = redisHandle.cacheObject(cacheKey, ParkInoutdevice.class, () -> parkInoutdeviceDao.selectById(id),
                RedisKeyConstants.EXPIRE_PARK_CHANNEL);
        return ObjectResponse.returnNotFoundIfNull(parkInoutdevice);
    }

    @Override
    public List<ParkInoutdevice> getInoutDeviceByIds(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) return Collections.emptyList();
        return parkInoutdeviceDao.selectByIds(idList);
    }

    @Override
    public ObjectResponse<ParkInoutdevice> getInoutDeviceByCode(String channelCode) {
        if (StringUtils.isBlank(channelCode)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        String cacheKey = RedisKeyConstants.KEY_PREFIX_PARK_CHANNEL_CODE + channelCode;
        if (grayProperties.isCacheEnable()) cacheKey = RedisKeyConstants.KEY_PREFIX_GRAY + cacheKey;
        ParkInoutdevice channel = redisHandle.cacheObject(cacheKey, ParkInoutdevice.class, () -> parkInoutdeviceDao.selectByCode(null, channelCode),
                RedisKeyConstants.EXPIRE_PARK_CHANNEL);
        return ObjectResponse.returnNotFoundIfNull(channel);
    }

    @Override
    public ObjectResponse<ParkChargeRuleVO> getParkChargeRule(Long parkId, Long regionId) {
        ParkChargeRuleVO parkChargeRuleVO = getFreeTimeLocal(parkId, regionId);
        if (parkChargeRuleVO == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(parkChargeRuleVO);
    }

    @Override
    public ObjectResponse<Integer> getFreeTime(Long parkId) {
        ParkChargeRuleVO vo = getFreeTimeLocal(parkId, null);
        return ObjectResponse.success(vo == null || vo.getFreeTime() == null ? 0 : vo.getFreeTime());
    }

    @Override
    public ObjectResponse<ParkChargeRuleVO> getMinFreeTime(Long parkId) {
        ObjectResponse<List<ParkChargeconfig>> chargeConfigResp = chargeService.getConfigs(parkId);
        ParkChargeRuleVO vo = new ParkChargeRuleVO();
        vo.setFreeTime(0);
        vo.setIsFreetimeOnce(0);
        if (!ObjectResponse.isSuccess(chargeConfigResp)) {
            log.info("未找到车场配置的计费规则. parkId[{}]", parkId);
            return ObjectResponse.success(vo);
        }
        List<ParkChargeconfig> chargeConfigs = chargeConfigResp.getData();
        int minFreeTime = 0;
        if (CollectionUtils.isNotEmpty(chargeConfigs)) {
            for (int i = 0; i < chargeConfigs.size(); i++) {
                ParkChargeconfig chargeConfig = chargeConfigs.get(i);
                Integer billType = chargeConfig.getBilltype();
                ParkChargeRuleVO freeTimeLocal = getFreeTimeLocal(billType, chargeConfig.getBilltypecode());
                if (i == 0 || minFreeTime > NumberUtils.toPrimitive(freeTimeLocal.getFreeTime())) {
                    minFreeTime = freeTimeLocal.getFreeTime();
                    vo = freeTimeLocal;
                }
            }
        }
        log.info("找到车场[{}]免费时长最小的计费规则, vo[{}]", parkId, vo);
        return ObjectResponse.success(vo);
    }

    @Override
    public ObjectResponse<ParkInoutdevice> getInOutDeviceByCode(Long parkId, String channelCode) {
        ObjectResponse<ParkInoutdevice> channelResp = getInoutDeviceByCode(channelCode);
        if (ObjectResponse.isSuccess(channelResp)
                && (parkId == null || channelResp.getData().getParkId().equals(parkId))) {
            return channelResp;
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    public ObjectResponse<Integer> saveOpeningRecord(OpeningDtoRequest request) {
        try {
            Long parkId = request.getParkId();
            if (parkId == null) {
                //获取车场
                ObjectResponse<Park> parkResp = findByParkCode(request.getParkCode());
                if (parkResp.getData() == null) {
                    return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
                }
                parkId = parkResp.getData().getId();
            }
            //获取通道
            ParkInoutdevice parkInoutdevice = getChannelByCodeAndParkId(parkId, request.getAisleCode());
            if (parkInoutdevice == null) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            Opening opening = new Opening();
            opening.setSwitchType(Integer.valueOf(4).equals(request.getSourcegate()) ? 2 : 1);
            opening.setParkId(parkId.intValue());
            opening.setChannelId(parkInoutdevice.getId().toString());
            opening.setGatepos(parkInoutdevice.getInandoutName());
            long executeTime = String.valueOf(request.getExecuteTime()).length() >= 13
                    ? request.getExecuteTime() : request.getExecuteTime() * 1000;
            opening.setIssuedTm(new Date(executeTime));
            opening.setCreateTime(new Date());
            opening.setSourcegate(request.getSourcegate() == null ? 2 : request.getSourcegate());
            opening.setPlateNum(request.getPlateNum());
            opening.setOrderNum(request.getOrderNum());
            opening.setGateType(request.getRecordType());
            opening.setGatephoto(request.getImgUrl());
            opening.setOperAccount(request.getOperAccount());
            //入场默认为非机动车辆放行
            if (request.getReasonType() != null) {
                opening.setReason(request.getReasonType());
            } else {
                if (!Integer.valueOf(4).equals(request.getSourcegate())) {
                    opening.setReason(3);
                }
            }
            opening.setRemark(request.getRemark());
            openingDao.insert(opening);
            mqPushService.pushErrorOpen(opening);
            return ObjectResponse.success(opening.getId());
        } catch (Exception e) {
            log.error("处理失败: {}. request[{}]", e.getMessage(), request, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<String> selectGroupPayType(String parkCode) {
        ObjectResponse<Park> parkResp = findByParkCode(parkCode);
        if (parkResp.getData() == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "车场不存在");
        }
        ObjectResponse<ParkConfig> parkConfigResp = getParkConfig(parkResp.getData().getId());
        if (ObjectResponse.isSuccess(parkConfigResp) && parkConfigResp.getData().getIsEpayment() == 1) {
            return ObjectResponse.success(parkConfigResp.getData().getEPayment());
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR_2006);
    }

    @Override
    public ObjectResponse<List<Park>> parkListByType(int type) {
        List<Park> parks = parkDao.selectListByType(type);
        if (parks != null) {
            return ObjectResponse.success(parks);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<Boolean> isFullNoPass(Long parkId, String channelCode) {
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
        ObjectResponse.notError(parkObjectResponse, "车场id不存在");
        Park park = parkObjectResponse.getData();
        ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInoutDeviceByCode(channelCode);
        ObjectResponse.notError(objectResponse, "通道编号不存在");
        ParkInoutdevice parkInoutdevice = objectResponse.getData();
        ParkRegion parkRegion = parkRegionDao.selectById(parkInoutdevice.getRegionId());
        AssertTools.notNull(parkRegion, CodeConstants.ERROR_404, "车场区域不存在");
        int freeSpace;
        if (park.getIsInterior() == null || Integer.valueOf(0).equals(park.getIsInterior())) {
            ObjectResponse<ParkFreespace> spaceResp = parkFreeSpaceService.getSpaceByPark(parkId);
            if (!ObjectResponse.isSuccess(spaceResp)) {
                return ObjectResponse.success(Boolean.FALSE);
            }
            freeSpace = spaceResp.getData().getFreeSpace();
        } else {
            freeSpace = NumberUtils.toPrimitive(parkRegion.getFreePark());
        }
        boolean isFull = false;
        if (parkRegion.getIsFullForbidenter() != null && parkRegion.getIsFullForbidenter() == 1) {
            Integer fullEmptynum = parkRegion.getFullEmptynum();
            if (fullEmptynum >= freeSpace) {
                /*
                 * 禁止临时车入场
                 */
                isFull = true;
            }
        }
        return ObjectResponse.success(isFull);
    }

    @Override
    public ObjectResponse<ParkFreespace> getParkSpace(Long parkId) {
        return parkFreeSpaceService.getSpaceByPark(parkId);
    }

    @Override
    public ObjectResponse<List<DictionaryItemDto>> getDicItemList(Integer type) {
        try {
            List<DictionaryItem> dictionaryItems = dictionaryItemDao.selectByDictionaryType(type);
            if (CollectionUtils.isEmpty(dictionaryItems)){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }

            List<DictionaryItemDto> reasons = Lists.newArrayList();
            dictionaryItems.forEach(dictionaryItem -> {
                DictionaryItemDto dictionaryItemDto = new DictionaryItemDto();
                dictionaryItemDto.setValue(dictionaryItem.getValue());
                dictionaryItemDto.setText(dictionaryItem.getText());
                reasons.add(dictionaryItemDto);
            });

            return ObjectResponse.success(reasons);
        } catch (Exception e){
            log.error("[字典类型获取]处理失败: {}. type[{}]", e.getMessage(), type, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<List<ParkInoutdevice>> getInoutByParkId(Long parkId) {
        List<ParkInoutdevice> parkInoutdevices = parkInoutdeviceDao.selectByParkId(parkId);
        if (CollectionUtils.isEmpty(parkInoutdevices)) {
            return  ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkInoutdevices);
    }

    @Override
    public ObjectResponse<List<ParkInoutdevice>> getChannelsByIds(Long[] channelIds) {
        List<ParkInoutdevice> parkInoutdevices = new ArrayList<>(channelIds.length);
        for (int i = 0; i < channelIds.length; i++) {
            ObjectResponse<ParkInoutdevice> channelResp = getInoutDeviceById(channelIds[i]);
            if (ObjectResponse.isSuccess(channelResp)) {
                parkInoutdevices.add(channelResp.getData());
            }
        }
        if (CollectionUtils.isEmpty(parkInoutdevices)){
            return  ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkInoutdevices);
    }

    /**
     * 通过pid获取车场列表
     *
     * @param pid
     * @param pageIndex
     * @param pageSize
     * @return
     */
    @Override
    public ObjectResponse<ParkListGroup> selectByParkInfoThirdPID(String pid, Integer pageIndex, Integer pageSize) {
        Page<List<ParkList>> parkListPage = PageHelper.startPage(pageIndex, pageSize);
        List<ParkList> parkLists = parkDao.selectByParkInfoThirdPID(pid);
        return ObjectResponse.success(new ParkListGroup(parkListPage.getTotal(),String.valueOf(parkListPage.getPages()),parkLists));
    }

    @Override
    @Transactional
    public ObjectResponse<Long> insertParkInfo(ParkInfo parkInfo) {
        Integer parkSize = parkDao.selectParkCountByParkCodeAndName(parkInfo.getParkCode(), parkInfo.getParkName());
        if (parkSize <= 0) {
            parkInfo.setUpdateTime(new Date());
            parkInfo.setUpdateUser("third");
            parkInfo.setKey(UUID.randomUUID().toString().replaceAll("-", ""));
            parkDao.saveParkInfo(parkInfo);
            ParkConfigInfo configInfo = new ParkConfigInfo(parkInfo.getParkCode(), parkInfo.getId().intValue(), parkInfo.getDataCollection());
            parkConfigDao.saveParkConfigInfo(configInfo);

            ParkFreespace parkFreespace = new ParkFreespace();
            parkFreespace.setParkId(parkInfo.getId());
            parkFreespace.setTotalNum(parkInfo.getTotalNum());
            parkFreespace.setFreeSpace(Objects.isNull(parkInfo.getFreeSpace()) ? parkInfo.getTotalNum() : parkInfo.getFreeSpace());
            parkFreespace.setRealFreeSpace(Objects.isNull(parkInfo.getFreeSpace()) ? parkInfo.getTotalNum() : parkInfo.getFreeSpace());
            parkFreeSpaceService.insertFreeSpace(parkFreespace);

            ParkRegion parkRegion = createRegion(parkInfo);
            removeParkParamFromRedis(parkInfo.getParkCode(), parkInfo.getId());
            sendInfoService.saveBatch(Arrays.asList(
                    new SendInfo(parkInfo.getId(), configInfo.getId(), DownServiceEnum.车场配置.getServiceType()),
                    new SendInfo(parkInfo.getId(), parkRegion.getId(), DownServiceEnum.区域信息和计费规则关联关系.getServiceType())
            ));
            return ObjectResponse.success(parkInfo.getId());
        }
        return ObjectResponse.failed(CodeConstants.ERROR_400, "车场已存在");
    }

    /**
     * add a default region
     * @param parkInfo
     */
    private ParkRegion createRegion(ParkInfo parkInfo){
        ParkRegion parkRegion = new ParkRegion();
        parkRegion.setParkId(parkInfo.getId());
        parkRegion.setRegionCode(String.valueOf(new Random().nextInt(999999)));
        parkRegion.setRegionName(parkInfo.getParkName()+"_外区域");
        parkRegion.setFatherRelationId(0L);
        parkRegion.setRegionPark(parkInfo.getTotalNum());
        parkRegion.setFreePark(Objects.isNull(parkInfo.getFreeSpace())?parkInfo.getTotalNum():parkInfo.getFreeSpace());
        parkRegion.setRealFreePark(Objects.isNull(parkInfo.getFreeSpace())?parkInfo.getTotalNum():parkInfo.getFreeSpace());
        parkRegion.setRegionType(2);
        parkRegion.setStatus(0);
        parkRegion.setPositionType(0);
        parkRegion.setDefaultName(new Integer(1).equals(parkInfo.getDataCollection())?0:1);
        parkRegion.setAdder(Objects.isNull(parkInfo.getAdder())?"third":parkInfo.getAdder());
        parkRegion.setCreateTime(new Date());
        parkRegion.setUpdateUser(Objects.isNull(parkInfo.getAdder())?"third":parkInfo.getAdder());
        parkRegion.setUpdateTime(new Date());
        parkRegionDao.insert(parkRegion);
        return parkRegion;
    }

    @Override
    @Transactional
    public ObjectResponse<String> updateParkInfo(ParkInfo parkInfo) {
        Integer parkSize = parkDao.selectParkCountByParkCodeAndName(parkInfo.getParkCode(), parkInfo.getParkName());
        if (parkSize > 0) {
            parkDao.updateParkInfo(parkInfo);
            Park park = findByParkCode(parkInfo.getParkCode()).getData();
            parkInfo.setId(park.getId());
            log.info("updateParkInfo [{}]", parkInfo);
            ObjectResponse<ParkConfig> parkConfigResp = getParkConfig(park.getId());
            ObjectResponse.notError(parkConfigResp);
            ParkConfigInfo configInfo = new ParkConfigInfo(parkInfo.getParkCode(), parkInfo.getId().intValue(), parkInfo.getDataCollection());
            parkConfigDao.updateParkConfigInfo(configInfo);

            UpdateFreeSpaceService updateFreeSpaceService = updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(park.getId());
            updateFreeSpaceService.updateFreeSpace(parkInfo.getId(), null, NumberUtils.toPrimitive(parkInfo.getFreeSpace()));

            sendInfoService.save(new SendInfo(parkInfo.getId(), parkConfigResp.getData().getId(), DownServiceEnum.车场配置.getServiceType()));
            removeParkParamFromRedis(park.getParkCode(), park.getId());
            return ObjectResponse.success(parkInfo.getParkCode());
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    /**
     * 移除redis相关车场信息
     * @param parkCode
     * @param parkId
     */
    public void removeParkParamFromRedis(String parkCode, Long parkId) {
        redisTemplate.delete(Arrays.asList(RedisKeyConstants.KEY_PREFIX_PARK_ID + parkId,
                RedisKeyConstants.KEY_PREFIX_PARK_CODE + parkCode,
                RedisKeyConstants.KEY_PREFIX_PARK_CONFIG_PARK + parkId,
                RedisKeyConstants.KEY_PREFIX_PARK_CONFIG_PARK_CODE + parkCode));
    }

    public void removeParkInfoFromRedis(String parkCode,Long parkId) {
        redisTemplate.delete(Arrays.asList(RedisKeyConstants.KEY_PREFIX_PARK_ID + parkId,
                RedisKeyConstants.KEY_PREFIX_PARK_CODE + parkCode));
    }

    public void removeParkConfigFromRedis(Long parkId, String parkCode) {
        redisTemplate.delete(Arrays.asList(RedisKeyConstants.KEY_PREFIX_PARK_CONFIG_PARK + parkId,
                RedisKeyConstants.KEY_PREFIX_PARK_CONFIG_PARK_CODE + parkCode));
    }

    @Override
    public ObjectResponse<String> selectParkInfoByParkCode(String parkCode) {
        ParkInfo parkInfo = parkDao.selectParkInfoByParkCode(parkCode);

        log.info(("selectParkInfoByParkCode parkInfo [{}]"),parkInfo);
        return ObjectResponse.success(JsonUtils.toString(parkInfo));
    }

    @Override
    public ObjectResponse<Integer> insert(ParkChargeconfig record) {
        return ObjectResponse.success(parkChargeconfigDao.insert(record));
    }

    @Override
    public ObjectResponse<Integer> updateByPrimaryKeySelective(ParkChargeconfig record) {
        return ObjectResponse.success(parkChargeconfigDao.updateById(record));
    }

    @Override
    public ObjectResponse<Integer> deleteByPrimaryKey(Integer id) {
        return ObjectResponse.success(parkChargeconfigDao.deleteById(id));
    }

    /**
     * @param parkId
     * @param billtypecode
     * @return
     */
    @Override
    public ObjectResponse<ParkChargeconfig>  selectByParkIdAndBillCode(Long parkId, String billtypecode) {
        return ObjectResponse.success(parkChargeconfigDao.selectByParkIdAndBillCode(parkId,billtypecode));
    }

    @Override
    public ObjectResponse<Integer> insert(ParkInoutdevice parkInoutdevice) {
        return ObjectResponse.success(parkInoutdeviceDao.insert(parkInoutdevice));
    }

    @Override
    public ObjectResponse<Integer> updateAllParameter(ParkInoutdevice parkInoutdevice) {
        int result = parkInoutdeviceDao.updateById(parkInoutdevice);
        sendInfoService.save(new SendInfo(parkInoutdevice.getParkId(), parkInoutdevice.getId(), DownServiceEnum.区域信息和计费规则关联关系.getServiceType()));
        return ObjectResponse.success(result);
    }

    /**
     * 删除通道权限规则
     *
     * @param parkInoutdevice
     * @return
     */
    @Override
    public ObjectResponse<Integer> delInoutDeviceConfig(ParkInoutdevice parkInoutdevice) {
        return ObjectResponse.success(parkInoutdeviceDao.delInoutDeviceConfig(parkInoutdevice));
    }

    @Override
    public ObjectResponse<Integer> insertChargeDyration(ChargeDuration chargeDuration) {
        return ObjectResponse.success(chargeDyrationDao.insert(chargeDuration));
    }

    @Override
    public ObjectResponse<Integer> delChargeDyrationRule(String billCode) {
        return ObjectResponse.success(chargeDyrationDao.delChargeDyrationRule(billCode));
    }

    @Override
    public ObjectResponse<Integer> insertChargeNaturalday(ChargeNaturalday chargeNaturalday) {
        return ObjectResponse.success(chargeNaturaldayDao.insert(chargeNaturalday));
    }

    @Override
    public ObjectResponse<Integer> editChargeNaturalDayRule(ChargeNaturalday chargeNaturalday) {
        return ObjectResponse.success(chargeNaturaldayDao.updateById(chargeNaturalday));
    }

    @Override
    public ObjectResponse<Integer> modifyChargeNaturalDayRuleState(ChargeNaturalday chargeNaturalday) {
        return ObjectResponse.success(chargeNaturaldayDao.modifyChargeNaturalDayRuleState(chargeNaturalday));
    }

    /**
     * 插入新的区域计费规则
     *
     * @param regionChargeconfig
     * @return
     */
    @Override
    public ObjectResponse<Integer> insertRegionChargeconfigSelective(RegionChargeconfig regionChargeconfig) {
        return ObjectResponse.success(regionChargeconfigDao.insert(regionChargeconfig));
    }

    /**
     * 根据计费规则编码
     * 修改区域计费规则状态
     *
     * @param regionChargeconfig
     * @return
     */
    @Override
    public ObjectResponse<Integer> modifyRegionChargeConfigStatus(RegionChargeconfig regionChargeconfig) {
        return ObjectResponse.success(regionChargeconfigDao.modifyRegionChargeConfigStatus(regionChargeconfig));
    }

    /**
     * 删除区域计费规则
     *
     * @param billtypecode
     * @return
     */
    @Override
    public ObjectResponse<Integer> delRegionChargeConfig(String billtypecode) {
        return ObjectResponse.success(regionChargeconfigDao.delRegionChargeConfig(billtypecode));
    }

    /**
     * 根据区域id 查询区域计费
     *
     * @param parkId
     * @return
     */
    @Override
    public ObjectResponse<List<RegionChargeconfig>> selectRegionChargeconfigByParkId(Long parkId) {
        return ObjectResponse.success(regionChargeconfigDao.selectByParkId(parkId));
    }

    @Resource
    private ChargeService chargeService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;

    @Override
    public ParkChargeRuleVO getFreeTimeLocal(Long parkId, Long regionId) {
        if (regionId != null) {
            //获取区域的默认规则
            RegionChargeconfig regionChargeconfig = regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, 0);
            if (regionChargeconfig != null){
                ParkChargeconfig parkChargeConfig = parkChargeconfigDao.selectByParkIdAndBillCode(parkId,regionChargeconfig.getBilltypecode());
                if (parkChargeConfig != null){
                    return getFreeTimeLocal(parkChargeConfig.getBilltype(), parkChargeConfig.getBilltypecode());
                }
            }
        }
        ObjectResponse<List<ParkChargeconfig>> chargeConfigResp = chargeService.getConfigs(parkId);
        if (!ObjectResponse.isSuccess(chargeConfigResp)) {
            log.info("未找到车场配置的计费规则. parkId[{}]", parkId);
            return null;
        }
        List<ParkChargeconfig> chargeConfigs = chargeConfigResp.getData();
        ParkChargeconfig parkChargeconfig = null;
        if (CollectionUtils.isNotEmpty(chargeConfigs)) {
            for (ParkChargeconfig chargeConfig : chargeConfigs) {
                if (chargeConfig.getDefaultCharge() != null && chargeConfig.getDefaultCharge() == 1) {
                    parkChargeconfig = chargeConfig;
                    break;
                }
            }
        }
        if (parkChargeconfig == null) {
            log.info("车场未配置默认的计费规则. parkId[{}]", parkId);
            return null;
        }
        Integer billType = parkChargeconfig.getBilltype();
        return getFreeTimeLocal(billType, parkChargeconfig.getBilltypecode());
    }
    public ParkChargeRuleVO getFreeTimeLocal(Integer billType, String billtypeCode) {
        ParkChargeRuleVO vo = new ParkChargeRuleVO();
        if (billType == 1) {
            ObjectResponse<ChargeNaturalDayDetail> chargeNaturaldayResp = chargeService.getNaturalday(billtypeCode);
            if (ObjectResponse.isSuccess(chargeNaturaldayResp) && chargeNaturaldayResp.getData() != null) {
                vo.setFreeTime(chargeNaturaldayResp.getData().getFreetime());
                vo.setIsFreetimeOnce(chargeNaturaldayResp.getData().getIsFreetimeOnce());
            }
        } else if (billType == 2) {
            ObjectResponse<ChargeDayNightDetail> chargeDaynightResp = chargeService.getDaynight(billtypeCode);
            if (ObjectResponse.isSuccess(chargeDaynightResp) && chargeDaynightResp.getData() != null) {
                vo.setFreeTime(chargeDaynightResp.getData().getFreetime());
                vo.setIsFreetimeOnce(chargeDaynightResp.getData().getIsFreetimeOnce());
            }
        } else if (billType == 3) {
            ObjectResponse<Charge24HourDetail> charge24chargeResp = chargeService.get24Hours(billtypeCode);
            if (ObjectResponse.isSuccess(charge24chargeResp) && charge24chargeResp.getData() != null) {
                vo.setFreeTime(charge24chargeResp.getData().getFreetime());
                vo.setIsFreetimeOnce(charge24chargeResp.getData().getIsFreetimeOnce());
            }
        }
        if (vo.getFreeTime() == null) {
            vo.setFreeTime(0);
        }
        if (vo.getIsFreetimeOnce() == null) {
            vo.setIsFreetimeOnce(0);
        }
        return vo;
    }

    public Integer getFreeTimeByBillId(Integer billId) {

        ParkChargeconfig parkChargeconfig = parkChargeconfigDao.selectByPrimaryKey(billId);
        if (Objects.isNull(parkChargeconfig)) {
            log.info("未找到计费规则. billId[{}]", billId);
            return 0;
        }
        if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.通用自然天.type) {
            ObjectResponse<ChargeNaturalDayDetail> naturaldayObjectResponse = chargeService.getNaturalday(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(naturaldayObjectResponse)) {
                ChargeNaturalday data1 = naturaldayObjectResponse.getData();
                return data1.getFreetime();
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.白天夜间收费.type) {
            ObjectResponse<ChargeDayNightDetail> chargeDaynightObjectResponse = chargeService.getDaynight(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(chargeDaynightObjectResponse)) {
                ChargeDaynight data1 = chargeDaynightObjectResponse.getData();
                return data1.getFreetime();
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.二十四小时计费.type) {
            ObjectResponse<Charge24HourDetail> charge24chargeObjectResponse = chargeService.get24Hours(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(charge24chargeObjectResponse)) {
                Charge24charge data1 = charge24chargeObjectResponse.getData();
                return data1.getFreetime();
            }
        }
        return 0;
    }

    public ChargeConfigDTO getChargeByBillId(ParkChargeconfig parkChargeconfig, Integer carType) {
        ChargeConfigDTO dto = new ChargeConfigDTO();
        if (Objects.isNull(parkChargeconfig)) {
            log.info("未找到计费规则, parkChargeconfig[{}]", parkChargeconfig);
            dto.setFreeTime(0);
            return dto;
        }
        dto.setBillId(parkChargeconfig.getId());
        if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.通用自然天.type) {
            ObjectResponse<ChargeNaturalDayDetail> naturaldayObjectResponse = chargeService.getNaturalday(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(naturaldayObjectResponse)) {
                ChargeNaturalday data1 = naturaldayObjectResponse.getData();
                dto.setFreeTime(data1.getFreetime());
                dto.setIsFreetimeOnce(data1.getIsFreetimeOnce());
                if (!Objects.isNull(data1.getDaynightmaxfeeusing())) {
                    dto.setDaynightmaxfeeusing(data1.getDaynightmaxfeeusing());
                }
                if (!Objects.isNull(data1.getMaxFeeType())) {
                    dto.setMaxFeeType(data1.getMaxFeeType());
                }
                if (!Objects.isNull(data1.getDaynightmaxfee())) {
                    if (Objects.nonNull(carType) && carType == 2) {
                        dto.setDaynightmaxfee(data1.getDaynightmaxfeeBig());
                    } else {
                        dto.setDaynightmaxfee(data1.getDaynightmaxfee());
                    }
                }
                if (!Objects.isNull(data1.getCountType())) {
                    dto.setCountType(data1.getCountType());
                }
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.白天夜间收费.type) {
            ObjectResponse<ChargeDayNightDetail> chargeDaynightObjectResponse = chargeService.getDaynight(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(chargeDaynightObjectResponse)) {
                ChargeDaynight data1 = chargeDaynightObjectResponse.getData();

                dto.setFreeTime(data1.getFreetime());
                dto.setIsFreetimeOnce(data1.getIsFreetimeOnce());
                if (!Objects.isNull(data1.getDaynightmaxfeeusing())) {
                    dto.setDaynightmaxfeeusing(data1.getDaynightmaxfeeusing());
                }
                if (!Objects.isNull(data1.getMaxFeeType())) {
                    dto.setMaxFeeType(data1.getMaxFeeType());
                }
                if (!Objects.isNull(data1.getDaynightmaxfee())) {
                    if (Objects.nonNull(carType) && carType == 2) {
                        dto.setDaynightmaxfee(data1.getDaynightmaxfeeBig());
                    } else {
                        dto.setDaynightmaxfee(data1.getDaynightmaxfee());
                    }
                }
                if (!Objects.isNull(data1.getCountType())) {
                    dto.setCountType(data1.getCountType());
                }
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.二十四小时计费.type) {
            ObjectResponse<Charge24HourDetail> charge24chargeObjectResponse = chargeService.get24Hours(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(charge24chargeObjectResponse)) {
                Charge24charge data1 = charge24chargeObjectResponse.getData();
                dto.setFreeTime(data1.getFreetime());
                dto.setIsFreetimeOnce(data1.getIsFreetimeOnce());
                if (!Objects.isNull(data1.getDaynightmaxfeeusing())) {
                    dto.setDaynightmaxfeeusing(data1.getDaynightmaxfeeusing());
                }
                if (!Objects.isNull(data1.getMaxFeeType())) {
                    dto.setMaxFeeType(data1.getMaxFeeType());
                }
                if (!Objects.isNull(data1.getDaynightmaxfee())) {
                    if (Objects.nonNull(carType) && carType == 2) {
                        dto.setDaynightmaxfee(data1.getDaynightmaxfeeBig());
                    } else {
                        dto.setDaynightmaxfee(data1.getDaynightmaxfee());
                    }
                }
                if (!Objects.isNull(data1.getCountType())) {
                    dto.setCountType(data1.getCountType());
                }
            }
        }
        return dto;
    }
    /**
     * 获取车场机构id
     * @param parkId
     * @return
     */
    @Override
    public List<OrganizationTreeDto> selectParksDetails(String parkId) {
        return parkDao.selectParksDetails(parkId);
    }

    @Override
    public OrganizationTreeDto selectOrganizDetailsByName(String institutionName) {
        return parkDao.selectOrganizDetailsByName(institutionName);
    }

    @Override
    public Boolean updateParkInstitutionId(Integer institutionId, Long parkId) {
        return parkDao.updateParkInstitutionId(institutionId, parkId) > 0;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ObjectResponse<Void> deletePark(Long parkId,Integer orgId, String parkCode) {
        // 1.把车场机构id替换成回收站机构id
        Boolean result = updateParkInstitutionId(orgId, parkId);
        if (!result) {
            return ObjectResponse.failed("10000", "车场回收站失败");
        }
        // 删除redis车场缓存
        removeParkInfoFromRedis(parkCode, parkId);
        List<SaasUserPark> saasUserParks = saasUserParkService.listByParkId(parkId);
        if (CollectionUtils.isNotEmpty(saasUserParks)) {
            // 2.删除saas用户和车场关联关系
            saasUserParkService.deleteByParkIds(saasUserParks.stream()
                    .map(SaasUserPark::getId)
                    .collect(Collectors.toList()));
        }
        // 3.删除车场和三方关联关系
        List<ThirdPark> thirdParks = thirdParkService.findAllByParkId(parkId);
        if (CollectionUtils.isNotEmpty(thirdParks)) {
            thirdParkService.deleteByIds(thirdParks.stream()
                    .map(ThirdPark::getId)
                    .collect(Collectors.toList()));
        }
        return ObjectResponse.success();
    }

    @Override
    public ParkInoutdevice getChannelByCodeAndParkId(Long parkId, String inandoutCode) {
        return getInOutDeviceByCode(parkId, inandoutCode).getData();
    }

    @Override
    public List<ChangPingParkUser> getChangPingParkUser(Long parkId, String parkCode) {
        ObjectResponse<Park> parkObjectResponse = findByParkId(parkId);
        if (parkObjectResponse.getData() == null) {
            return Collections.emptyList();
        }
        Park park = parkObjectResponse.getData();
        List<SaasUser> users = saasUserDao.getRoleIdsByInstitutionId(park.getInstitutionId(), Collections.singletonList("云岗亭管理员"));
        if (CollectionUtils.isEmpty(users)) {
            return Collections.emptyList();
        }
        return users.stream()
                .map(s -> ChangPingParkUser.builder()
                        .parklotCode(parkCode)
                        .userCode(String.valueOf(s.getId()))
                        .userName(s.getUsername())
                        .phone(s.getPhone())
                        .passWd(s.getPassword())
                        .type("0")
                        .build())
                .collect(Collectors.toList());
    }

    @Override
    public ObjectResponse<ParkAllInfo> getAllParkInfo(String parkCode) {
        ParkAllInfo parkAllInfo = new ParkAllInfo();
        ObjectResponse<Park> parkObjectResponse = findByParkCode(parkCode);
        Park park = parkObjectResponse.getData();
        //获取空车位信息
        ObjectResponse<ParkFreespace> freeSpaceResponse = parkFreeSpaceService.getSpaceByPark(park.getId());
        ParkFreespace parkFreespace = freeSpaceResponse.getData();
        //获取计费规则信息
        ObjectResponse<ParkConfig> objectResponse = getParkConfig(park.getId());
        if (!ObjectResponse.isSuccess(objectResponse)){
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        ParkConfig data = objectResponse.getData();
        ParkChargeconfig parkChargeconfig = parkChargeconfigDao.selectDefaultBill(park.getId());
        if (Objects.nonNull(parkChargeconfig)){
            FeeParamHolder feeParamHolder = new FeeParamHolder(data, parkChargeconfig);
            ChargeRuleCfgDTO chargeRuleCfgDTO = feeParamHolder.getSChargeRuleObj(parkChargeconfig.getId());
            parkAllInfo.setChargeRuleCfgDTO(chargeRuleCfgDTO);
        }
        parkAllInfo.setParkCode(park.getParkCode());
        parkAllInfo.setParkName(park.getParkName());
        parkAllInfo.setAddress(park.getAddress());
        parkAllInfo.setLat(park.getLat());
        parkAllInfo.setLng(park.getLng());
        parkAllInfo.setLocation(park.getLat());
        parkAllInfo.setFreeSpaceNum(parkFreespace.getFreeSpace());
        return ObjectResponse.success(parkAllInfo);
    }

    public static final String STATISTICS_TIME = "statistics:parkspace:";
    @Override
    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<ParkSpaceInfo>> getParkSpaceList(ParkQuery parkQuery) {
        String redisKey = STATISTICS_TIME + parkQuery.getPageNo()+":"
                + parkQuery.getPageSize()+":"+ parkQuery.getCity()+":"
                + parkQuery.getCardType()+":"+ parkQuery.getLng()+":"
                + parkQuery.getLat()+":"
                + parkQuery.getParkCode()+":"+ parkQuery.getParkProperty()+":"
                + parkQuery.getRangeLocation()+":"+ parkQuery.getKey();
        com.icetech.common.domain.Page<ParkSpaceInfo> pageInfo = redisHandle.cacheObject(redisKey, new TypeReference<com.icetech.common.domain.Page< ParkSpaceInfo >>() {
        }, () -> {
            AreaCity areaCity = areaCityDao.selectByCode(parkQuery.getCity());
            if (areaCity == null) {
                return null;
            }
            parkQuery.setCityAreaId(areaCity.getId());
            Page<ParkSpaceInfo> parkList =  PageHelper.startPage(parkQuery.getPageNo(), parkQuery.getPageSize()).doSelectPage(()->{
                parkDao.getParkSpaceList(parkQuery);
            });
            //数据过滤 and 排序
            List<ParkSpaceInfo> resultList = parkList.getResult();
            if (CollectionUtil.isNotEmpty(resultList)){
                List<Long> parkIds = resultList.stream().map(ParkSpaceInfo::getId).collect(Collectors.toList());
                List<MonthProductDto> monthProduct = parkDao.getMonthProduct(null, parkIds, parkQuery.getCardType());
                Map<Long, List<MonthProductDto>> mapList = monthProduct.stream().collect(Collectors.groupingBy(MonthProductDto::getParkId));
                List<ParkChargeconfig> parkChargeconfigs = parkChargeconfigDao.selectList(Wrappers.lambdaQuery(ParkChargeconfig.class).eq(ParkChargeconfig::getDefaultCharge, 1)
                        .eq(ParkChargeconfig::getStatus, 0).in(ParkChargeconfig::getParkId, parkIds));
                Map<Long, List<ParkChargeconfig>> listMap = parkChargeconfigs.stream().collect(Collectors.groupingBy(ParkChargeconfig::getParkId));
                for (ParkSpaceInfo result:resultList){
                    //查询月卡套餐信息
                    List<MonthProductDto> monthProducts = mapList.get(result.getId());
                    if (CollectionUtils.isNotEmpty(monthProducts)){
                        log.info("[查询到月卡套餐信息] parkCode {}",result.getParkCode());
                        result.setMonthProduct(monthProducts);
                    }
                    try {
                        if (Objects.nonNull(listMap.get(result.getId()))){
                            List<ParkChargeconfig> parkChargeconfigList = listMap.get(result.getId());
                            if (CollectionUtil.isNotEmpty(parkChargeconfigList)){
                                result.setSBilltype(parkChargeconfigList.get(0).getBilltype());
                            }
                        }
                    }catch (Exception e){
                        log.error("[查询计费信息失败] parkCode {}",result.getParkCode(),e);
                    }
                }
            }

            return com.icetech.common.domain.Page.instance(parkList.getPages(), parkList.getTotal(), resultList);
        }, 30 * 1000);
        return ObjectResponse.success(pageInfo);
    }

    public static final String STATISTICS_TIME_VISIT = "statistics:visit:";
    @Override
    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<ParkVisitInfo>> getParkVisitList(ParkQuery parkQuery) {
        String redisKey = STATISTICS_TIME_VISIT + parkQuery.getPageNo()+":"
                + parkQuery.getPageSize()+":"+ parkQuery.getCity()+":"
                + parkQuery.getCardType()+":"+ parkQuery.getLng()+":"
                + parkQuery.getLat()+":"
                + parkQuery.getParkCode()+":"+ parkQuery.getParkProperty()+":"
                + parkQuery.getRangeLocation()+":"+ parkQuery.getKey();
        com.icetech.common.domain.Page<ParkVisitInfo> pageInfo = redisHandle.cacheObject(redisKey, new TypeReference<com.icetech.common.domain.Page< ParkVisitInfo >>() {
        }, () -> {
            AreaCity areaCity = areaCityDao.selectByCode(parkQuery.getCity());
            if (areaCity == null) {
                return null;
            }
            parkQuery.setCityAreaId(areaCity.getId());
            Page<ParkVisitInfo> parkList =  PageHelper.startPage(parkQuery.getPageNo(), parkQuery.getPageSize()).doSelectPage(()->{
                parkDao.getParkVisitList(parkQuery);
            });
            //数据过滤 and 排序
            List<ParkVisitInfo> resultList = parkList.getResult();
            if (CollectionUtil.isNotEmpty(resultList)){
                List<Long> parkIds = resultList.stream().map(ParkVisitInfo::getId).collect(Collectors.toList());
                ObjectResponse<Map<Long, ParkFreespace>> parkMaps = parkFreeSpaceService.getSpacesByPark(parkIds);
                for (ParkVisitInfo result:resultList){
                    ParkConfig parkConfig = getParkConfig(result.getId()).getData();
                    result.setIsVisit(parkConfig.getIsVisit());
                    result.setVisitIscharge(parkConfig.getVisitIscharge());
                    result.setVisitInoutNum(parkConfig.getVisitInoutNum());
                    if (ObjectResponse.isSuccess(parkMaps)){
                        Map<Long, ParkFreespace> data = parkMaps.getData();
                        ParkFreespace parkFreespace = data.get(result.getId());
                        if (Objects.nonNull(parkFreespace)){
                            result.setTotalNum(parkFreespace.getTotalNum());
                            result.setFreeSpace(parkFreespace.getFreeSpace());
                            result.setRealFreeSpace(parkFreespace.getRealFreeSpace());
                        }
                    }
                }
            }
            return com.icetech.common.domain.Page.instance(parkList.getPages(), parkList.getTotal(), resultList);
        }, 30 * 1000);
        return ObjectResponse.success(pageInfo);
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<List<ParkDistanceInfo>> getParkDistance(ParkDistanceParam param) {
        return ObjectResponse.success(parkDao.getParkDistance(param));
    }

    @Override
    public ObjectResponse<List<Park>> likeParkName(String city,String key) {
        AreaCity areaCity = areaCityDao.selectByCode(city);
        return ObjectResponse.success(parkDao.selectLikeParkName(areaCity.getId(),key));
    }
    @Override
    public ObjectResponse<List<ParkInoutdevice>> getInOutDevicesByRegionId(Long regionId, Integer enexType) {
        List<ParkInoutdevice> list = parkInoutdeviceDao.findByRegionId(regionId, enexType);
        return ObjectResponse.returnNotFoundIfNull(list);
    }

    @Override
    public boolean isInterior(Long parkId) {
        ObjectResponse<Park> objectResponse = findByParkId(parkId);
        ObjectResponse.notError(objectResponse);
        return NumberUtils.toPrimitive(objectResponse.getData().getIsInterior()) == 1;
    }

    @Override
    public ObjectResponse<AreaCity> getCityBy(String name) {
        AreaCity areaCity = areaCityDao.selectCityByName(name);
        return areaCity == null ? ObjectResponse.failed() : ObjectResponse.success(areaCity);
    }

    @Override
    public ObjectResponse<com.icetech.common.domain.Page<Park>> getParkPage(Integer pageNo, Integer pageSize, String parkName, Integer cityId) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Park> page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>();
        page.setCurrent(pageNo);
        page.setSize(pageSize);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Park> parks = parkDao.selectParkPage(page, parkName, cityId);
        return ObjectResponse.success(com.icetech.common.domain.Page.instance(Math.toIntExact(parks.getPages()), parks.getTotal(), parks.getRecords()));
    }

    @Override
    public ObjectResponse<Void> updateParkInputStatus(Long parkId, Integer inputStatus, String payWay) {
        BasePark park = getById(parkId);
        if (park == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "车场不存在");
        }
        //更新状态
        park.setInputStatus(inputStatus);
        updateById(park);
        // 删除车场想相关的缓存设置
        removeParkInfoFromRedis(park.getParkCode(), parkId);
        // 支付方式设置
        if (StringUtils.isNotEmpty(payWay) && Objects.nonNull(inputStatus) && inputStatus == 4) {
            ObjectResponse<ParkConfig> configObj = getParkConfig(parkId);
            if (ObjectResponse.isSuccess(configObj)) {
                ParkConfig config = configObj.getData();
                ParkConfig update = new ParkConfig();
                update.setId(config.getId());
                update.setIsEpayment(1);
                update.setEPayment(payWay);
                try {
                    parkConfigDao.updateById(update);
                    // 删除缓存
                    removeParkConfigFromRedis(parkId, park.getParkCode());
                    // 下发高级配置
                    sendInfoService.save(new SendInfo(parkId, config.getId(), DownServiceEnum.车场配置.getServiceType()));
                }catch (Exception e) {
                    log.error("支付进件成功修改高级配置支付方式[{}]并下发高级配置", payWay);
                }
            }
        }
        return ObjectResponse.success();
    }

    @Override
    @Transactional
    public ObjectResponse<Boolean> batchUpdateParkInputStatusByParkId(Map<Long, Integer> statusMap) {
        if (statusMap == null || statusMap.isEmpty()) return ObjectResponse.success();
        List<BasePark> parks = list(getLambdaQueryWrapper().select(BasePark::getId, BasePark::getParkCode).in(BasePark::getId, statusMap.keySet()));
        if (CollectionUtils.isEmpty(parks)) return ObjectResponse.success();
        List<BasePark> updateParks = statusMap.entrySet().stream().map(entry -> new BasePark().setId(entry.getKey()).setInputStatus(entry.getValue())).collect(Collectors.toList());
        boolean result = updateBatchById(updateParks);
        parks.forEach(park -> removeParkInfoFromRedis(park.getParkCode(), park.getId()));
        return ObjectResponse.success(result);
    }

    @Override
    public List<InitBstPark> findBstInitPark() {
        return parkDao.selectBstInitPark();
    }

    @Override
    public List<Park> findByParkIds(List<Long> parkIds) {
        return parkDao.selectByParkIds(parkIds);
    }

    @Override
    public ObjectResponse<Park> findByParkName(String parkName) {
        Park park = parkDao.selectParkByName(parkName);
        if (Objects.isNull(park)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(park);
    }

    /**
     * 获取车场连接模式
     *
     * @param parkId
     * @param parkCode
     * @return
     */
    @Override
    public Integer getParkDataCollection(Long parkId, String parkCode) {
        if (parkId == null && StringUtils.isBlank(parkCode)) {
            return null;
        }
        if (parkId == null) {
            ObjectResponse<ParkConfig> parkConfigObj = getParkConfig(parkCode);
            if (!ObjectResponse.isSuccess(parkConfigObj)) {
                return null;
            }
            ParkConfig parkConfig = parkConfigObj.getData();
            return parkConfig.getDataCollection();
        }
        ObjectResponse<ParkConfig> parkConfigObj = getParkConfig(parkId);
        if (!ObjectResponse.isSuccess(parkConfigObj)) {
            return null;
        }
        ParkConfig parkConfig = parkConfigObj.getData();
        return parkConfig.getDataCollection();
    }

    @Override
    public ObjectResponse<AreaDistrict> getDistrictById(Integer districtId) {
        AreaDistrict areaDistrict = areaDistrictDao.selectById(districtId);
        return Objects.isNull(areaDistrict)  ? ObjectResponse.failed(CodeConstants.ERROR_404) : ObjectResponse.success(areaDistrict);
    }

    @Override
    public ObjectResponse updateParkSpace(ParkFreespace data) {
        return parkFreeSpaceService.updateByPark(data) ? ObjectResponse.success() : ObjectResponse.failed();
    }

    @Override
    public List<BasePark> getParkListByParkCodes(List<String> parkCods) {
        return parkDao.selectList(Wrappers.lambdaQuery(BasePark.class)
                .in(BasePark::getParkCode,parkCods));
    }
}
