package com.icetech.basics.service.dictionary.impl;

import com.google.common.collect.Lists;
import com.icetech.basics.api.DictionaryItemService;
import com.icetech.basics.dao.dictionary.DictionaryItemDao;
import com.icetech.cloudcenter.domain.constants.DictionaryTypeEnum;
import com.icetech.basics.domain.entity.dictionary.DictionaryItem;
import com.icetech.basics.domain.dto.DictionaryItemDto;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Slf4j
@Service("dictionaryItemService")
public class DictionaryItemServiceImpl implements DictionaryItemService {
    @Autowired
    private DictionaryItemDao dictionaryItemDao;
    @Override
    public ObjectResponse<List<DictionaryItemDto>> getOpenReasonList(Integer type) {
        try {
            if (type == 1){
                return findListByTypeId(DictionaryTypeEnum.入场开闸原因.getType());
            }else {
                return findListByTypeId(DictionaryTypeEnum.离场开闸原因.getType());
            }

        } catch (Exception e) {
            log.error("[车场管家获取开闸原因接口]异常: {}.", e.getMessage(), e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }
    @Override
    public ObjectResponse<List<DictionaryItemDto>> findListByTypeId(Integer type){
        List<DictionaryItem> dictionaryItems = dictionaryItemDao.selectByDictionaryType(type);
        if (CollectionUtils.isEmpty(dictionaryItems)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        List<DictionaryItemDto> list = Lists.newArrayList();
        dictionaryItems.forEach(dictionaryItem -> {
            DictionaryItemDto dictionaryItemDto = new DictionaryItemDto();
            dictionaryItemDto.setValue(dictionaryItem.getValue());
            dictionaryItemDto.setText(dictionaryItem.getText());
            list.add(dictionaryItemDto);
        });
        return ObjectResponse.success(list);
    }

    @Override
    public ObjectResponse<DictionaryItemDto> findOneItem(Integer typeId, String text, Integer value) {
        DictionaryItem dictionaryItem = dictionaryItemDao.selectOneItem(typeId, text, value);
        if (dictionaryItem == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        DictionaryItemDto dictionaryItemDto = new DictionaryItemDto();
        dictionaryItemDto.setText(dictionaryItem.getText());
        dictionaryItemDto.setValue(dictionaryItem.getValue());
        return ObjectResponse.success(dictionaryItemDto);
    }

}
