package com.icetech.basics.service.device.impl;

import com.icetech.basics.dao.device.FleetModeLogMapper;
import com.icetech.basics.domain.entity.device.FleetModeLog;
import com.icetech.cloudcenter.api.park.FleetModeLogService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 车队模式操作表 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-12-11
 */
@Service
public class FleetModeLogServiceImpl extends BaseServiceImpl<FleetModeLogMapper, FleetModeLog> implements FleetModeLogService {

    /**
     * Description: 根据ID查询 车队模式操作表对象信息 <br>
     * Version1.0 2024-12-11 by wanggang创建
     *
     * @param id 对象id
     * @return FleetModeLog
     */
    @Override
    public FleetModeLog getFleetModeLogById(Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  车队模式操作表对象信息 <br>
     * Version1.0 2024-12-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addFleetModeLog(FleetModeLog entity) {
        return save(entity);
    }

    /**
     * Description: 修改 车队模式操作表对象信息 <br>
     * Version1.0 2024-12-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyFleetModeLog(FleetModeLog entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  车队模式操作表对象信息 <br>
     * Version1.0 2024-12-11 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeFleetModeLogById(Long id) {
        return removeById(id);
    }

}
