package com.icetech.basics.service.charge;

import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.domain.charge.detail.Charge24HourDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeDayNightDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeNaturalDayDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeTypeDetail;
import com.icetech.cloudcenter.domain.charge.dto.ChargeConfigCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.ChargeRuleCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.DayNightChargeCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.DyrationChargeCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.NaturalChargeCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.OnceChargeCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.charge.dto.S24HoursChargeCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.S24HoursRateCfgDTO;
import com.icetech.cloudcenter.domain.charge.dto.StepChargeCfgDTO;
import com.icetech.basics.domain.entity.charge.Charge24chargeSet;
import com.icetech.basics.domain.entity.charge.ChargeDuration;
import com.icetech.basics.domain.entity.charge.ChargeOnce;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
@Getter
@Setter
@ToString
public class BaseFeeParamHolder {
    /**
     * 是否终止责任链
     */
    protected boolean isBreak;

    protected QueryOrderFeeRequest queryOrderFeeRequest;
    protected QueryOrderFeeResponse queryOrderFeeResponse;
    protected OrderInfo orderInfo;
    protected ParkConfig parkConfig;
    protected Map<Integer, ParkChargeconfig> parkChargeconfigMap = new LinkedHashMap<>();
    protected Park park;
    protected ChargeService chargeService;
    protected ParkChargeconfigDao parkChargeconfigDao;
    protected VipType vipType;
    protected OrderSumFeeDto orderSumFeeDto;
    //内场子订单
    protected OrderSonInfo innerOrderSonInfo;

    /**使用到的计费规则ID列表**/
    protected Set<Integer> billIdList;
    protected Set<Integer> innerBillIdList;
    protected String sChargeConfigCfg;
    protected Map<Integer, String> sChargeRuleMap = new HashMap<>();
    protected Long startTime;
    protected Long endTime;
    protected Long queryTime;
    protected Long parkTime;
    protected BigDecimal surplusfee;
    /** 月卡计费标识 */
    protected boolean isMonthCarFee = false;
    /** 错时月卡计费标识 */
    protected boolean isCsMonthCarFee;
    protected int csFeeType;
    protected String csStartTime, csEndTime;
    protected Long csSwitchTime;
    protected float thisFee;
    protected boolean isUseFreetime;
    protected List<ExtraComputeFeePara> extraComputeFeeParaList = new ArrayList<>();

    public String getSChargeConfigCfg(ParkConfig parkConfig) {
        if (sChargeConfigCfg == null) {
            ChargeConfigCfgDTO chargeConfigCfgDTO = ChargeConfigCfgDTO.builder()
                    .sBill_precision(NumberUtils.toPrimitive(parkConfig.getBillPrecision()))
                    .sFreetime_status(NumberUtils.toPrimitive(parkConfig.getFreetimeStatus(), 2))
                    .sIs_filltime(NumberUtils.toPrimitive(parkConfig.getIsFilltime(), 1))
                    .sOvertime_bill_type(NumberUtils.toPrimitive(parkConfig.getOvertimeBillType(), 1))
                    .sIsallowfreetmonce(NumberUtils.toPrimitive(parkConfig.getIsallowfreetmonce(), 1))
                    .sIsnotgetsmallchange(NumberUtils.toPrimitive(parkConfig.getIsnotgetsmallchange(), 1))
                    .sSwitch_type(NumberUtils.toPrimitive(parkConfig.getSwitchType(), 1))
                    .sChargeVersionNum(NumberUtils.toPrimitive(parkConfig.getChargeVersionNum()))
                    .build();
            this.sChargeConfigCfg = JsonUtils.toString(chargeConfigCfgDTO);
        }
        return sChargeConfigCfg;
    }
    public ChargeRuleCfgDTO getSChargeRuleObj(){
        return getSChargeRuleObj(getParkChargeConfig());
    }
    public ChargeRuleCfgDTO getSChargeRuleObj(Integer billId){
        return getSChargeRuleObj(parkChargeconfigMap.get(billId));
    }
    public ChargeRuleCfgDTO getSChargeRuleObj(ParkChargeconfig parkChargeconfig) {
        ChargeRuleCfgDTO chargeRuleCfg = new ChargeRuleCfgDTO();
        chargeRuleCfg.setSBilltypecode(parkChargeconfig.getBilltypecode());
        chargeRuleCfg.setSBilltype(parkChargeconfig.getBilltype());
        if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.通用自然天.type) {
            ObjectResponse<ChargeNaturalDayDetail> naturaldayObjectResponse = chargeService.getNaturalday(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(naturaldayObjectResponse)) {
                ChargeNaturalDayDetail data1 = naturaldayObjectResponse.getData();
                NaturalChargeCfgDTO naturalChargeCfgDTO = NaturalChargeCfgDTO.builder()
                        .sFreetime(NumberUtils.toPrimitive(data1.getFreetime()))
                        .sDaynightmaxfeeusing(NumberUtils.toPrimitive(data1.getDaynightmaxfeeusing()))
                        .sDaynightmaxfee(data1.getDaynightmaxfee())
                        .sMaxfeetype(data1.getMaxFeeType())
                        .sDaynightmaxfee_big(data1.getDaynightmaxfeeBig())
                        .sBillmethod(NumberUtils.toPrimitive(data1.getBillmethod()))
                        .sNoworkBillmethod(NumberUtils.toPrimitive(data1.getNoworkBillmethod()))
                        .sIsspecialdaycharge(NumberUtils.toPrimitive(data1.getIsspecialdaycharge(), 2))
                        .build();
                ChargeTypeDetail workdayDetail = data1.getWorkdayDetail();
                ChargeTypeDetail holidayDetail = data1.getHolidayDetail();
                //按次计费
                if (NumberUtils.toPrimitive(workdayDetail.getChargeType()) == 1) {
                    OnceChargeCfgDTO onceChargeCfgDTO = buildOnceChargeCfg(workdayDetail);
                    naturalChargeCfgDTO.setSWork_OnceCharge(onceChargeCfgDTO);
                }else {
                    DyrationChargeCfgDTO dyrationChargeCfgDTO = buildDyrationChargeCfg(workdayDetail);
                    naturalChargeCfgDTO.setSWork_DyrationCharge(dyrationChargeCfgDTO);
                }
                //区分工作日和非工作日时
                if (Integer.valueOf(1).equals(data1.getIsspecialdaycharge())) {
                    //按次计费
                    if (NumberUtils.toPrimitive(holidayDetail.getChargeType()) == 1) {
                        OnceChargeCfgDTO onceChargeCfgDTO2 = buildOnceChargeCfg(holidayDetail);
                        naturalChargeCfgDTO.setSNoWork_OnceCharge(onceChargeCfgDTO2);
                    }else{
                        //按时计费
                        DyrationChargeCfgDTO dyrationChargeCfgDTO2 = buildDyrationChargeCfg(holidayDetail);
                        naturalChargeCfgDTO.setSNoWork_DyrationCharge(dyrationChargeCfgDTO2);
                    }
                }
                chargeRuleCfg.setSNaturalCharge(naturalChargeCfgDTO);
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.白天夜间收费.type) {
            ObjectResponse<ChargeDayNightDetail> chargeDaynightObjectResponse = chargeService.getDaynight(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(chargeDaynightObjectResponse)) {
                ChargeDayNightDetail data1 = chargeDaynightObjectResponse.getData();
                DayNightChargeCfgDTO dayNightChargeCfgDTO = DayNightChargeCfgDTO.builder()
                        .sBillmethodday(data1.getBillmethodday())
                        .sBillmethodnight(NumberUtils.toPrimitive(data1.getBillmethodnight()))
                        .sFreetime(NumberUtils.toPrimitive(data1.getFreetime()))
                        .sDaynightmaxfeeusing(NumberUtils.toPrimitive(data1.getDaynightmaxfeeusing()))
                        .sMaxfeetype(data1.getMaxFeeType())
                        .sDaynightmaxfee(data1.getDaynightmaxfee())
                        .sDaynightmaxfee_big(data1.getDaynightmaxfeeBig())
                        .sDaybegin(data1.getDaybegin())
                        .sNightbegin(data1.getNightbegin())
                        .sDaymaxfeeusing(NumberUtils.toPrimitive(data1.getDaymaxfeeusing(), 2))
                        .sDaymaxfee(data1.getDaymaxfee())
                        .sDaymaxfee_big(data1.getDaymaxfeeBig())
                        .sNightmaxfeeusing(NumberUtils.toPrimitive(data1.getNightmaxfeeusing(), 2))
                        .sNightmaxfee(data1.getNightmaxfee())
                        .sNightmaxfee_big(data1.getNightmaxfeeBig())
                        .build();
                //白天计费规则
                ChargeTypeDetail dayDetail = data1.getDailyDetail();
                //夜间计费规则
                ChargeTypeDetail nightlyDetail = data1.getNightlyDetail();

                //白天按次计费
                if (NumberUtils.toPrimitive(dayDetail.getChargeType()) == 1) {
                    OnceChargeCfgDTO onceChargeCfgDTO = buildOnceChargeCfg(dayDetail);
                    dayNightChargeCfgDTO.setSDay_OnceCharge(onceChargeCfgDTO);
                }else {
                    //白天按时计费
                    DyrationChargeCfgDTO dyrationChargeCfgDTO = buildDyrationChargeCfg(dayDetail);
                    dayNightChargeCfgDTO.setSDay_DyrationCharge(dyrationChargeCfgDTO);
                }

                if (NumberUtils.toPrimitive(nightlyDetail.getChargeType()) == 1) {
                    //夜间按次计费
                    OnceChargeCfgDTO onceChargeCfgDTO2 = buildOnceChargeCfg(nightlyDetail);
                    dayNightChargeCfgDTO.setSNight_OnceCharge(onceChargeCfgDTO2);
                } else {
                    //夜间按时计费
                    DyrationChargeCfgDTO dyrationChargeCfgDTO2 = buildDyrationChargeCfg(nightlyDetail);
                    dayNightChargeCfgDTO.setSNight_DyrationCharge(dyrationChargeCfgDTO2);
                }
                chargeRuleCfg.setSDayNightCharge(dayNightChargeCfgDTO);
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.二十四小时计费.type) {

            ObjectResponse<Charge24HourDetail> charge24chargeObjectResponse = chargeService.get24Hours(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(charge24chargeObjectResponse)) {
                Charge24HourDetail data1 = charge24chargeObjectResponse.getData();
                S24HoursChargeCfgDTO s24HoursChargeCfgDTO = S24HoursChargeCfgDTO.builder()
                        .sFreetime(data1.getFreetime())
                        .sDaynightmaxfeeusing(NumberUtils.toPrimitive(data1.getDaynightmaxfeeusing()))
                        .sMaxfeetype(data1.getMaxFeeType())
                        .sDaynightmaxfee(data1.getDaynightmaxfee())
                        .sDaynightmaxfee_big(data1.getDaynightmaxfeeBig())
                        .sDivisionTime(data1.getDivisionTime())
                        .sIsOverTimeSet(NumberUtils.toPrimitive(data1.getIsOverTimeSet(), 2))
                        .sFeeSpanTimeStep(data1.getFeespantimestep())
                        .sFeeSpanRateStep(data1.getFeespanratestep())
                        .sFeeSpanRateStep_big(data1.getFeespanratestepBig())
                        .build();

                List<Charge24chargeSet> chargeDetails = data1.getChargeDetails();
                if (CollectionUtils.isNotEmpty(chargeDetails)) {
                    List<S24HoursRateCfgDTO> charge24RuleDetails = chargeDetails.stream().map(charge24chargeSet ->
                            S24HoursRateCfgDTO.builder()
                                    .sRecordStatus(charge24chargeSet.getFeespantime() % data1.getDivisionTime() == 0 ? 1 : 0)
                                    .sFeeSpanTime(charge24chargeSet.getFeespantime())
                                    .sFeeSpanRate(charge24chargeSet.getFeespanrate())
                                    .sFeeSpanRate_big(charge24chargeSet.getFeespanrateBig())
                                    .build()
                    ).collect(Collectors.toList());
                    s24HoursChargeCfgDTO.setSRateCfg(charge24RuleDetails);
                }
                chargeRuleCfg.setS24HoursCharge(s24HoursChargeCfgDTO);
            }
        }
       return chargeRuleCfg;
    }

    public String getSChargeRule(ParkChargeconfig parkChargeconfig) {
        String sChargeRule = sChargeRuleMap.get(parkChargeconfig.getId());
        if (sChargeRule == null) {
            sChargeRule = JsonUtils.toString(getSChargeRuleObj(parkChargeconfig));
            this.sChargeRuleMap.put(parkChargeconfig.getId(), sChargeRule);
        }
        return sChargeRule;
    }

    protected DyrationChargeCfgDTO buildDyrationChargeCfg(ChargeTypeDetail workdayDetail) {
        ChargeDuration duration = workdayDetail.getDuration();
        if (duration == null) {
            duration = new ChargeDuration();
        }
        // 非阶梯计费查询
        DyrationChargeCfgDTO dyrationChargeCfgDTO = DyrationChargeCfgDTO.builder()
                .sIsOverTimeSet(NumberUtils.toPrimitive(duration.getIsOverTimeSet(), 2))
                .sOverTime(duration.getOverTime())
                .sFeeSpanTime(duration.getFeespantime())
                .sFeeSpanRate(duration.getFeespanrate())
                .sFeeSpanRate_big(duration.getFeespanrateBig())
                .build();
        // 阶梯计费查询
        List<ChargeDuration> periodDurations = workdayDetail.getPeriodDurations();
        if (CollectionUtils.isNotEmpty(periodDurations)) {
            List<StepChargeCfgDTO> stepChargeDetailList = periodDurations.stream().map(dura ->
                StepChargeCfgDTO.builder()
                        .sRecordStatus(1)
                        .sStartTimeModule(dura.getStartTimeModule())
                        .sEndTimeModule(dura.getEndTimeModule())
                        .sFeeSpanTime(dura.getFeespantime())
                        .sFeeSpanRate(dura.getFeespanrate())
                        .sFeeSpanRate_big(dura.getFeespanrateBig())
                        .build()
            ).collect(Collectors.toList());
            dyrationChargeCfgDTO.setSStepChargeCfg(stepChargeDetailList);
        }
        return dyrationChargeCfgDTO;
    }

    protected OnceChargeCfgDTO buildOnceChargeCfg(ChargeTypeDetail workdayDetail) {
        ChargeOnce once = workdayDetail.getOnce();
        if (once == null) {
            throw new ResponseBodyException(CodeConstants.ERROR_3001, "按次计费规则不完整");
        }
        return OnceChargeCfgDTO.builder()
                .sIsopenoncecharge(NumberUtils.toPrimitive(once.getIsopenoncecharge(), 1))
                .sOncechargefee(once.getOncechargefee())
                .sOncechargefee_big(once.getOncechargefeeBig())
                .sIsopenother2(NumberUtils.toPrimitive(once.getIsopenother2(), 2))
                .sTimeFrame(once.getTimeFrame())
                .sTimeFrameOncefee(once.getTimeFrameOncefee())
                .sTimeFrameOncefee_big(once.getTimeFrameOncefeeBig())
                .sOtherTimeFrameOncefee(once.getOtherTimeframeOncefee())
                .sOtherTimeFrameOncefee_big(once.getOtherTimeframeOncefeeBig())
                .sIsattachoption(NumberUtils.toPrimitive(once.getIsattachoption(), 2))
                .sOverTime(once.getOverTime())
                .sAddOvernightFee(once.getAddOvernightFee())
                .sAddOvernightFee_big(once.getAddOvernightFeeBig())
                .build();
    }

    public void addExtraFeePara(ExtraComputeFeePara extraComputeFeePara) {
        extraComputeFeeParaList.add(extraComputeFeePara);
    }
    public void addAllExtraFeePara(List<ExtraComputeFeePara> extraComputeFeeParas) {
        extraComputeFeeParaList.addAll(extraComputeFeeParas);
    }

    public void putParkChargeConfig(Integer billId, ParkChargeconfig parkChargeconfig) {
        this.parkChargeconfigMap.put(billId, parkChargeconfig);
    }

    public ParkChargeconfig getParkChargeConfig() {
        Map.Entry<Integer, ParkChargeconfig> firstEntry = this.parkChargeconfigMap.entrySet().iterator().next();
        if (firstEntry == null) {
            return null;
        }
        return firstEntry.getValue();
    }

    public ParkChargeconfig getParkChargeConfig(Integer billId) {
        ParkChargeconfig parkChargeConfig = this.parkChargeconfigMap.get(billId);
        if (parkChargeConfig == null) {
            parkChargeConfig = parkChargeconfigDao.selectByPrimaryKey(billId);
            this.parkChargeconfigMap.put(billId, parkChargeConfig);
        }
        return parkChargeConfig;
    }
    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    @Accessors(chain = true)
    public static class ExtraComputeFeePara {
        protected Long startTime;
        protected Long endTime;
        protected boolean isCsMonthCarFee;
        protected int csFeeType;
        protected String csStartTime, csEndTime;
        protected Long csSwitchTime;
        protected Integer billId;
    }
}
