package com.icetech.basics.service.apk;

import cn.hutool.core.util.StrUtil;
import com.icetech.basics.api.apk.ApkVersionService;
import com.icetech.basics.dao.apk.ApkVersionDao;
import com.icetech.basics.domain.entity.ApkVersion;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.oss.OssService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Objects;

/**
 * <p>
 *  安卓app管理 服务实现类
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-04-02
 */
@Service
@Slf4j
public class ApkVersionServiceImpl implements ApkVersionService {
    @Resource
    private ApkVersionDao apkVersionDao;
    @Resource
    private OssService ossService;

    @Override
    public ObjectResponse<ApkVersion> getLastVersion(Integer userId) {
        ApkVersion lastVersion = apkVersionDao.getLastVersion();
        if (Objects.isNull(lastVersion)){
            log.warn("[当前没有最新版本]");
            return ObjectResponse.success();
        }
        if (StrUtil.isNotBlank(lastVersion.getApkPath())){
            lastVersion.setApkPath(ossService.getImageUrlTime(lastVersion.getApkPath(), 3600 * 24 * 7L));
        }
        if (StrUtil.isNotBlank(lastVersion.getRemark())){
            String[] split = lastVersion.getRemark().split("##");
            lastVersion.setRemarks(Arrays.asList(split));
        }
        return ObjectResponse.success(lastVersion);
    }
}
