package com.icetech.basics.dao.park;

import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RegionChargeconfigDao extends SuperMapper<RegionChargeconfig> {

    /**
     * 查询区域的所有计费规则
     * @param parkId
     * @return
     */
    List<RegionChargeconfig> selectByParkId(Long parkId);

    /**
     *
     * @param parkId
     * @param regionId
     * @param plateType
     * @return
     */
    RegionChargeconfig getRegionChargeconfig(@Param("parkId") Long parkId, @Param("regionId") Long regionId, @Param("plateType") Integer plateType);

    /**
     * 根据计费规则编码
     * 修改区域计费规则状态
     * @param regionChargeconfig
     * @return
     */
    int modifyRegionChargeConfigStatus(RegionChargeconfig regionChargeconfig);

    /**
     * 删除区域计费规则
     * @param billtypecode
     * @return
     */
    int delRegionChargeConfig(@Param("billtypecode")String billtypecode);
}
