package com.icetech.basics.dao.park;

import java.util.Collection;
import java.util.List;

import javax.annotation.Nullable;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.domain.dto.ParkRegionDto;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ParkRegionDao extends SuperMapper<ParkRegion> {
    default List<ParkRegion> selectByParkid(Long parkId) {
        return selectList(Wrappers.lambdaQuery(ParkRegion.class)
                .eq(ParkRegion::getParkId, parkId)
                .eq(ParkRegion::getStatus, 0));
    }

    /**
     * 通过车场ID查询外区域
     *
     * @param parkId
     * @return
     */
    default ParkRegion selectOutByParkid(Long parkId) {
        return selectLimitOne(Wrappers.lambdaQuery(ParkRegion.class)
                .eq(ParkRegion::getParkId, parkId)
                .eq(ParkRegion::getFatherRelationId, 0)
                .eq(ParkRegion::getStatus, 0));
    }

    default ParkRegion getRegionByCode(@Nullable Long parkId, String regionCode) {
        return selectLimitOne(Wrappers.lambdaQuery(ParkRegion.class)
                .eq(parkId != null, ParkRegion::getParkId, parkId)
                .eq(ParkRegion::getRegionCode, regionCode));
    }

    /**
     * 根据在场订单更新空车位数量
     *
     * @param regionId
     * @return
     */
    int updateFreeParkById(@Param("regionId") long regionId);

    int updateFreeParkByIds(@Param("regionIds") Collection<Long> regionId);

    int addFreeSpaceByPark(@Param("regionId") long regionId, @Param("num") int num);

    /**
     * 更新空车位：根据车场ID更新空车位
     *
     * @param regionIds 区域ID
     * @return 影响行数
     */
    int updateFreeSpaceByRegions(@Param("regionIds") Collection<Long> regionIds);

    /**
     * 查询月卡对应的区域名称
     *
     * @param productIds 月卡ID
     * @return 区域信息
     */
    List<ParkRegionDto> getParkRegionListByProductId(@Param("productIds") List<Long> productIds);
}
