package com.icetech.basics.dao.park;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.park.ParkChannelInfo;
import com.icetech.cloudcenter.domain.park.ParkInOutDeviceDto;
import com.icetech.cloudcenter.domain.park.ParkInoutDeviceInfo;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.annotations.Param;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface ParkInoutdeviceDao extends SuperMapper<ParkInoutdevice> {
    default List<ParkInoutdevice> selectByIds(List<Long> ids) {
        return selectList(Wrappers.lambdaQuery(ParkInoutdevice.class)
                .in(ParkInoutdevice::getId, ids)
                .eq(ParkInoutdevice::getStatus, 0));
    }

    default ParkInoutdevice selectByCode(@Nullable Long parkId, String inandoutCode) {
        return selectLimitOne(Wrappers.lambdaQuery(ParkInoutdevice.class)
                .eq(parkId != null, ParkInoutdevice::getParkId, parkId)
                .eq(ParkInoutdevice::getInandoutCode, inandoutCode)
                .eq(ParkInoutdevice::getStatus, 0)
                .orderByAsc(ParkInoutdevice::getId));
    }

    /**
     * 获取出入口信息
     *
     * @param parkId
     * @return
     */
    default List<ParkInoutdevice> selectByParkId(Long parkId) {
        return selectList(Wrappers.lambdaQuery(ParkInoutdevice.class)
                .eq(ParkInoutdevice::getParkId, parkId)
                .eq(ParkInoutdevice::getStatus, 0)
                .orderByAsc(ParkInoutdevice::getCreateTime));
    }

    List<ParkChannelInfo> selectByParkCode(@Param("parkCodeList") List<String> parkCodeList);

    List<ParkInoutDeviceInfo> selectChannelInfoByParkCode(@Param("parkCode") String parkCode);

    List<ParkChannelInfo> selectParkChannelInfoByParkId(@Param("parkIdList") List<Integer> parkIdList);

    List<ParkInoutDeviceInfo> selectChannelInfoByParkId(@Param("parkId") Integer parkId);

    /**
     * 查询通道信息
     *
     * @param parkCode
     * @param channelCode
     * @return
     */
    ParkInoutdevice selectChannelInfo(@Param("parkCode") String parkCode, @Param("channelCode") String channelCode);

    /**
     * 获取出入口信息
     *
     * @param parkId
     * @param type
     * @return
     */
    default List<ParkInoutdevice> selectByParkIdAndType(Long parkId, Integer type) {
        return selectList(Wrappers.lambdaQuery(ParkInoutdevice.class)
                .eq(ParkInoutdevice::getParkId, parkId)
                .eq(type != null, ParkInoutdevice::getInandoutType, type)
                .eq(ParkInoutdevice::getStatus, 0)
                .orderByAsc(ParkInoutdevice::getCreateTime));
    }

    /**
     * 获取通道名称
     */
    default String selectChannelName(Integer id) {
        return selectOneColumn(ParkInoutdevice::getInandoutName, Wrappers.lambdaQuery(ParkInoutdevice.class).eq(ParkInoutdevice::getId, id));
    }

    /**
     *
     * @param parkId
     * @param serialNumber
     * @return
     */
    ParkInoutdevice selectBySerialNumber(@Param("parkId") Long parkId, @Param("serialNumber") String serialNumber);

    default int updateTempcarrun(Long parkId, Integer type, Integer isAllowTempcarrun) {
        ParkInoutdevice update = new ParkInoutdevice();
        update.setIsAllowTempcarrun(isAllowTempcarrun);
        return update(update, Wrappers.lambdaQuery(ParkInoutdevice.class)
                .eq(ParkInoutdevice::getParkId, parkId)
                .eq(ParkInoutdevice::getInandoutType, type));
    }

    /**
     * 数据参数更新
     * @param parkInoutdevice
     * @return
     */
    default int updateByCode(ParkInoutdevice parkInoutdevice) {
        parkInoutdevice.setId(null);
        return update(parkInoutdevice, Wrappers.lambdaQuery(ParkInoutdevice.class)
                .eq(ParkInoutdevice::getParkId, parkInoutdevice.getParkId())
                .eq(ParkInoutdevice::getInandoutCode, parkInoutdevice.getInandoutCode()));
    }

    /**
     * 删除通道权限规则
     *
     * @param parkInoutdevice
     * @return
     */
    default int delInoutDeviceConfig(ParkInoutdevice parkInoutdevice) {
        ParkInoutdevice update = new ParkInoutdevice();
        update.setStatus(parkInoutdevice.getStatus());
        return update(update, Wrappers.lambdaQuery(ParkInoutdevice.class)
                .eq(ParkInoutdevice::getParkId, parkInoutdevice.getParkId())
                .eq(ParkInoutdevice::getInandoutCode, parkInoutdevice.getInandoutCode()));
    }

    default ParkInoutdevice checkChannelNameByParkId(Long parkId, String inandoutName) {
        return selectLimitOne(Wrappers.lambdaQuery(ParkInoutdevice.class)
                .eq(parkId != null, ParkInoutdevice::getParkId, parkId)
                .eq(ParkInoutdevice::getInandoutName, inandoutName)
                .eq(ParkInoutdevice::getStatus, 0));
    }

    /**
     * 获取车场下的所有通道信息
     *
     * @param parkIds
     * @return
     */
    List<ParkInOutDeviceDto> getChannelList(@Param("parkIds") List<Long> parkIds);

    default List<ParkInoutdevice> findByRegionId(Long regionId, @Nullable Integer inandoutType) {
        return selectList(Wrappers.lambdaQuery(ParkInoutdevice.class)
                .eq(ParkInoutdevice::getRegionId, regionId)
                .eq(inandoutType != null, ParkInoutdevice::getInandoutType, inandoutType)
                .last("limit 10"));
    }

    default Set<String> getOutChannelList(Set<String> channelCodes) {
        List<ParkInoutdevice> channels = selectList(Wrappers.lambdaQuery(ParkInoutdevice.class).in(ParkInoutdevice::getInandoutCode, channelCodes)
                .eq(ParkInoutdevice::getInandoutType, 2)
                .eq(ParkInoutdevice::getStatus, 0));
        if(CollectionUtils.isEmpty(channels)) {
            return Collections.emptySet();
        }
        return channels.stream()
                .map(ParkInoutdevice::getInandoutCode)
                .filter(Objects::nonNull)
                .collect(Collectors.toSet());
    }
}
