package com.icetech.basics.dao.park;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.cloudcenter.domain.park.query.ParkVisitInfo;
import com.icetech.park.domain.entity.park.InitBstPark;
import com.icetech.park.domain.entity.park.ParkMessage;
import com.icetech.cloudcenter.domain.park.ParkInfo;
import com.icetech.cloudcenter.domain.park.ParkList;
import com.icetech.cloudcenter.domain.park.query.ParkDistanceInfo;
import com.icetech.cloudcenter.domain.park.query.ParkDistanceParam;
import com.icetech.cloudcenter.domain.park.query.ParkSpaceInfo;
import com.icetech.cloudcenter.domain.park.query.ParkQuery;
import com.icetech.cloudcenter.domain.response.MonthProductDto;
import com.icetech.cloudcenter.domain.response.OrganizationTreeDto;
import com.icetech.cloudcenter.domain.response.ParkAreaDetailDto;
import com.icetech.cloudcenter.domain.response.ParkPlotsDto;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface ParkDao extends SuperMapper<BasePark> {

    /**
     * 查询所有车场
     *
     * @return
     */
    List<Park> findAll();
    /**
     * 查询所有机构
     *
     * @return
     */
    List<OrganizationTreeDto> selectAllOrganiz();

    /**
     * 根据车场名称模糊查询
     *
     * @param name
     * @return
     */
    List<Park> selectByName(@Param("name") String name);

    /**
     * 当前用户机构--机构树
     *
     * @param orgids
     * @return
     */
    List<OrganizationTreeDto> selectOrganizDetails(@Param("orgids") String orgids);

    /**
     * 当前用户车场--机构树
     *
     * @param parkids
     * @return
     */
    List<OrganizationTreeDto> selectParksDetails(@Param("parkids") String parkids);

    /**
     * 查询用户分配的机构和车场
     *
     * @param userid
     * @param type   1管理机构 2管理车场
     * @return
     */
    String selectParkOrgByUserId(@Param("userId") Integer userid, @Param("type") Integer type);

    Park selectParkById(Long parkId);

    Park selectParkByName(@Param("parkName") String parkName);

    List<Park> selectByIds(@Param("parkIds") String parkIds);

    List<Park> selectByIdsAndParkCode(@Param("parkIds") String parkIds,@Param("parkCode") String parkCode);

    Park selectByCode(String parkCode);

    Long selectIdByCode(String parkCode);

    String selectByCodes(String[] parkcode);

    /**
     * 统计停车场总数和车位个数
     *
     * @param parkIdList 所有车场用"all"表示
     * @return
     */
    ParkPlotsDto countParkPlots(String parkIdList);

    /**
     * 按区域省份统计停车场总数和车位个数
     *
     * @param parkIdList 所有车场用"all"表示
     * @return
     */
    List<ParkAreaDetailDto> countParkPlotsByArea(String parkIdList);

    /**
     * 查询车场列表
     * @param parkIds
     * @return
     */
    List<Park> selectByParkIdsAndParkName(@Param("parkIds") List<Long> parkIds, @Param("parkNameKey") String parkNameKey);

    /**
     * 查询车场列表 限制100条
     * @param parkIds
     * @param parkNameKey
     * @return
     */
    List<Park> selectByParkIdsAndParkNameLimit(@Param("parkIds") List<Long> parkIds, @Param("parkNameKey") String parkNameKey);

    /**
     * 获取机构所管辖的车场
     *
     * @param institutionIds
     * @return
     */
    List<Park> selectByInstitutionIds(@Param("institutionIds") List institutionIds);

    /**
     * 获取机构所管辖的车场
     *
     * @param institutionIds
     * @return
     */
    List<Park> selectByInstitutionIdsAndName(@Param("institutionIds") List institutionIds, @Param("parkName") String parkName);

    /**
     * 获取父机构下的所有子机构的id
     *
     * @param institutionId
     * @return
     */
    String selectInstitutionIdsByPid(@Param("institutionId") Integer institutionId);

    /**
     * 根据类型查询车场列表
     *
     * @param type
     * @return
     */
    List<Park> selectListByType(Integer type);

    /**
     * 获取所有的车场id
     *
     * @return
     */
    List<Long> selectAllParkIds();

    /**
     * 通过pid获取车场列表信息
     *
     * @param pid
     * @return
     */
    List<ParkList> selectByParkInfoThirdPID(String pid);

    Integer saveParkInfo(@Param("park") ParkInfo parkInfo);

    Integer updateParkInfo(ParkInfo parkInfo);

    Integer selectParkCountByParkCodeAndName(@Param("parkCode") String parkCode, @Param("parkName") String parkName);

    ParkInfo selectParkInfoByParkCode(String parkCode);

    /**
     * 按名字查找机构信息
     *
     * @param institutionName
     * @return
     */
    OrganizationTreeDto selectOrganizDetailsByName(@Param("institutionName") String institutionName);

    int updateParkInstitutionId(@Param("institutionId") Integer institutionId, @Param("parkId") Long parkId);

    /**
     * 车场位置搜索-车位租赁
     * @param parkQuery
     * @return
     */
    List<ParkSpaceInfo> getParkSpaceList(ParkQuery parkQuery);

    /**
     * 车场位置搜索-访客预约
     * @param parkQuery
     * @return
     */
    List<ParkVisitInfo> getParkVisitList(ParkQuery parkQuery);

    List<ParkDistanceInfo> getParkDistance(ParkDistanceParam param);

    /**
     * 获取月卡产品信息
     * @param parkId
     * @param cardType
     * @return
     */
    List<MonthProductDto> getMonthProduct(@Param("parkId") Long parkId,@Param("parkIds") List<Long> parkIds,@Param("cardTyp") Integer cardType);

    List<Park> selectLikeParkName(@Param("cityId")Integer cityId, @Param("key")String key);

    List<ParkMessage> findAllBy();

    Page<Park> selectParkPage(Page<Park> page, @Param("parkName")String parkName, @Param("cityId") Integer cityId);

    List<InitBstPark> selectBstInitPark();

    /**
     * 通过车场id获取车场列表
     *
     * @param parkIds
     * @return
     */
    List<Park> selectByParkIds(@Param("parkIds") List<Long> parkIds);

    List<ParkSpaceInfo> getParkList(ParkQuery parkQuery);
}
