package com.icetech.basics.dao.dictionary;

import com.icetech.basics.domain.entity.dictionary.DictionaryItem;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface DictionaryItemDao {
    /**
     * 新增
     */
    int insert(@Param("dictionaryItem") DictionaryItem dictionaryItem);

    /**
     * 删除
     */
    int delete(@Param("id") int id);

    /**
     * 更新
     */
    int update(@Param("dictionaryItem") DictionaryItem dictionaryItem);

    /**
     * Load查询
     */
    DictionaryItem load(@Param("id") int id);

    /**
     * 获取字典项目列表
     *
     * @param typeId
     * @return
     */
    List<DictionaryItem> selectByDictionaryType(Integer typeId);

    DictionaryItem selectOneItem(@Param("typeId") Integer typeId, @Param("text") String text, @Param("value") Integer value);

    DictionaryItem selectByDictionaryByTypeAndValue(@Param("typeId") Integer typeId, @Param("value") Integer value);

}
