package com.icetech.basics.dao.charge;

import com.icetech.basics.domain.entity.charge.ChargeNaturalday;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

/**
 * <p>
 * 通用自然天配置 Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2019-04-24
 */
public interface ChargeNaturaldayDao extends SuperMapper<ChargeNaturalday> {

    /**
     * 根据车场ID查询计费规则
     * @param parkId
     * @return
     */
    ChargeNaturalday selectByParkId(Long parkId);
    /**
     * 根据编号查询
     * @param billCode
     * @return
     */
    ChargeNaturalday selectByCode(String billCode);

    int modifyChargeNaturalDayRuleState(ChargeNaturalday chargeNaturalday);
}
