package com.icetech.basics.dao.blacklist;

import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * @author wanggy
 */
@Repository
public interface BlacklistDao extends SuperMapper<Blacklist> {

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    Blacklist load(Long id);

    /**
     * 根据车牌号和车场id查询有效的黑名单
     *
     * @param parkId
     * @param plateNum
     * @return
     */
    Blacklist selectValidByPlate(@Param("parkId") Long parkId, @Param("plateNum") String plateNum);

    /**
     * 查询车场所有有效黑名单
     *
     * @param parkId
     * @return
     */
    List<Blacklist> selectValidByParkId(Long parkId);

    /**
     * 新增
     *
     * @param black
     * @return
     */
    int insert(Blacklist black);

    /**
     * 更新
     *
     * @param black
     * @return
     */
    int updateBlack(Blacklist black);

    List<Blacklist> selectValidByIds(@Param("ids") List<String> ids);

    /**
     * 根据 id 查询黑名单
     * @param ids   id 参数
     * @return
     */
    List<Blacklist> selectByIds(@Param("ids") List<Long> ids);

    Blacklist selectByParkIdAndThirdId(@Param("parkId") Long parkId, @Param("thirdBlackId") Long thirdBlackId);

    /**
     *
     * @param parkId
     * @param createTime
     * @return
     */
    List<Blacklist> selectValidByParkIdAndCreateTime(@Param("parkId") Long parkId, @Param("createTime") Date createTime);
}
