package com.icetech.basics.dao.area;

import com.icetech.basics.domain.entity.AreaCity;
import com.icetech.db.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 城市表 Mapper 接口
 * </p>
 *
 * @author wangzw
 * @since 2018-11-20
 */
public interface AreaCityDao extends BaseDao<AreaCity> {
    /**
     * 根据id查询
     * @param id
     * @return
     */
    AreaCity selectByPk(Integer id);
    List<AreaCity> selectAllData();
    List<AreaCity> selectByUpperId(Integer id);

    AreaCity selectByCode(@Param("code") String code);

    /**
     * 根据城市名称查询城市信息
     *
     * @param name 城市名称
     * @return
     */
    AreaCity selectCityByName(@Param("name") String name);
}
