package com.icetech.basics.config;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import com.icetech.common.properties.ThreadPoolProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

@Configuration
public class ThreadPoolConfig {
    @Bean(destroyMethod = "shutdown")
    public ScheduledThreadPoolExecutor asyncMethodScheduler(
            @Value("${ice.thread.async-method-scheduler.size:4}") int poolSize) {
        return new ScheduledThreadPoolExecutor(poolSize,
                new CustomizableThreadFactory("async-method-scheduler-"));
    }

    @Bean(destroyMethod = "shutdown")
    public ThreadPoolExecutor asyncExecutor() {
        ThreadPoolProperties properties = asyncExecutorProperties();
        return new ThreadPoolExecutor(properties.getCorePoolSize(), properties.getMaximumPoolSize(),
                properties.getKeepAliveTimeSeconds(), TimeUnit.SECONDS,
                new LinkedBlockingQueue<>(properties.getCapacitySize()),
                new CustomizableThreadFactory("async-executor-"));
    }

    @Bean
    @ConfigurationProperties(prefix = "ice.thread.async-executor")
    public ThreadPoolProperties asyncExecutorProperties() {
        ThreadPoolProperties properties = new ThreadPoolProperties();
        properties.setCapacitySize(Integer.MAX_VALUE);
        return properties;
    }

    @Bean(destroyMethod = "shutdown")
    public ThreadPoolExecutor asyncMethodExecutor() {
        ThreadPoolProperties properties = asyncMethodExecutorProperties();
        return new ThreadPoolExecutor(properties.getCorePoolSize(), properties.getMaximumPoolSize(),
                properties.getKeepAliveTimeSeconds(), TimeUnit.SECONDS,
                new LinkedBlockingQueue<>(properties.getCapacitySize()),
                new CustomizableThreadFactory("async-method-"));
    }

    @Bean
    @ConfigurationProperties(prefix = "ice.thread.async-method")
    public ThreadPoolProperties asyncMethodExecutorProperties() {
        ThreadPoolProperties properties = new ThreadPoolProperties();
        properties.setCapacitySize(Integer.MAX_VALUE);
        return properties;
    }
}
