/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.freespace;

import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.service.freespace.UpdateFreeSpaceService;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="updateParkFreeSpaceService")
public class UpdateParkFreeSpaceServiceImpl
implements UpdateFreeSpaceService {
    private static final Logger log = LoggerFactory.getLogger(UpdateParkFreeSpaceServiceImpl.class);
    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;

    @Override
    public int resetFreeSpace(Long parkId) {
        int i = this.parkFreespaceDao.syncFreeSpaceByPark(parkId);
        if (i > 0) {
            this.syncOutRegionFreeSpace(parkId);
        }
        return i;
    }

    @Override
    public int updateFreeSpace(Long parkId, Long regionId, int freeSpace) {
        int i = this.parkFreespaceDao.updateFreeSpaceByPark(parkId, freeSpace);
        if (i > 0) {
            this.syncOutRegionFreeSpace(parkId);
        }
        return i;
    }

    @Override
    public int addFreeSpace(Long parkId, Long regionId, int num) {
        int i = this.parkFreespaceDao.addFreeSpaceByPark(parkId, num);
        if (i > 0) {
            this.syncOutRegionFreeSpace(parkId);
        }
        return i;
    }

    @Override
    public int syncFreeSpace(Long parkId, Long regionId) {
        int i = this.parkFreespaceDao.syncFreeSpaceByPark(parkId);
        if (i > 0) {
            this.syncOutRegionFreeSpace(parkId);
        }
        return i;
    }

    @Override
    public int syncFreeSpaceByParks(Collection<Long> parkIds) {
        int i = this.parkFreespaceDao.syncFreeSpaceByParks(parkIds);
        if (i > 0) {
            this.syncOutRegionFreeSpace(parkIds);
        }
        return i;
    }

    private void syncOutRegionFreeSpace(Long parkId) {
        ParkRegion parkRegion = this.parkRegionDao.selectOutByParkid(parkId);
        if (parkRegion != null) {
            this.parkRegionDao.updateFreeSpaceByRegions(Collections.singleton(parkRegion.getId()));
        }
    }

    private void syncOutRegionFreeSpace(Collection<Long> parkIds) {
        for (Long parkId : parkIds) {
            ParkRegion parkRegion = this.parkRegionDao.selectOutByParkid(parkId);
            if (parkRegion == null) continue;
            this.parkRegionDao.updateFreeSpaceByRegions(Collections.singleton(parkRegion.getId()));
        }
    }
}

