/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.basics.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class FuzzyPlateTools {
    public static List<String> fuzzyCharacter(String plateNum, int plot) {
        if (plot > 2 || plot < 0) {
            return new ArrayList<String>();
        }
        List<String> list = new LinkedList<String>();
        if (plot + 1 >= plateNum.length()) {
            list.add(plateNum);
            return list;
        }
        String plateNumPart = plateNum.substring(1);
        if (plot == 0) {
            list.add("_" + plateNumPart);
            return list;
        }
        int length = plateNumPart.length();
        String prefix = "_";
        String separator = plot == 1 ? "_" : "__";
        for (int k = 0; k < length - plot + 1; ++k) {
            int plot2 = plot + k;
            for (int i = k; i < length; i += plot) {
                if (i == 0) {
                    String replace = separator + plateNumPart.substring(i + plot2, length);
                    list.add(prefix + replace);
                    continue;
                }
                if (length - i < plot) continue;
                int suffixIndex = i + plot;
                String replace = plateNumPart.substring(0, i) + separator + (suffixIndex >= length ? "" : plateNumPart.substring(i + plot, length));
                list.add(replace.startsWith(separator) ? replace : prefix + replace);
            }
        }
        if (plot == 1) {
            list.add(prefix + plateNumPart.substring(0, plateNumPart.length() - 1));
        }
        list = list.stream().distinct().collect(Collectors.toList());
        return list;
    }

    public static void main(String[] args) {
        System.out.println("\u5b81A16E155" + FuzzyPlateTools.fuzzyCharacter("\u5b81A16E155", 4));
        System.out.println("\u5b81A16E15" + FuzzyPlateTools.fuzzyCharacter("\u5b81A16E15", 3));
        System.out.println("\u82cfE6D686" + FuzzyPlateTools.fuzzyCharacter("\u82cfE6D686", 2));
        System.out.println("\u82cfBDM5030" + FuzzyPlateTools.fuzzyCharacter("\u82cfBDM5030", 1));
    }
}

