/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.basics.service.park.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.icetech.basics.config.GrayProperties;
import com.icetech.basics.dao.area.AreaCityDao;
import com.icetech.basics.dao.area.AreaDistrictDao;
import com.icetech.basics.dao.charge.ChargeDyrationDao;
import com.icetech.basics.dao.charge.ChargeNaturaldayDao;
import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.dao.dictionary.DictionaryItemDao;
import com.icetech.basics.dao.park.OpeningDao;
import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.dao.park.RegionChargeconfigDao;
import com.icetech.basics.domain.dto.ChargeConfigDTO;
import com.icetech.basics.domain.dto.DictionaryItemDto;
import com.icetech.basics.domain.entity.AreaCity;
import com.icetech.basics.domain.entity.AreaDistrict;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.basics.domain.entity.charge.Charge24charge;
import com.icetech.basics.domain.entity.charge.ChargeDaynight;
import com.icetech.basics.domain.entity.charge.ChargeDuration;
import com.icetech.basics.domain.entity.charge.ChargeNaturalday;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.dictionary.DictionaryItem;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.domain.entity.park.Opening;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.park.IParkTrusteeshipService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.SaasUserParkService;
import com.icetech.cloudcenter.api.third.ThirdParkService;
import com.icetech.cloudcenter.domain.charge.detail.Charge24HourDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeDayNightDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeNaturalDayDetail;
import com.icetech.cloudcenter.domain.charge.dto.ChargeRuleCfgDTO;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.park.ChangPingParkUser;
import com.icetech.cloudcenter.domain.park.ParkAllInfo;
import com.icetech.cloudcenter.domain.park.ParkConfigInfo;
import com.icetech.cloudcenter.domain.park.ParkInfo;
import com.icetech.cloudcenter.domain.park.ParkList;
import com.icetech.cloudcenter.domain.park.ParkListGroup;
import com.icetech.cloudcenter.domain.park.query.ParkDistanceInfo;
import com.icetech.cloudcenter.domain.park.query.ParkDistanceParam;
import com.icetech.cloudcenter.domain.park.query.ParkQuery;
import com.icetech.cloudcenter.domain.park.query.ParkSpaceInfo;
import com.icetech.cloudcenter.domain.park.query.ParkVisitInfo;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.response.AisleDto;
import com.icetech.cloudcenter.domain.response.MonthProductDto;
import com.icetech.cloudcenter.domain.response.OrganizationTreeDto;
import com.icetech.cloudcenter.domain.response.ParkAreaDetailDto;
import com.icetech.cloudcenter.domain.response.ParkDto;
import com.icetech.cloudcenter.domain.response.ParkPlotsDto;
import com.icetech.cloudcenter.domain.response.PassWayDto;
import com.icetech.cloudcenter.domain.vo.ParkChargeRuleVO;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.SpringUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.domain.entity.ParkTrusteeship;
import com.icetech.park.domain.entity.park.InitBstPark;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.domain.entity.park.ParkMessage;
import com.icetech.park.service.factory.UpdateFreeSpaceServiceFactory;
import com.icetech.park.service.freespace.UpdateFreeSpaceService;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.domain.entity.third.ThirdPark;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.service.third.SendInfoServiceImpl;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.user.dao.UserDefultAisleDao;
import com.icetech.user.domain.entity.user.SaasUserPark;
import com.icetech.user.domain.entity.user.UserDefultAisle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service(value="parkService")
public class ParkServiceImpl
extends BaseServiceImpl<ParkDao, BasePark>
implements ParkService {
    private static final Logger log = LoggerFactory.getLogger(ParkServiceImpl.class);
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private ParkConfigDao parkConfigDao;
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private SaasUserParkService saasUserParkService;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private ChargeDyrationDao chargeDyrationDao;
    @Autowired
    private ChargeNaturaldayDao chargeNaturaldayDao;
    @Autowired
    private RegionChargeconfigDao regionChargeconfigDao;
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private OpeningDao openingDao;
    @Autowired
    private DictionaryItemDao dictionaryItemDao;
    @Autowired
    private UserDefultAisleDao userDefultAisleDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private MqPushService mqPushService;
    @Resource
    private RedisHandle redisHandle;
    @Autowired
    private ThirdParkService thirdParkService;
    @Autowired
    private AreaCityDao areaCityDao;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private GrayProperties grayProperties;
    @Autowired
    private ParkFreeSpaceService parkFreeSpaceService;
    @Autowired
    private UpdateFreeSpaceServiceFactory updateFreeSpaceServiceFactory;
    @Autowired
    private ParkService parkService;
    @Value(value="${mor.videoUrl:default}")
    private String morVideoUrl;
    private static final Long HIGHEST_INST = 1L;
    @Autowired
    private AreaDistrictDao areaDistrictDao;
    @Resource
    private ChargeService chargeService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    public static final String STATISTICS_TIME = "statistics:parkspace:";
    public static final String STATISTICS_TIME_VISIT = "statistics:visit:";

    public ObjectResponse<List<ParkRegion>> selectRegionById(Long parkId) {
        List<ParkRegion> parkRegions = this.parkRegionDao.selectByParkid(parkId);
        return ObjectResponse.success(parkRegions);
    }

    public ObjectResponse<ParkRegion> getParkRegionById(Long id) {
        ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById(id);
        if (parkRegion != null) {
            return ObjectResponse.success((Object)parkRegion);
        }
        return ObjectResponse.failed((String)"404");
    }

    public List<ParkMessage> findAllBy() {
        return this.parkDao.findAllBy();
    }

    public List<Park> fidAll() {
        return this.parkDao.findAll();
    }

    public ObjectResponse modifyUserDefultAisle(String aisleCode, Integer userId) {
        int update;
        UserDefultAisle userDefultAisle = this.userDefultAisleDao.selectByUserId(userId.intValue());
        if (Objects.isNull(userDefultAisle)) {
            UserDefultAisle userDefultAisle1 = new UserDefultAisle();
            userDefultAisle1.setAisleCode(aisleCode);
            userDefultAisle1.setUserId(userId);
            userDefultAisle1.setCreateTime(new Date());
            update = this.userDefultAisleDao.insert(userDefultAisle1);
        } else {
            userDefultAisle.setAisleCode(aisleCode);
            userDefultAisle.setUpdateTime(new Date());
            update = this.userDefultAisleDao.update(userDefultAisle);
        }
        if (update > 0) {
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)"500");
    }

    public ObjectResponse<List<PassWayDto>> getUserDefultAisle(Integer userId) {
        String aisleCode;
        UserDefultAisle userDefultAisle = this.userDefultAisleDao.selectByUserId(userId.intValue());
        ArrayList<ParkInoutdevice> parkInoutdevices = new ArrayList<ParkInoutdevice>();
        if (!Objects.isNull(userDefultAisle) && StringUtil.isNotEmpty((String)(aisleCode = userDefultAisle.getAisleCode()))) {
            String[] split;
            for (String s : split = aisleCode.split(",")) {
                ParkInoutdevice parkInoutdevice = (ParkInoutdevice)this.getInoutDeviceByCode(s).getData();
                parkInoutdevices.add(parkInoutdevice);
            }
            if (!parkInoutdevices.isEmpty()) {
                return ObjectResponse.success(this.setResponse(parkInoutdevices));
            }
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<PassWayDto> findWayDetailByvid(String vid) {
        PassWayDto p = new PassWayDto();
        List<ParkDevice> parkDevices1 = this.parkDeviceDao.selectWayDetailByvid(vid);
        if (parkDevices1.size() > 0) {
            ParkDevice parkDevice = parkDevices1.get(0);
            Park park = (Park)this.findByParkId(parkDevice.getParkId()).getData();
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)this.getInoutDeviceById((long)parkDevice.getChannelId()).getData();
            p.setAisleCode(parkInoutdevice.getInandoutCode());
            p.setParkCode(park.getParkCode());
            p.setType(parkInoutdevice.getInandoutType());
            p.setAisleName(parkInoutdevice.getInandoutName());
            p.setParkName(park.getParkName());
            ArrayList<Integer> status = new ArrayList<Integer>();
            status.add(1);
            ArrayList<Integer> deviceType = new ArrayList<Integer>();
            deviceType.add(6);
            ArrayList<String> inandoutCode = new ArrayList<String>();
            inandoutCode.add(parkInoutdevice.getInandoutCode());
            List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceList(parkInoutdevice.getParkId(), inandoutCode, status, deviceType);
            if (parkDevices.size() > 0) {
                p.setVideoUrl(parkDevices.get(0).getVideoUrl());
            } else {
                ParkDevice morDevice = this.parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(), 9, null);
                if (morDevice != null) {
                    p.setIceMorSn(morDevice.getSerialNumber());
                    p.setIceMorVideoUrl(String.format(this.morVideoUrl, parkDevice.getSerialNumber()));
                }
            }
            this.setParkTrusteeshipStatus(p, parkInoutdevice);
        }
        return ObjectResponse.success((Object)p);
    }

    private void setParkTrusteeshipStatus(PassWayDto p, ParkInoutdevice parkInoutdevice) {
        ParkTrusteeship parkTrusteeship = (ParkTrusteeship)((IParkTrusteeshipService)SpringUtils.getBean(IParkTrusteeshipService.class)).getParkTrusteeshipByParkId(parkInoutdevice.getParkId()).getData();
        if (Objects.nonNull(parkTrusteeship)) {
            Date currentDate = new Date();
            p.setTrusteeshipStatus(Integer.valueOf(DateUtil.compare((Date)currentDate, (Date)parkTrusteeship.getStartTime()) < 0 ? 1 : (DateUtil.compare((Date)currentDate, (Date)parkTrusteeship.getStartTime()) > 0 && DateUtil.compare((Date)currentDate, (Date)parkTrusteeship.getEndTime()) < 0 ? 2 : 3)));
            p.setTrusteeshipEndTime(parkTrusteeship.getEndTime());
        } else {
            p.setTrusteeshipStatus(Integer.valueOf(0));
        }
    }

    public ObjectResponse<List<ParkDto>> selectParkByname(String name) {
        ArrayList<ParkDto> rlist = new ArrayList<ParkDto>();
        List<Park> parks = this.parkDao.selectByName(name);
        for (int i = 0; i < parks.size(); ++i) {
            ParkDto p = new ParkDto();
            Park park = parks.get(i);
            p.setId(park.getId());
            p.setParkCode(park.getParkCode());
            p.setParkName(park.getParkName());
            rlist.add(p);
        }
        return ObjectResponse.success(rlist);
    }

    private List<PassWayDto> setResponse(List<ParkInoutdevice> parkInoutdevices) {
        ArrayList<PassWayDto> rlist = new ArrayList<PassWayDto>();
        for (int i = 0; i < parkInoutdevices.size(); ++i) {
            ParkInoutdevice parkInoutdevice = parkInoutdevices.get(i);
            PassWayDto p = new PassWayDto();
            if (parkInoutdevice == null) continue;
            Park park = (Park)this.findByParkId(parkInoutdevice.getParkId()).getData();
            p.setId(parkInoutdevice.getId());
            p.setParkCode(park.getParkCode());
            p.setParkName(park.getParkName());
            p.setType(parkInoutdevice.getInandoutType());
            p.setAisleCode(parkInoutdevice.getInandoutCode());
            p.setAisleName(parkInoutdevice.getInandoutName());
            ArrayList<Integer> status = new ArrayList<Integer>();
            status.add(1);
            status.add(2);
            ArrayList<Integer> deviceType = new ArrayList<Integer>();
            deviceType.add(4);
            deviceType.add(6);
            deviceType.add(1);
            deviceType.add(9);
            ArrayList<String> inandoutCode = new ArrayList<String>();
            inandoutCode.add(parkInoutdevice.getInandoutCode());
            ArrayList<Integer> deviceFail = new ArrayList<Integer>();
            this.setParkTrusteeshipStatus(p, parkInoutdevice);
            List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceList(parkInoutdevice.getParkId(), inandoutCode, status, deviceType);
            for (int j = 0; j < parkDevices.size(); ++j) {
                ParkDevice parkDevice = parkDevices.get(j);
                if (parkDevice.getType() == 1) {
                    p.setStatus(parkDevice.getStatus());
                    p.setIp(parkDevice.getIp());
                    p.setPort(parkDevice.getPort());
                }
                if (parkDevice.getType() == 4 && Objects.nonNull(parkDevice.getVoicevendorType()) && parkDevice.getVoicevendorType() == 2) {
                    p.setVoiceDeviceId(parkDevice.getSerialNumber());
                }
                if (parkDevice.getType() == 4 && Objects.nonNull(parkDevice.getVoicevendorType()) && parkDevice.getVoicevendorType() == 1) {
                    p.setYuneasyNumber(parkDevice.getSerialNumber());
                }
                if (parkDevice.getType() == 6) {
                    p.setVStatus(parkDevice.getStatus());
                    p.setVideoUrl(parkDevice.getVideoUrl());
                    String redisKey = "ysy:token:" + parkInoutdevice.getParkId() + ":" + parkDevice.getDeviceNo();
                    String accessToken = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
                    log.info("setResponse  >  {}", (Object)accessToken);
                    if (TextUtils.isEmpty((CharSequence)accessToken)) {
                        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.parkDeviceService.updateConsoleTokenForRedis(parkDevice)));
                    }
                }
                if (parkDevice.getType() == 9) {
                    p.setIceMorSn(parkDevice.getSerialNumber());
                    p.setIceMorVideoUrl(String.format(this.morVideoUrl, parkDevice.getSerialNumber()));
                }
                if (!ObjectUtils.isEmpty((Object)parkDevice.getStatus()) && parkDevice.getStatus() == 1) continue;
                deviceFail.add(parkDevice.getType());
            }
            p.setStatusFail(deviceFail);
            rlist.add(p);
        }
        return rlist;
    }

    public ObjectResponse<List<PassWayDto>> getPassageWayInfo(int id, int type, Integer userId) {
        List<ParkInoutdevice> parkInoutdevices = new ArrayList<ParkInoutdevice>();
        String parkids = this.parkDao.selectParkOrgByUserId(userId, 2);
        if (StringUtils.isBlank((CharSequence)parkids)) {
            return ObjectResponse.failed((String)"404", (String)"\u5f53\u524d\u7528\u6237\u4e0b\u65e0\u8f66\u573a\u6743\u9650");
        }
        String[] userpark = parkids.split(",");
        if (type == 1) {
            String integers = this.parkDao.selectInstitutionIdsByPid(id);
            String idStrs = integers.replace("$,", "");
            String[] split = idStrs.split(",");
            List<String> list = Arrays.asList(split);
            List<Park> parkList = this.parkDao.selectByInstitutionIds(list);
            for (int i = 0; i < parkList.size(); ++i) {
                Park park = parkList.get(i);
                for (int j = 0; j < userpark.length; ++j) {
                    if (!userpark[j].equals(String.valueOf(park.getId()))) continue;
                    parkInoutdevices.addAll(this.parkInoutdeviceDao.selectByParkId(park.getId()));
                }
            }
        } else if (type == 2) {
            parkInoutdevices = this.parkInoutdeviceDao.selectByParkId(Long.valueOf(id));
        }
        return ObjectResponse.success(this.setResponse(parkInoutdevices));
    }

    public ObjectResponse<List<OrganizationTreeDto>> selectOrganizationTree(Integer userId) {
        ArrayList<OrganizationTreeDto> olist = new ArrayList<OrganizationTreeDto>();
        List<Long> parkList = this.getParkListByUserId(userId);
        if (CollectionUtils.isEmpty(parkList)) {
            return ObjectResponse.success(olist);
        }
        List<OrganizationTreeDto> plist = this.parkDao.selectParksDetails(StrUtil.join((CharSequence)",", parkList));
        List<OrganizationTreeDto> orgList = this.parkDao.selectAllOrganiz();
        for (OrganizationTreeDto treeDto : plist) {
            int pId = treeDto.getPId();
            Optional<OrganizationTreeDto> first = orgList.stream().filter(organizationTreeDto -> Integer.parseInt(organizationTreeDto.getId()) == pId).findFirst();
            if (first.isPresent() && olist.contains(first.get())) continue;
            first.ifPresent(olist::add);
        }
        olist.addAll(plist);
        Collections.sort(olist);
        return ObjectResponse.success(olist);
    }

    public ObjectResponse<List<OrganizationTreeDto>> selectAllOrganiz() {
        return ObjectResponse.success(this.parkDao.selectAllOrganiz());
    }

    public ObjectResponse<Park> findByParkId(Long parkId) {
        String cacheKey = "park:info:id:" + parkId;
        Park park = (Park)this.redisHandle.cacheObject(cacheKey, Park.class, () -> this.parkDao.selectParkById(parkId), 604800000L);
        if (park == null) {
            log.info("[\u8f66\u573a\u4fe1\u606f\u67e5\u8be2]\u6839\u636eparkId\u672a\u627e\u5230\u8f66\u573a\u4fe1\u606f. parkId[{}]", (Object)parkId);
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)park);
    }

    public ObjectResponse<Park> findByParkCode(String parkCode) {
        if (StringUtils.isBlank((CharSequence)parkCode)) {
            return ObjectResponse.failed((String)"404");
        }
        String cacheKey = "park:info:code:" + parkCode;
        Park park = (Park)this.redisHandle.cacheObject(cacheKey, Park.class, () -> this.parkDao.selectByCode(parkCode), 604800000L);
        if (park == null) {
            log.info("[\u8f66\u573a\u4fe1\u606f\u67e5\u8be2]\u6839\u636eparkCode\u672a\u627e\u5230\u8f66\u573a\u4fe1\u606f. parkCode[{}]", (Object)parkCode);
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)park);
    }

    public ObjectResponse<Long> getFreeByParkCode(String parkCode) {
        Long freeTime = this.parkConfigDao.selectFreeTimeByParkCode(parkCode);
        if (freeTime != null) {
            return ObjectResponse.success((Object)freeTime);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<BasePark>> getBaseParkList(Collection<Long> parkIds) {
        List parks = this.list((Wrapper)this.getLambdaQueryWrapper().in(BasePark::getId, parkIds));
        if (CollectionUtils.isNotEmpty((Collection)parks)) {
            return ObjectResponse.success((Object)parks);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<BasePark>> getBaseParkName(String name, Collection<Long> parkIds, Integer limit) {
        List parks = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)this.getLambdaQueryWrapper().like(StringUtils.isNotEmpty((CharSequence)name), BasePark::getParkName, (Object)name)).in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L), BasePark::getId, parkIds)).last(limit > -1, " limit " + limit));
        return ObjectResponse.success((Object)parks);
    }

    public ObjectResponse<Boolean> reportParkInfo() {
        return null;
    }

    public ObjectResponse<ParkPlotsDto> countParkPlots(String parkIdList) {
        ParkPlotsDto parkPlotsDto = this.parkDao.countParkPlots(parkIdList);
        if (parkPlotsDto != null) {
            return ObjectResponse.success((Object)parkPlotsDto);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<ParkAreaDetailDto>> countParkPlotsByArea(String parkIdList) {
        List<ParkAreaDetailDto> parkAreaDetailDtos = this.parkDao.countParkPlotsByArea(parkIdList);
        if (parkAreaDetailDtos != null) {
            return ObjectResponse.success(parkAreaDetailDtos);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<ParkDto>> getParkList(Integer userId) {
        return this.getParkList(userId, null);
    }

    public ObjectResponse<List<ParkDto>> getParkListLimit(Integer userId, String key) {
        if (userId == null) {
            return ObjectResponse.returnNotFoundIfNull(null);
        }
        List<Long> parkIds = this.getParkListByUserId(userId);
        if (CollectionUtils.isEmpty(parkIds)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        if (parkIds.get(0) == -1L) {
            List<Park> parks = this.parkDao.selectByParkIdsAndParkNameLimit(null, key);
            ArrayList parkDtos = Lists.newArrayList();
            parks.forEach(park -> {
                ParkDto parkDto = new ParkDto();
                parkDto.setId(park.getId());
                parkDto.setParkCode(park.getParkCode());
                parkDto.setParkName(park.getParkName());
                parkDto.setDataCollection(this.getParkDataCollection(park.getId(), null));
                parkDtos.add(parkDto);
            });
            return ObjectResponse.success(this.setOtherFilds(parkDtos));
        }
        List<Park> parks = this.parkDao.selectByParkIdsAndParkNameLimit(parkIds, key);
        if (CollectionUtils.isEmpty(parks)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        ArrayList parkDtos = Lists.newArrayList();
        parks.forEach(park -> {
            ParkDto parkDto = new ParkDto();
            parkDto.setId(park.getId());
            parkDto.setParkCode(park.getParkCode());
            parkDto.setParkName(park.getParkName());
            parkDtos.add(parkDto);
        });
        return ObjectResponse.success(this.setOtherFilds(parkDtos));
    }

    public List<Long> getParkListByUserId(Integer userId) {
        String cacheKey = "user:park:" + userId;
        return this.redisHandle.cacheList(cacheKey, Long.class, () -> this.selectUserParks(userId), 604800000L);
    }

    public List<Long> getParkListByUserId(Integer userId, String parkCode, String parkName) {
        List<Long> parkIds = this.getParkListByUserId(userId);
        if (CollectionUtils.isEmpty(parkIds)) {
            return parkIds;
        }
        if (StringUtils.isNotEmpty((CharSequence)parkCode)) {
            ObjectResponse<Park> parkObjectResponse = this.findByParkCode(parkCode);
            if (ObjectResponse.isSuccess(parkObjectResponse)) {
                Park park = (Park)parkObjectResponse.getData();
                parkIds = parkIds.get(0) == -1L ? Collections.singletonList(park.getId()) : (parkIds.contains(park.getId()) ? Collections.singletonList(park.getId()) : new ArrayList<Long>());
            } else {
                parkIds = new ArrayList<Long>();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)parkName)) {
            BasePark park = (BasePark)this.selectLimitOne((LambdaQueryWrapper)Wrappers.lambdaQuery(BasePark.class).eq(BasePark::getParkName, (Object)parkName));
            parkIds = park != null ? (parkIds.get(0) == -1L ? Collections.singletonList(park.getId()) : (parkIds.contains(park.getId()) ? Collections.singletonList(park.getId()) : new ArrayList<Long>())) : new ArrayList<Long>();
        }
        return parkIds;
    }

    private List<Long> selectUserParks(Integer userId) {
        List allInstitutionIds;
        SaasUserPark saasUserPark = new SaasUserPark();
        saasUserPark.setUserId(userId);
        List saasUserParks = this.saasUserParkService.list((Object)saasUserPark);
        if (CollectionUtils.isEmpty((Collection)saasUserParks)) {
            return new ArrayList<Long>();
        }
        List institutionIds = saasUserParks.stream().filter(sp -> Integer.valueOf(1).equals(sp.getType()) && sp.getInstitutionId() != null).map(SaasUserPark::getInstitutionId).map(Integer::longValue).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(institutionIds) && institutionIds.contains(HIGHEST_INST)) {
            return Collections.singletonList(-1L);
        }
        List<Object> parkIds = saasUserParks.stream().filter(sp -> Integer.valueOf(2).equals(sp.getType()) && sp.getParkId() != null).map(SaasUserPark::getParkId).map(Integer::longValue).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(parkIds)) {
            parkIds = Lists.newArrayList();
        }
        if (CollectionUtils.isNotEmpty(institutionIds) && CollectionUtils.isNotEmpty((Collection)(allInstitutionIds = this.saasUserDao.selectAllInstitutionIdsByIds(institutionIds)))) {
            List<Park> parks = this.parkDao.selectByInstitutionIds(allInstitutionIds);
            if (CollectionUtils.isNotEmpty(parks)) {
                List newParkIds = parks.stream().map(BasePark::getId).collect(Collectors.toList());
                parkIds.addAll(newParkIds);
            }
            parkIds = parkIds.stream().distinct().collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)parkIds)) {
            return new ArrayList<Long>();
        }
        return parkIds;
    }

    private List<ParkDto> setOtherFilds(List<ParkDto> parkDtos) {
        try {
            if (CollectionUtil.isEmpty(parkDtos)) {
                return parkDtos;
            }
            List parkIds = parkDtos.stream().map(ParkDto::getId).collect(Collectors.toList());
            List parkConfigs = this.parkConfigDao.selectList((Wrapper)Wrappers.lambdaQuery(ParkConfig.class).in(ParkConfig::getParkId, parkIds));
            parkDtos.forEach(parkDto -> parkConfigs.forEach(parkConfig -> {
                if (parkDto.getId().equals(parkConfig.getParkId())) {
                    parkDto.setDataCollection(parkConfig.getDataCollection());
                }
            }));
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u5217\u8868\u67e5\u8be2\u8bbe\u7f6e\u5b57\u6bb5\u62a5\u9519]", (Throwable)e);
        }
        return parkDtos;
    }

    public ObjectResponse<List<ParkDto>> getParkList(Integer userId, List<Long> parkIds, String parkNameKey) {
        if (CollectionUtil.isEmpty(parkIds)) {
            return this.getParkList(userId, parkNameKey);
        }
        List<Park> parks = this.parkDao.selectByParkIdsAndParkName(parkIds, parkNameKey);
        ArrayList parkDtos = Lists.newArrayList();
        parks.forEach(park -> {
            ParkDto parkDto = new ParkDto();
            parkDto.setId(park.getId());
            parkDto.setParkCode(park.getParkCode());
            parkDto.setParkName(park.getParkName());
            parkDtos.add(parkDto);
        });
        return ObjectResponse.success((Object)parkDtos);
    }

    private ObjectResponse<List<ParkDto>> getParkList(Integer userId, String key) {
        if (userId == null) {
            return ObjectResponse.returnNotFoundIfNull(null);
        }
        List<Long> parkIds = this.getParkListByUserId(userId);
        if (CollectionUtils.isEmpty(parkIds)) {
            return ObjectResponse.returnNotFoundIfNull(null);
        }
        if (parkIds.get(0) == -1L) {
            List<Park> parks = this.parkDao.selectByParkIdsAndParkName(null, key);
            ArrayList parkDtos = Lists.newArrayList();
            parks.forEach(park -> {
                ParkDto parkDto = new ParkDto();
                parkDto.setId(park.getId());
                parkDto.setParkCode(park.getParkCode());
                parkDto.setParkName(park.getParkName());
                parkDtos.add(parkDto);
            });
            return ObjectResponse.success((Object)parkDtos);
        }
        List<Park> parks = this.parkDao.selectByParkIdsAndParkName(parkIds, key);
        if (CollectionUtils.isEmpty(parks)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        ArrayList parkDtos = Lists.newArrayList();
        parks.forEach(park -> {
            ParkDto parkDto = new ParkDto();
            parkDto.setId(park.getId());
            parkDto.setParkCode(park.getParkCode());
            parkDto.setParkName(park.getParkName());
            parkDtos.add(parkDto);
        });
        return ObjectResponse.success((Object)parkDtos);
    }

    public ObjectResponse<List<AisleDto>> getAisleList(String parkCode, Integer type) {
        ObjectResponse<Park> parkResp = this.findByParkCode(parkCode);
        if (parkResp.getData() == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        List<ParkInoutdevice> parkInoutdevices = this.parkInoutdeviceDao.selectByParkIdAndType(((Park)parkResp.getData()).getId(), type);
        if (CollectionUtils.isEmpty(parkInoutdevices)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        ArrayList aisleDtos = Lists.newArrayList();
        parkInoutdevices.forEach(parkInoutdevice -> {
            AisleDto aisleDto = new AisleDto();
            aisleDto.setId(parkInoutdevice.getId());
            aisleDto.setParkId(parkInoutdevice.getParkId());
            aisleDto.setAisleCode(parkInoutdevice.getInandoutCode());
            aisleDto.setAisleName(parkInoutdevice.getInandoutName());
            aisleDto.setIsMaster(parkInoutdevice.getIsMaster());
            aisleDtos.add(aisleDto);
        });
        return ObjectResponse.success((Object)aisleDtos);
    }

    public ObjectResponse<List<ParkInoutdevice>> getChannelByType(Long parkId, Integer type) {
        List<ParkInoutdevice> parkInoutdevices = this.parkInoutdeviceDao.selectByParkIdAndType(parkId, type);
        if (CollectionUtils.isEmpty(parkInoutdevices)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkInoutdevices);
    }

    public ObjectResponse<List<ParkInoutdevice>> getAllChannel(Long parkId) {
        List<ParkInoutdevice> parkInoutdevices = this.parkInoutdeviceDao.selectByParkId(parkId);
        if (CollectionUtils.isEmpty(parkInoutdevices)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkInoutdevices);
    }

    public ObjectResponse<ParkInoutdevice> getChannelInfo(Long parkId, String serialNumber) {
        ObjectResponse deviceResp = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
        if (deviceResp == null || deviceResp.getData() == null) {
            return ObjectResponse.failed((String)"404");
        }
        return this.getInoutDeviceById(((ParkDevice)deviceResp.getData()).getChannelId().longValue());
    }

    public ObjectResponse<ParkConfig> getParkConfig(Long parkId) {
        String cacheKey = "park:config:park:id:" + parkId;
        ParkConfig parkConfig = (ParkConfig)this.redisHandle.cacheObject(cacheKey, ParkConfig.class, () -> this.parkConfigDao.selectByParkId(parkId), 604800000L);
        if (parkConfig == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)parkConfig);
    }

    public ObjectResponse<ParkConfig> getParkConfig(String parkCode) {
        String cacheKey = "park:config:park:code:" + parkCode;
        ParkConfig parkConfig = (ParkConfig)this.redisHandle.cacheObject(cacheKey, ParkConfig.class, () -> {
            ObjectResponse<Park> parkResp = this.findByParkCode(parkCode);
            if (!ObjectResponse.isSuccess(parkResp)) {
                return null;
            }
            ParkConfig data = this.parkConfigDao.selectByParkId(((Park)parkResp.getData()).getId());
            return data;
        }, 604800000L);
        if (parkConfig == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)parkConfig);
    }

    public ObjectResponse<Map<Long, ParkConfig>> getParkConfigs(Collection<Long> parkIds) {
        ArrayList<Object> configs = new ArrayList<Object>(parkIds.size());
        for (Long parkId : parkIds) {
            ObjectResponse<ParkConfig> configResp = this.getParkConfig(parkId);
            if (!ObjectResponse.isSuccess(configResp)) continue;
            configs.add(configResp.getData());
        }
        if (CollectionUtils.isEmpty(configs)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success(configs.stream().collect(Collectors.toMap(ParkConfig::getParkId, Function.identity(), (older, newer) -> newer)));
    }

    public ObjectResponse<ParkInoutdevice> getInoutDeviceById(Long id) {
        String cacheKey = "park:channel:id:" + id;
        if (this.grayProperties.isCacheEnable()) {
            cacheKey = "gray:" + cacheKey;
        }
        ParkInoutdevice parkInoutdevice = (ParkInoutdevice)this.redisHandle.cacheObject(cacheKey, ParkInoutdevice.class, () -> (ParkInoutdevice)this.parkInoutdeviceDao.selectById(id), 604800000L);
        return ObjectResponse.returnNotFoundIfNull((Object)parkInoutdevice);
    }

    public List<ParkInoutdevice> getInoutDeviceByIds(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return this.parkInoutdeviceDao.selectByIds(idList);
    }

    public ObjectResponse<ParkInoutdevice> getInoutDeviceByCode(String channelCode) {
        if (StringUtils.isBlank((CharSequence)channelCode)) {
            return ObjectResponse.failed((String)"404");
        }
        String cacheKey = "park:channel:code:" + channelCode;
        if (this.grayProperties.isCacheEnable()) {
            cacheKey = "gray:" + cacheKey;
        }
        ParkInoutdevice channel = (ParkInoutdevice)this.redisHandle.cacheObject(cacheKey, ParkInoutdevice.class, () -> this.parkInoutdeviceDao.selectByCode(null, channelCode), 604800000L);
        return ObjectResponse.returnNotFoundIfNull((Object)channel);
    }

    public ObjectResponse<ParkChargeRuleVO> getParkChargeRule(Long parkId, Long regionId) {
        ParkChargeRuleVO parkChargeRuleVO = this.getFreeTimeLocal(parkId, regionId);
        if (parkChargeRuleVO == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)parkChargeRuleVO);
    }

    public ObjectResponse<Integer> getFreeTime(Long parkId) {
        ParkChargeRuleVO vo = this.getFreeTimeLocal(parkId, null);
        return ObjectResponse.success((Object)(vo == null || vo.getFreeTime() == null ? 0 : vo.getFreeTime()));
    }

    public ObjectResponse<ParkChargeRuleVO> getMinFreeTime(Long parkId) {
        ObjectResponse chargeConfigResp = this.chargeService.getConfigs(parkId);
        ParkChargeRuleVO vo = new ParkChargeRuleVO();
        vo.setFreeTime(Integer.valueOf(0));
        vo.setIsFreetimeOnce(Integer.valueOf(0));
        if (!ObjectResponse.isSuccess((Response)chargeConfigResp)) {
            log.info("\u672a\u627e\u5230\u8f66\u573a\u914d\u7f6e\u7684\u8ba1\u8d39\u89c4\u5219. parkId[{}]", (Object)parkId);
            return ObjectResponse.success((Object)vo);
        }
        List chargeConfigs = (List)chargeConfigResp.getData();
        int minFreeTime = 0;
        if (CollectionUtils.isNotEmpty((Collection)chargeConfigs)) {
            for (int i = 0; i < chargeConfigs.size(); ++i) {
                ParkChargeconfig chargeConfig = (ParkChargeconfig)chargeConfigs.get(i);
                Integer billType = chargeConfig.getBilltype();
                ParkChargeRuleVO freeTimeLocal = this.getFreeTimeLocal(billType, chargeConfig.getBilltypecode());
                if (i != 0 && minFreeTime <= NumberUtils.toPrimitive((Integer)freeTimeLocal.getFreeTime())) continue;
                minFreeTime = freeTimeLocal.getFreeTime();
                vo = freeTimeLocal;
            }
        }
        log.info("\u627e\u5230\u8f66\u573a[{}]\u514d\u8d39\u65f6\u957f\u6700\u5c0f\u7684\u8ba1\u8d39\u89c4\u5219, vo[{}]", (Object)parkId, (Object)vo);
        return ObjectResponse.success((Object)vo);
    }

    public ObjectResponse<ParkInoutdevice> getInOutDeviceByCode(Long parkId, String channelCode) {
        ObjectResponse<ParkInoutdevice> channelResp = this.getInoutDeviceByCode(channelCode);
        if (ObjectResponse.isSuccess(channelResp) && (parkId == null || ((ParkInoutdevice)channelResp.getData()).getParkId().equals(parkId))) {
            return channelResp;
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Integer> saveOpeningRecord(OpeningDtoRequest request) {
        try {
            ParkInoutdevice parkInoutdevice;
            Long parkId = request.getParkId();
            if (parkId == null) {
                ObjectResponse<Park> parkResp = this.findByParkCode(request.getParkCode());
                if (parkResp.getData() == null) {
                    return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
                }
                parkId = ((Park)parkResp.getData()).getId();
            }
            if ((parkInoutdevice = this.getChannelByCodeAndParkId(parkId, request.getAisleCode())) == null) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            Opening opening = new Opening();
            opening.setSwitchType(Integer.valueOf(4).equals(request.getSourcegate()) ? 2 : 1);
            opening.setParkId(parkId.intValue());
            opening.setChannelId(parkInoutdevice.getId().toString());
            opening.setGatepos(parkInoutdevice.getInandoutName());
            long executeTime = String.valueOf(request.getExecuteTime()).length() >= 13 ? request.getExecuteTime() : request.getExecuteTime() * 1000L;
            opening.setIssuedTm(new Date(executeTime));
            opening.setCreateTime(new Date());
            opening.setSourcegate(request.getSourcegate() == null ? 2 : request.getSourcegate());
            opening.setPlateNum(request.getPlateNum());
            opening.setOrderNum(request.getOrderNum());
            opening.setGateType(request.getRecordType().intValue());
            opening.setGatephoto(request.getImgUrl());
            opening.setOperAccount(request.getOperAccount());
            if (request.getReasonType() != null) {
                opening.setReason(request.getReasonType().intValue());
            } else if (!Integer.valueOf(4).equals(request.getSourcegate())) {
                opening.setReason(3);
            }
            opening.setRemark(request.getRemark());
            this.openingDao.insert(opening);
            this.mqPushService.pushErrorOpen(opening);
            return ObjectResponse.success((Object)opening.getId());
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. request[{}]", new Object[]{e.getMessage(), request, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<String> selectGroupPayType(String parkCode) {
        ObjectResponse<Park> parkResp = this.findByParkCode(parkCode);
        if (parkResp.getData() == null) {
            return ObjectResponse.failed((String)"404", (String)"\u8f66\u573a\u4e0d\u5b58\u5728");
        }
        ObjectResponse<ParkConfig> parkConfigResp = this.getParkConfig(((Park)parkResp.getData()).getId());
        if (ObjectResponse.isSuccess(parkConfigResp) && ((ParkConfig)parkConfigResp.getData()).getIsEpayment() == 1) {
            return ObjectResponse.success((Object)((ParkConfig)parkConfigResp.getData()).getEPayment());
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_2006);
    }

    public ObjectResponse<List<Park>> parkListByType(int type) {
        List<Park> parks = this.parkDao.selectListByType(type);
        if (parks != null) {
            return ObjectResponse.success(parks);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Boolean> isFullNoPass(Long parkId, String channelCode) {
        Integer fullEmptynum;
        int freeSpace;
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        ObjectResponse.notError((Response)parkObjectResponse, (String)"\u8f66\u573aid\u4e0d\u5b58\u5728");
        Park park = (Park)parkObjectResponse.getData();
        ObjectResponse objectResponse = this.parkService.getInoutDeviceByCode(channelCode);
        ObjectResponse.notError((Response)objectResponse, (String)"\u901a\u9053\u7f16\u53f7\u4e0d\u5b58\u5728");
        ParkInoutdevice parkInoutdevice = (ParkInoutdevice)objectResponse.getData();
        ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById(parkInoutdevice.getRegionId());
        AssertTools.notNull((Object)parkRegion, (String)"404", (String)"\u8f66\u573a\u533a\u57df\u4e0d\u5b58\u5728");
        if (park.getIsInterior() == null || Integer.valueOf(0).equals(park.getIsInterior())) {
            ObjectResponse spaceResp = this.parkFreeSpaceService.getSpaceByPark(parkId.longValue());
            if (!ObjectResponse.isSuccess((Response)spaceResp)) {
                return ObjectResponse.success((Object)Boolean.FALSE);
            }
            freeSpace = ((ParkFreespace)spaceResp.getData()).getFreeSpace();
        } else {
            freeSpace = NumberUtils.toPrimitive((Integer)parkRegion.getFreePark());
        }
        boolean isFull = false;
        if (parkRegion.getIsFullForbidenter() != null && parkRegion.getIsFullForbidenter() == 1 && (fullEmptynum = parkRegion.getFullEmptynum()) >= freeSpace) {
            isFull = true;
        }
        return ObjectResponse.success((Object)isFull);
    }

    public ObjectResponse<ParkFreespace> getParkSpace(Long parkId) {
        return this.parkFreeSpaceService.getSpaceByPark(parkId.longValue());
    }

    public ObjectResponse<List<DictionaryItemDto>> getDicItemList(Integer type) {
        try {
            List<DictionaryItem> dictionaryItems = this.dictionaryItemDao.selectByDictionaryType(type);
            if (CollectionUtils.isEmpty(dictionaryItems)) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            ArrayList reasons = Lists.newArrayList();
            dictionaryItems.forEach(dictionaryItem -> {
                DictionaryItemDto dictionaryItemDto = new DictionaryItemDto();
                dictionaryItemDto.setValue(Integer.valueOf(dictionaryItem.getValue()));
                dictionaryItemDto.setText(dictionaryItem.getText());
                reasons.add(dictionaryItemDto);
            });
            return ObjectResponse.success((Object)reasons);
        }
        catch (Exception e) {
            log.error("[\u5b57\u5178\u7c7b\u578b\u83b7\u53d6]\u5904\u7406\u5931\u8d25: {}. type[{}]", new Object[]{e.getMessage(), type, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<List<ParkInoutdevice>> getInoutByParkId(Long parkId) {
        List<ParkInoutdevice> parkInoutdevices = this.parkInoutdeviceDao.selectByParkId(parkId);
        if (CollectionUtils.isEmpty(parkInoutdevices)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkInoutdevices);
    }

    public ObjectResponse<List<ParkInoutdevice>> getChannelsByIds(Long[] channelIds) {
        ArrayList<Object> parkInoutdevices = new ArrayList<Object>(channelIds.length);
        for (int i = 0; i < channelIds.length; ++i) {
            ObjectResponse<ParkInoutdevice> channelResp = this.getInoutDeviceById(channelIds[i]);
            if (!ObjectResponse.isSuccess(channelResp)) continue;
            parkInoutdevices.add(channelResp.getData());
        }
        if (CollectionUtils.isEmpty(parkInoutdevices)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkInoutdevices);
    }

    public ObjectResponse<ParkListGroup> selectByParkInfoThirdPID(String pid, Integer pageIndex, Integer pageSize) {
        Page parkListPage = PageHelper.startPage((int)pageIndex, (int)pageSize);
        List<ParkList> parkLists = this.parkDao.selectByParkInfoThirdPID(pid);
        return ObjectResponse.success((Object)new ParkListGroup(Long.valueOf(parkListPage.getTotal()), String.valueOf(parkListPage.getPages()), parkLists));
    }

    @Transactional
    public ObjectResponse<Long> insertParkInfo(ParkInfo parkInfo) {
        Integer parkSize = this.parkDao.selectParkCountByParkCodeAndName(parkInfo.getParkCode(), parkInfo.getParkName());
        if (parkSize <= 0) {
            parkInfo.setUpdateTime(new Date());
            parkInfo.setUpdateUser("third");
            parkInfo.setKey(UUID.randomUUID().toString().replaceAll("-", ""));
            this.parkDao.saveParkInfo(parkInfo);
            ParkConfigInfo configInfo = new ParkConfigInfo(parkInfo.getParkCode(), Integer.valueOf(parkInfo.getId().intValue()), parkInfo.getDataCollection());
            this.parkConfigDao.saveParkConfigInfo(configInfo);
            ParkFreespace parkFreespace = new ParkFreespace();
            parkFreespace.setParkId(parkInfo.getId());
            parkFreespace.setTotalNum(parkInfo.getTotalNum());
            parkFreespace.setFreeSpace(Objects.isNull(parkInfo.getFreeSpace()) ? parkInfo.getTotalNum() : parkInfo.getFreeSpace());
            parkFreespace.setRealFreeSpace(Objects.isNull(parkInfo.getFreeSpace()) ? parkInfo.getTotalNum() : parkInfo.getFreeSpace());
            this.parkFreeSpaceService.insertFreeSpace(parkFreespace);
            ParkRegion parkRegion = this.createRegion(parkInfo);
            this.removeParkParamFromRedis(parkInfo.getParkCode(), parkInfo.getId());
            this.sendInfoService.saveBatch(Arrays.asList(new SendInfo(parkInfo.getId(), configInfo.getId(), DownServiceEnum.\u8f66\u573a\u914d\u7f6e.getServiceType()), new SendInfo(parkInfo.getId(), parkRegion.getId(), DownServiceEnum.\u533a\u57df\u4fe1\u606f\u548c\u8ba1\u8d39\u89c4\u5219\u5173\u8054\u5173\u7cfb.getServiceType())));
            return ObjectResponse.success((Object)parkInfo.getId());
        }
        return ObjectResponse.failed((String)"400", (String)"\u8f66\u573a\u5df2\u5b58\u5728");
    }

    private ParkRegion createRegion(ParkInfo parkInfo) {
        ParkRegion parkRegion = new ParkRegion();
        parkRegion.setParkId(parkInfo.getId());
        parkRegion.setRegionCode(String.valueOf(new Random().nextInt(999999)));
        parkRegion.setRegionName(parkInfo.getParkName() + "_\u5916\u533a\u57df");
        parkRegion.setFatherRelationId(Long.valueOf(0L));
        parkRegion.setRegionPark(parkInfo.getTotalNum());
        parkRegion.setFreePark(Objects.isNull(parkInfo.getFreeSpace()) ? parkInfo.getTotalNum() : parkInfo.getFreeSpace());
        parkRegion.setRealFreePark(Objects.isNull(parkInfo.getFreeSpace()) ? parkInfo.getTotalNum() : parkInfo.getFreeSpace());
        parkRegion.setRegionType(Integer.valueOf(2));
        parkRegion.setStatus(Integer.valueOf(0));
        parkRegion.setPositionType(Integer.valueOf(0));
        parkRegion.setDefaultName(Integer.valueOf(new Integer(1).equals(parkInfo.getDataCollection()) ? 0 : 1));
        parkRegion.setAdder(Objects.isNull(parkInfo.getAdder()) ? "third" : parkInfo.getAdder());
        parkRegion.setCreateTime(new Date());
        parkRegion.setUpdateUser(Objects.isNull(parkInfo.getAdder()) ? "third" : parkInfo.getAdder());
        parkRegion.setUpdateTime(new Date());
        this.parkRegionDao.insert(parkRegion);
        return parkRegion;
    }

    @Transactional
    public ObjectResponse<String> updateParkInfo(ParkInfo parkInfo) {
        Integer parkSize = this.parkDao.selectParkCountByParkCodeAndName(parkInfo.getParkCode(), parkInfo.getParkName());
        if (parkSize > 0) {
            this.parkDao.updateParkInfo(parkInfo);
            Park park = (Park)this.findByParkCode(parkInfo.getParkCode()).getData();
            parkInfo.setId(park.getId());
            log.info("updateParkInfo [{}]", (Object)parkInfo);
            ObjectResponse<ParkConfig> parkConfigResp = this.getParkConfig(park.getId());
            ObjectResponse.notError(parkConfigResp);
            ParkConfigInfo configInfo = new ParkConfigInfo(parkInfo.getParkCode(), Integer.valueOf(parkInfo.getId().intValue()), parkInfo.getDataCollection());
            this.parkConfigDao.updateParkConfigInfo(configInfo);
            UpdateFreeSpaceService updateFreeSpaceService = this.updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(park.getId());
            updateFreeSpaceService.updateFreeSpace(parkInfo.getId(), null, NumberUtils.toPrimitive((Integer)parkInfo.getFreeSpace()));
            this.sendInfoService.save((Object)new SendInfo(parkInfo.getId(), ((ParkConfig)parkConfigResp.getData()).getId(), DownServiceEnum.\u8f66\u573a\u914d\u7f6e.getServiceType()));
            this.removeParkParamFromRedis(park.getParkCode(), park.getId());
            return ObjectResponse.success((Object)parkInfo.getParkCode());
        }
        return ObjectResponse.failed((String)"404");
    }

    public void removeParkParamFromRedis(String parkCode, Long parkId) {
        this.redisTemplate.delete(Arrays.asList("park:info:id:" + parkId, "park:info:code:" + parkCode, "park:config:park:id:" + parkId, "park:config:park:code:" + parkCode));
    }

    public void removeParkInfoFromRedis(String parkCode, Long parkId) {
        this.redisTemplate.delete(Arrays.asList("park:info:id:" + parkId, "park:info:code:" + parkCode));
    }

    public void removeParkConfigFromRedis(Long parkId, String parkCode) {
        this.redisTemplate.delete(Arrays.asList("park:config:park:id:" + parkId, "park:config:park:code:" + parkCode));
    }

    public ObjectResponse<String> selectParkInfoByParkCode(String parkCode) {
        ParkInfo parkInfo = this.parkDao.selectParkInfoByParkCode(parkCode);
        log.info("selectParkInfoByParkCode parkInfo [{}]", (Object)parkInfo);
        return ObjectResponse.success((Object)JsonUtils.toString((Object)parkInfo));
    }

    public ObjectResponse<Integer> insert(ParkChargeconfig record) {
        return ObjectResponse.success((Object)this.parkChargeconfigDao.insert(record));
    }

    public ObjectResponse<Integer> updateByPrimaryKeySelective(ParkChargeconfig record) {
        return ObjectResponse.success((Object)this.parkChargeconfigDao.updateById(record));
    }

    public ObjectResponse<Integer> deleteByPrimaryKey(Integer id) {
        return ObjectResponse.success((Object)this.parkChargeconfigDao.deleteById(id));
    }

    public ObjectResponse<ParkChargeconfig> selectByParkIdAndBillCode(Long parkId, String billtypecode) {
        return ObjectResponse.success((Object)this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, billtypecode));
    }

    public ObjectResponse<Integer> insert(ParkInoutdevice parkInoutdevice) {
        return ObjectResponse.success((Object)this.parkInoutdeviceDao.insert(parkInoutdevice));
    }

    public ObjectResponse<Integer> updateAllParameter(ParkInoutdevice parkInoutdevice) {
        int result = this.parkInoutdeviceDao.updateById(parkInoutdevice);
        this.sendInfoService.save((Object)new SendInfo(parkInoutdevice.getParkId(), parkInoutdevice.getId(), DownServiceEnum.\u533a\u57df\u4fe1\u606f\u548c\u8ba1\u8d39\u89c4\u5219\u5173\u8054\u5173\u7cfb.getServiceType()));
        return ObjectResponse.success((Object)result);
    }

    public ObjectResponse<Integer> delInoutDeviceConfig(ParkInoutdevice parkInoutdevice) {
        return ObjectResponse.success((Object)this.parkInoutdeviceDao.delInoutDeviceConfig(parkInoutdevice));
    }

    public ObjectResponse<Integer> insertChargeDyration(ChargeDuration chargeDuration) {
        return ObjectResponse.success((Object)this.chargeDyrationDao.insert(chargeDuration));
    }

    public ObjectResponse<Integer> delChargeDyrationRule(String billCode) {
        return ObjectResponse.success((Object)this.chargeDyrationDao.delChargeDyrationRule(billCode));
    }

    public ObjectResponse<Integer> insertChargeNaturalday(ChargeNaturalday chargeNaturalday) {
        return ObjectResponse.success((Object)this.chargeNaturaldayDao.insert(chargeNaturalday));
    }

    public ObjectResponse<Integer> editChargeNaturalDayRule(ChargeNaturalday chargeNaturalday) {
        return ObjectResponse.success((Object)this.chargeNaturaldayDao.updateById(chargeNaturalday));
    }

    public ObjectResponse<Integer> modifyChargeNaturalDayRuleState(ChargeNaturalday chargeNaturalday) {
        return ObjectResponse.success((Object)this.chargeNaturaldayDao.modifyChargeNaturalDayRuleState(chargeNaturalday));
    }

    public ObjectResponse<Integer> insertRegionChargeconfigSelective(RegionChargeconfig regionChargeconfig) {
        return ObjectResponse.success((Object)this.regionChargeconfigDao.insert(regionChargeconfig));
    }

    public ObjectResponse<Integer> modifyRegionChargeConfigStatus(RegionChargeconfig regionChargeconfig) {
        return ObjectResponse.success((Object)this.regionChargeconfigDao.modifyRegionChargeConfigStatus(regionChargeconfig));
    }

    public ObjectResponse<Integer> delRegionChargeConfig(String billtypecode) {
        return ObjectResponse.success((Object)this.regionChargeconfigDao.delRegionChargeConfig(billtypecode));
    }

    public ObjectResponse<List<RegionChargeconfig>> selectRegionChargeconfigByParkId(Long parkId) {
        return ObjectResponse.success(this.regionChargeconfigDao.selectByParkId(parkId));
    }

    public ParkChargeRuleVO getFreeTimeLocal(Long parkId, Long regionId) {
        ParkChargeconfig parkChargeConfig;
        RegionChargeconfig regionChargeconfig;
        if (regionId != null && (regionChargeconfig = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, 0)) != null && (parkChargeConfig = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig.getBilltypecode())) != null) {
            return this.getFreeTimeLocal(parkChargeConfig.getBilltype(), parkChargeConfig.getBilltypecode());
        }
        ObjectResponse chargeConfigResp = this.chargeService.getConfigs(parkId);
        if (!ObjectResponse.isSuccess((Response)chargeConfigResp)) {
            log.info("\u672a\u627e\u5230\u8f66\u573a\u914d\u7f6e\u7684\u8ba1\u8d39\u89c4\u5219. parkId[{}]", (Object)parkId);
            return null;
        }
        List chargeConfigs = (List)chargeConfigResp.getData();
        ParkChargeconfig parkChargeconfig = null;
        if (CollectionUtils.isNotEmpty((Collection)chargeConfigs)) {
            for (ParkChargeconfig chargeConfig : chargeConfigs) {
                if (chargeConfig.getDefaultCharge() == null || chargeConfig.getDefaultCharge() != 1) continue;
                parkChargeconfig = chargeConfig;
                break;
            }
        }
        if (parkChargeconfig == null) {
            log.info("\u8f66\u573a\u672a\u914d\u7f6e\u9ed8\u8ba4\u7684\u8ba1\u8d39\u89c4\u5219. parkId[{}]", (Object)parkId);
            return null;
        }
        Integer billType = parkChargeconfig.getBilltype();
        return this.getFreeTimeLocal(billType, parkChargeconfig.getBilltypecode());
    }

    public ParkChargeRuleVO getFreeTimeLocal(Integer billType, String billtypeCode) {
        ObjectResponse charge24chargeResp;
        ParkChargeRuleVO vo = new ParkChargeRuleVO();
        if (billType == 1) {
            ObjectResponse chargeNaturaldayResp = this.chargeService.getNaturalday(billtypeCode);
            if (ObjectResponse.isSuccess((Response)chargeNaturaldayResp) && chargeNaturaldayResp.getData() != null) {
                vo.setFreeTime(((ChargeNaturalDayDetail)chargeNaturaldayResp.getData()).getFreetime());
                vo.setIsFreetimeOnce(((ChargeNaturalDayDetail)chargeNaturaldayResp.getData()).getIsFreetimeOnce());
            }
        } else if (billType == 2) {
            ObjectResponse chargeDaynightResp = this.chargeService.getDaynight(billtypeCode);
            if (ObjectResponse.isSuccess((Response)chargeDaynightResp) && chargeDaynightResp.getData() != null) {
                vo.setFreeTime(((ChargeDayNightDetail)chargeDaynightResp.getData()).getFreetime());
                vo.setIsFreetimeOnce(((ChargeDayNightDetail)chargeDaynightResp.getData()).getIsFreetimeOnce());
            }
        } else if (billType == 3 && ObjectResponse.isSuccess((Response)(charge24chargeResp = this.chargeService.get24Hours(billtypeCode))) && charge24chargeResp.getData() != null) {
            vo.setFreeTime(((Charge24HourDetail)charge24chargeResp.getData()).getFreetime());
            vo.setIsFreetimeOnce(((Charge24HourDetail)charge24chargeResp.getData()).getIsFreetimeOnce());
        }
        if (vo.getFreeTime() == null) {
            vo.setFreeTime(Integer.valueOf(0));
        }
        if (vo.getIsFreetimeOnce() == null) {
            vo.setIsFreetimeOnce(Integer.valueOf(0));
        }
        return vo;
    }

    public Integer getFreeTimeByBillId(Integer billId) {
        ObjectResponse charge24chargeObjectResponse;
        ParkChargeconfig parkChargeconfig = this.parkChargeconfigDao.selectByPrimaryKey(billId);
        if (Objects.isNull(parkChargeconfig)) {
            log.info("\u672a\u627e\u5230\u8ba1\u8d39\u89c4\u5219. billId[{}]", (Object)billId);
            return 0;
        }
        if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u901a\u7528\u81ea\u7136\u5929.type) {
            ObjectResponse naturaldayObjectResponse = this.chargeService.getNaturalday(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess((Response)naturaldayObjectResponse)) {
                ChargeNaturalday data1 = (ChargeNaturalday)naturaldayObjectResponse.getData();
                return data1.getFreetime();
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u767d\u5929\u591c\u95f4\u6536\u8d39.type) {
            ObjectResponse chargeDaynightObjectResponse = this.chargeService.getDaynight(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess((Response)chargeDaynightObjectResponse)) {
                ChargeDaynight data1 = (ChargeDaynight)chargeDaynightObjectResponse.getData();
                return data1.getFreetime();
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u4e8c\u5341\u56db\u5c0f\u65f6\u8ba1\u8d39.type && ObjectResponse.isSuccess((Response)(charge24chargeObjectResponse = this.chargeService.get24Hours(parkChargeconfig.getBilltypecode())))) {
            Charge24charge data1 = (Charge24charge)charge24chargeObjectResponse.getData();
            return data1.getFreetime();
        }
        return 0;
    }

    public ChargeConfigDTO getChargeByBillId(ParkChargeconfig parkChargeconfig, Integer carType) {
        ObjectResponse charge24chargeObjectResponse;
        ChargeConfigDTO dto = new ChargeConfigDTO();
        if (Objects.isNull(parkChargeconfig)) {
            log.info("\u672a\u627e\u5230\u8ba1\u8d39\u89c4\u5219, parkChargeconfig[{}]", (Object)parkChargeconfig);
            dto.setFreeTime(Integer.valueOf(0));
            return dto;
        }
        dto.setBillId(parkChargeconfig.getId());
        if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u901a\u7528\u81ea\u7136\u5929.type) {
            ObjectResponse naturaldayObjectResponse = this.chargeService.getNaturalday(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess((Response)naturaldayObjectResponse)) {
                ChargeNaturalday data1 = (ChargeNaturalday)naturaldayObjectResponse.getData();
                dto.setFreeTime(data1.getFreetime());
                dto.setIsFreetimeOnce(data1.getIsFreetimeOnce());
                if (!Objects.isNull(data1.getDaynightmaxfeeusing())) {
                    dto.setDaynightmaxfeeusing(data1.getDaynightmaxfeeusing());
                }
                if (!Objects.isNull(data1.getMaxFeeType())) {
                    dto.setMaxFeeType(data1.getMaxFeeType());
                }
                if (!Objects.isNull(data1.getDaynightmaxfee())) {
                    if (Objects.nonNull(carType) && carType == 2) {
                        dto.setDaynightmaxfee(data1.getDaynightmaxfeeBig());
                    } else {
                        dto.setDaynightmaxfee(data1.getDaynightmaxfee());
                    }
                }
                if (!Objects.isNull(data1.getCountType())) {
                    dto.setCountType(data1.getCountType());
                }
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u767d\u5929\u591c\u95f4\u6536\u8d39.type) {
            ObjectResponse chargeDaynightObjectResponse = this.chargeService.getDaynight(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess((Response)chargeDaynightObjectResponse)) {
                ChargeDaynight data1 = (ChargeDaynight)chargeDaynightObjectResponse.getData();
                dto.setFreeTime(data1.getFreetime());
                dto.setIsFreetimeOnce(data1.getIsFreetimeOnce());
                if (!Objects.isNull(data1.getDaynightmaxfeeusing())) {
                    dto.setDaynightmaxfeeusing(data1.getDaynightmaxfeeusing());
                }
                if (!Objects.isNull(data1.getMaxFeeType())) {
                    dto.setMaxFeeType(data1.getMaxFeeType());
                }
                if (!Objects.isNull(data1.getDaynightmaxfee())) {
                    if (Objects.nonNull(carType) && carType == 2) {
                        dto.setDaynightmaxfee(data1.getDaynightmaxfeeBig());
                    } else {
                        dto.setDaynightmaxfee(data1.getDaynightmaxfee());
                    }
                }
                if (!Objects.isNull(data1.getCountType())) {
                    dto.setCountType(data1.getCountType());
                }
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u4e8c\u5341\u56db\u5c0f\u65f6\u8ba1\u8d39.type && ObjectResponse.isSuccess((Response)(charge24chargeObjectResponse = this.chargeService.get24Hours(parkChargeconfig.getBilltypecode())))) {
            Charge24charge data1 = (Charge24charge)charge24chargeObjectResponse.getData();
            dto.setFreeTime(data1.getFreetime());
            dto.setIsFreetimeOnce(data1.getIsFreetimeOnce());
            if (!Objects.isNull(data1.getDaynightmaxfeeusing())) {
                dto.setDaynightmaxfeeusing(data1.getDaynightmaxfeeusing());
            }
            if (!Objects.isNull(data1.getMaxFeeType())) {
                dto.setMaxFeeType(data1.getMaxFeeType());
            }
            if (!Objects.isNull(data1.getDaynightmaxfee())) {
                if (Objects.nonNull(carType) && carType == 2) {
                    dto.setDaynightmaxfee(data1.getDaynightmaxfeeBig());
                } else {
                    dto.setDaynightmaxfee(data1.getDaynightmaxfee());
                }
            }
            if (!Objects.isNull(data1.getCountType())) {
                dto.setCountType(data1.getCountType());
            }
        }
        return dto;
    }

    public List<OrganizationTreeDto> selectParksDetails(String parkId) {
        return this.parkDao.selectParksDetails(parkId);
    }

    public OrganizationTreeDto selectOrganizDetailsByName(String institutionName) {
        return this.parkDao.selectOrganizDetailsByName(institutionName);
    }

    public Boolean updateParkInstitutionId(Integer institutionId, Long parkId) {
        return this.parkDao.updateParkInstitutionId(institutionId, parkId) > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Void> deletePark(Long parkId, Integer orgId, String parkCode) {
        List thirdParks;
        Boolean result = this.updateParkInstitutionId(orgId, parkId);
        if (!result.booleanValue()) {
            return ObjectResponse.failed((String)"10000", (String)"\u8f66\u573a\u56de\u6536\u7ad9\u5931\u8d25");
        }
        this.removeParkInfoFromRedis(parkCode, parkId);
        List saasUserParks = this.saasUserParkService.listByParkId(parkId);
        if (CollectionUtils.isNotEmpty((Collection)saasUserParks)) {
            this.saasUserParkService.deleteByParkIds(saasUserParks.stream().map(SaasUserPark::getId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(thirdParks = this.thirdParkService.findAllByParkId(parkId)))) {
            this.thirdParkService.deleteByIds(thirdParks.stream().map(ThirdPark::getId).collect(Collectors.toList()));
        }
        return ObjectResponse.success();
    }

    public ParkInoutdevice getChannelByCodeAndParkId(Long parkId, String inandoutCode) {
        return (ParkInoutdevice)this.getInOutDeviceByCode(parkId, inandoutCode).getData();
    }

    public List<ChangPingParkUser> getChangPingParkUser(Long parkId, String parkCode) {
        ObjectResponse<Park> parkObjectResponse = this.findByParkId(parkId);
        if (parkObjectResponse.getData() == null) {
            return Collections.emptyList();
        }
        Park park = (Park)parkObjectResponse.getData();
        List users = this.saasUserDao.getRoleIdsByInstitutionId(park.getInstitutionId(), Collections.singletonList("\u4e91\u5c97\u4ead\u7ba1\u7406\u5458"));
        if (CollectionUtils.isEmpty((Collection)users)) {
            return Collections.emptyList();
        }
        return users.stream().map(s -> ChangPingParkUser.builder().parklotCode(parkCode).userCode(String.valueOf(s.getId())).userName(s.getUsername()).phone(s.getPhone()).passWd(s.getPassword()).type("0").build()).collect(Collectors.toList());
    }

    public ObjectResponse<ParkAllInfo> getAllParkInfo(String parkCode) {
        ParkAllInfo parkAllInfo = new ParkAllInfo();
        ObjectResponse<Park> parkObjectResponse = this.findByParkCode(parkCode);
        Park park = (Park)parkObjectResponse.getData();
        ObjectResponse freeSpaceResponse = this.parkFreeSpaceService.getSpaceByPark(park.getId().longValue());
        ParkFreespace parkFreespace = (ParkFreespace)freeSpaceResponse.getData();
        ObjectResponse<ParkConfig> objectResponse = this.getParkConfig(park.getId());
        if (!ObjectResponse.isSuccess(objectResponse)) {
            return ObjectResponse.failed((String)"400");
        }
        ParkConfig data = (ParkConfig)objectResponse.getData();
        ParkChargeconfig parkChargeconfig = this.parkChargeconfigDao.selectDefaultBill(park.getId());
        if (Objects.nonNull(parkChargeconfig)) {
            FeeParamHolder feeParamHolder = new FeeParamHolder(data, parkChargeconfig);
            ChargeRuleCfgDTO chargeRuleCfgDTO = feeParamHolder.getSChargeRuleObj(parkChargeconfig.getId());
            parkAllInfo.setChargeRuleCfgDTO(chargeRuleCfgDTO);
        }
        parkAllInfo.setParkCode(park.getParkCode());
        parkAllInfo.setParkName(park.getParkName());
        parkAllInfo.setAddress(park.getAddress());
        parkAllInfo.setLat(park.getLat());
        parkAllInfo.setLng(park.getLng());
        parkAllInfo.setLocation(park.getLat());
        parkAllInfo.setFreeSpaceNum(parkFreespace.getFreeSpace());
        return ObjectResponse.success((Object)parkAllInfo);
    }

    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<ParkSpaceInfo>> getParkSpaceList(ParkQuery parkQuery) {
        String redisKey = STATISTICS_TIME + parkQuery.getPageNo() + ":" + parkQuery.getPageSize() + ":" + parkQuery.getCity() + ":" + parkQuery.getCardType() + ":" + parkQuery.getLng() + ":" + parkQuery.getLat() + ":" + parkQuery.getParkCode() + ":" + parkQuery.getParkProperty() + ":" + parkQuery.getRangeLocation() + ":" + parkQuery.getKey();
        com.icetech.common.domain.Page pageInfo = (com.icetech.common.domain.Page)this.redisHandle.cacheObject(redisKey, (TypeReference)new TypeReference<com.icetech.common.domain.Page<ParkSpaceInfo>>(){}, () -> {
            AreaCity areaCity = this.areaCityDao.selectByCode(parkQuery.getCity());
            if (areaCity == null) {
                return null;
            }
            parkQuery.setCityAreaId(areaCity.getId());
            Page parkList = PageHelper.startPage((int)parkQuery.getPageNo(), (int)parkQuery.getPageSize()).doSelectPage(() -> this.parkDao.getParkSpaceList(parkQuery));
            List resultList = parkList.getResult();
            if (CollectionUtil.isNotEmpty((Collection)resultList)) {
                List<Long> parkIds = resultList.stream().map(ParkSpaceInfo::getId).collect(Collectors.toList());
                List<MonthProductDto> monthProduct = this.parkDao.getMonthProduct(null, parkIds, parkQuery.getCardType());
                Map<Long, List<MonthProductDto>> mapList = monthProduct.stream().collect(Collectors.groupingBy(MonthProductDto::getParkId));
                List parkChargeconfigs = this.parkChargeconfigDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkChargeconfig.class).eq(ParkChargeconfig::getDefaultCharge, (Object)1)).eq(ParkChargeconfig::getStatus, (Object)0)).in(ParkChargeconfig::getParkId, parkIds));
                Map<Long, List<ParkChargeconfig>> listMap = parkChargeconfigs.stream().collect(Collectors.groupingBy(ParkChargeconfig::getParkId));
                for (ParkSpaceInfo result : resultList) {
                    List<MonthProductDto> monthProducts = mapList.get(result.getId());
                    if (CollectionUtils.isNotEmpty(monthProducts)) {
                        log.info("[\u67e5\u8be2\u5230\u6708\u5361\u5957\u9910\u4fe1\u606f] parkCode {}", (Object)result.getParkCode());
                        result.setMonthProduct(monthProducts);
                    }
                    try {
                        List<ParkChargeconfig> parkChargeconfigList;
                        if (!Objects.nonNull(listMap.get(result.getId())) || !CollectionUtil.isNotEmpty(parkChargeconfigList = listMap.get(result.getId()))) continue;
                        result.setSBilltype(parkChargeconfigList.get(0).getBilltype());
                    }
                    catch (Exception e) {
                        log.error("[\u67e5\u8be2\u8ba1\u8d39\u4fe1\u606f\u5931\u8d25] parkCode {}", (Object)result.getParkCode(), (Object)e);
                    }
                }
            }
            return com.icetech.common.domain.Page.instance((int)parkList.getPages(), (long)parkList.getTotal(), (List)resultList);
        }, 30000L);
        return ObjectResponse.success((Object)pageInfo);
    }

    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<ParkVisitInfo>> getParkVisitList(ParkQuery parkQuery) {
        String redisKey = STATISTICS_TIME_VISIT + parkQuery.getPageNo() + ":" + parkQuery.getPageSize() + ":" + parkQuery.getCity() + ":" + parkQuery.getCardType() + ":" + parkQuery.getLng() + ":" + parkQuery.getLat() + ":" + parkQuery.getParkCode() + ":" + parkQuery.getParkProperty() + ":" + parkQuery.getRangeLocation() + ":" + parkQuery.getKey();
        com.icetech.common.domain.Page pageInfo = (com.icetech.common.domain.Page)this.redisHandle.cacheObject(redisKey, (TypeReference)new TypeReference<com.icetech.common.domain.Page<ParkVisitInfo>>(){}, () -> {
            AreaCity areaCity = this.areaCityDao.selectByCode(parkQuery.getCity());
            if (areaCity == null) {
                return null;
            }
            parkQuery.setCityAreaId(areaCity.getId());
            Page parkList = PageHelper.startPage((int)parkQuery.getPageNo(), (int)parkQuery.getPageSize()).doSelectPage(() -> this.parkDao.getParkVisitList(parkQuery));
            List resultList = parkList.getResult();
            if (CollectionUtil.isNotEmpty((Collection)resultList)) {
                List parkIds = resultList.stream().map(ParkVisitInfo::getId).collect(Collectors.toList());
                ObjectResponse parkMaps = this.parkFreeSpaceService.getSpacesByPark(parkIds);
                for (ParkVisitInfo result : resultList) {
                    Map data;
                    ParkFreespace parkFreespace;
                    ParkConfig parkConfig = (ParkConfig)this.getParkConfig(result.getId()).getData();
                    result.setIsVisit(parkConfig.getIsVisit());
                    result.setVisitIscharge(parkConfig.getVisitIscharge());
                    result.setVisitInoutNum(parkConfig.getVisitInoutNum());
                    if (!ObjectResponse.isSuccess((Response)parkMaps) || !Objects.nonNull(parkFreespace = (ParkFreespace)(data = (Map)parkMaps.getData()).get(result.getId()))) continue;
                    result.setTotalNum(parkFreespace.getTotalNum());
                    result.setFreeSpace(parkFreespace.getFreeSpace());
                    result.setRealFreeSpace(parkFreespace.getRealFreeSpace());
                }
            }
            return com.icetech.common.domain.Page.instance((int)parkList.getPages(), (long)parkList.getTotal(), (List)resultList);
        }, 30000L);
        return ObjectResponse.success((Object)pageInfo);
    }

    @DS_SLAVE
    public ObjectResponse<List<ParkDistanceInfo>> getParkDistance(ParkDistanceParam param) {
        return ObjectResponse.success(this.parkDao.getParkDistance(param));
    }

    public ObjectResponse<List<Park>> likeParkName(String city, String key) {
        AreaCity areaCity = this.areaCityDao.selectByCode(city);
        return ObjectResponse.success(this.parkDao.selectLikeParkName(areaCity.getId(), key));
    }

    public ObjectResponse<List<ParkInoutdevice>> getInOutDevicesByRegionId(Long regionId, Integer enexType) {
        List<ParkInoutdevice> list = this.parkInoutdeviceDao.findByRegionId(regionId, enexType);
        return ObjectResponse.returnNotFoundIfNull(list);
    }

    public boolean isInterior(Long parkId) {
        ObjectResponse<Park> objectResponse = this.findByParkId(parkId);
        ObjectResponse.notError(objectResponse);
        return NumberUtils.toPrimitive((Integer)((Park)objectResponse.getData()).getIsInterior()) == 1;
    }

    public ObjectResponse<AreaCity> getCityBy(String name) {
        AreaCity areaCity = this.areaCityDao.selectCityByName(name);
        return areaCity == null ? ObjectResponse.failed() : ObjectResponse.success((Object)areaCity);
    }

    public ObjectResponse<com.icetech.common.domain.Page<Park>> getParkPage(Integer pageNo, Integer pageSize, String parkName, Integer cityId) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)pageNo.intValue());
        page.setSize((long)pageSize.intValue());
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Park> parks = this.parkDao.selectParkPage((com.baomidou.mybatisplus.extension.plugins.pagination.Page<Park>)page, parkName, cityId);
        return ObjectResponse.success((Object)com.icetech.common.domain.Page.instance((int)Math.toIntExact(parks.getPages()), (long)parks.getTotal(), (List)parks.getRecords()));
    }

    public ObjectResponse<Void> updateParkInputStatus(Long parkId, Integer inputStatus, String payWay) {
        ObjectResponse<ParkConfig> configObj;
        BasePark park = (BasePark)this.getById(parkId);
        if (park == null) {
            return ObjectResponse.failed((String)"404", (String)"\u8f66\u573a\u4e0d\u5b58\u5728");
        }
        park.setInputStatus(inputStatus);
        this.updateById(park);
        this.removeParkInfoFromRedis(park.getParkCode(), parkId);
        if (StringUtils.isNotEmpty((CharSequence)payWay) && Objects.nonNull(inputStatus) && inputStatus == 4 && ObjectResponse.isSuccess(configObj = this.getParkConfig(parkId))) {
            ParkConfig config = (ParkConfig)configObj.getData();
            ParkConfig update = new ParkConfig();
            update.setId(config.getId());
            update.setIsEpayment(Integer.valueOf(1));
            update.setEPayment(payWay);
            try {
                this.parkConfigDao.updateById(update);
                this.removeParkConfigFromRedis(parkId, park.getParkCode());
                this.sendInfoService.save((Object)new SendInfo(parkId, config.getId(), DownServiceEnum.\u8f66\u573a\u914d\u7f6e.getServiceType()));
            }
            catch (Exception e) {
                log.error("\u652f\u4ed8\u8fdb\u4ef6\u6210\u529f\u4fee\u6539\u9ad8\u7ea7\u914d\u7f6e\u652f\u4ed8\u65b9\u5f0f[{}]\u5e76\u4e0b\u53d1\u9ad8\u7ea7\u914d\u7f6e", (Object)payWay);
            }
        }
        return ObjectResponse.success();
    }

    @Transactional
    public ObjectResponse<Boolean> batchUpdateParkInputStatusByParkId(Map<Long, Integer> statusMap) {
        if (statusMap == null || statusMap.isEmpty()) {
            return ObjectResponse.success();
        }
        List parks = this.list((Wrapper)this.getLambdaQueryWrapper().select(new SFunction[]{BasePark::getId, BasePark::getParkCode}).in(BasePark::getId, statusMap.keySet()));
        if (CollectionUtils.isEmpty((Collection)parks)) {
            return ObjectResponse.success();
        }
        List updateParks = statusMap.entrySet().stream().map(entry -> new BasePark().setId((Long)entry.getKey()).setInputStatus((Integer)entry.getValue())).collect(Collectors.toList());
        boolean result = this.updateBatchById(updateParks);
        parks.forEach(park -> this.removeParkInfoFromRedis(park.getParkCode(), park.getId()));
        return ObjectResponse.success((Object)result);
    }

    public List<InitBstPark> findBstInitPark() {
        return this.parkDao.selectBstInitPark();
    }

    public List<Park> findByParkIds(List<Long> parkIds) {
        return this.parkDao.selectByParkIds(parkIds);
    }

    public ObjectResponse<Park> findByParkName(String parkName) {
        Park park = this.parkDao.selectParkByName(parkName);
        if (Objects.isNull(park)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)park);
    }

    public Integer getParkDataCollection(Long parkId, String parkCode) {
        if (parkId == null && StringUtils.isBlank((CharSequence)parkCode)) {
            return null;
        }
        if (parkId == null) {
            ObjectResponse<ParkConfig> parkConfigObj = this.getParkConfig(parkCode);
            if (!ObjectResponse.isSuccess(parkConfigObj)) {
                return null;
            }
            ParkConfig parkConfig = (ParkConfig)parkConfigObj.getData();
            return parkConfig.getDataCollection();
        }
        ObjectResponse<ParkConfig> parkConfigObj = this.getParkConfig(parkId);
        if (!ObjectResponse.isSuccess(parkConfigObj)) {
            return null;
        }
        ParkConfig parkConfig = (ParkConfig)parkConfigObj.getData();
        return parkConfig.getDataCollection();
    }

    public ObjectResponse<AreaDistrict> getDistrictById(Integer districtId) {
        AreaDistrict areaDistrict = this.areaDistrictDao.selectById(districtId);
        return Objects.isNull(areaDistrict) ? ObjectResponse.failed((String)"404") : ObjectResponse.success((Object)areaDistrict);
    }

    public ObjectResponse updateParkSpace(ParkFreespace data) {
        return this.parkFreeSpaceService.updateByPark(data) ? ObjectResponse.success() : ObjectResponse.failed();
    }

    public List<BasePark> getParkListByParkCodes(List<String> parkCods) {
        return this.parkDao.selectList((Wrapper)Wrappers.lambdaQuery(BasePark.class).in(BasePark::getParkCode, parkCods));
    }
}

