/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.basics.service.dictionary.impl;

import com.google.common.collect.Lists;
import com.icetech.basics.api.DictionaryItemService;
import com.icetech.basics.dao.dictionary.DictionaryItemDao;
import com.icetech.basics.domain.dto.DictionaryItemDto;
import com.icetech.basics.domain.entity.dictionary.DictionaryItem;
import com.icetech.cloudcenter.domain.constants.DictionaryTypeEnum;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="dictionaryItemService")
public class DictionaryItemServiceImpl
implements DictionaryItemService {
    private static final Logger log = LoggerFactory.getLogger(DictionaryItemServiceImpl.class);
    @Autowired
    private DictionaryItemDao dictionaryItemDao;

    public ObjectResponse<List<DictionaryItemDto>> getOpenReasonList(Integer type) {
        try {
            if (type == 1) {
                return this.findListByTypeId(DictionaryTypeEnum.\u5165\u573a\u5f00\u95f8\u539f\u56e0.getType());
            }
            return this.findListByTypeId(DictionaryTypeEnum.\u79bb\u573a\u5f00\u95f8\u539f\u56e0.getType());
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u5f00\u95f8\u539f\u56e0\u63a5\u53e3]\u5f02\u5e38: {}.", (Object)e.getMessage(), (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<List<DictionaryItemDto>> findListByTypeId(Integer type) {
        List<DictionaryItem> dictionaryItems = this.dictionaryItemDao.selectByDictionaryType(type);
        if (CollectionUtils.isEmpty(dictionaryItems)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        ArrayList list = Lists.newArrayList();
        dictionaryItems.forEach(dictionaryItem -> {
            DictionaryItemDto dictionaryItemDto = new DictionaryItemDto();
            dictionaryItemDto.setValue(Integer.valueOf(dictionaryItem.getValue()));
            dictionaryItemDto.setText(dictionaryItem.getText());
            list.add(dictionaryItemDto);
        });
        return ObjectResponse.success((Object)list);
    }

    public ObjectResponse<DictionaryItemDto> findOneItem(Integer typeId, String text, Integer value) {
        DictionaryItem dictionaryItem = this.dictionaryItemDao.selectOneItem(typeId, text, value);
        if (dictionaryItem == null) {
            return ObjectResponse.failed((String)"404");
        }
        DictionaryItemDto dictionaryItemDto = new DictionaryItemDto();
        dictionaryItemDto.setText(dictionaryItem.getText());
        dictionaryItemDto.setValue(Integer.valueOf(dictionaryItem.getValue()));
        return ObjectResponse.success((Object)dictionaryItemDto);
    }
}

