/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.basics.service.device.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.VipTypeDao;
import com.icetech.basics.dao.device.HeartbeatOfflineDao;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.dao.device.ParkDevrecordDao;
import com.icetech.basics.dao.device.ProduceModelDao;
import com.icetech.basics.dao.dictionary.DictionaryItemDao;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.device.HeartbeatOffline;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.device.ParkDevrecord;
import com.icetech.basics.domain.entity.device.ProduceModel;
import com.icetech.basics.domain.entity.dictionary.DictionaryItem;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.device.ParkDevRecordService;
import com.icetech.basics.service.device.impl.HeartbeatOfflineServiceImpl;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.park.IParkTrusteeshipService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.domain.device.ParkDeviceInfo;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.park.ParkChannelInfo;
import com.icetech.cloudcenter.domain.park.ParkChannelListPage;
import com.icetech.cloudcenter.domain.park.ParkInoutDeviceInfo;
import com.icetech.cloudcenter.domain.request.DeviceListRequest;
import com.icetech.cloudcenter.domain.request.EzoVideoRequest;
import com.icetech.cloudcenter.domain.request.QueryDeviceRequest;
import com.icetech.cloudcenter.domain.response.DeviceListDTO;
import com.icetech.cloudcenter.domain.response.ParkDeviceDto;
import com.icetech.cloudcenter.domain.vo.InOutYuneasyInfoVo;
import com.icetech.cloudcenter.domain.vo.ParkDeviceVo;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.HttpTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.SpringUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.ParkTrusteeship;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.service.third.SendInfoServiceImpl;
import com.icetech.third.utils.RedisUtils;
import com.icetech.user.dao.EnUserDao;
import com.icetech.user.domain.entity.user.EnUser;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="parkDeviceService")
public class ParkDeviceServiceImpl
implements ParkDeviceService {
    private static final Logger log = LoggerFactory.getLogger(ParkDeviceServiceImpl.class);
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private ParkDevrecordDao parkDevrecordDao;
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private EnUserDao enUserDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private MqPushService mqPushService;
    @Autowired
    private DictionaryItemDao dictionaryItemDao;
    @Resource
    private RedisHandle redisHandle;
    @Autowired
    private VipTypeDao vipTypeDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private ParkServiceImpl parkService;
    @Resource
    private ProduceModelDao produceModelDao;
    @Autowired
    private HeartbeatOfflineDao heartbeatOfflineDao;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkDevRecordService parkDevRecordService;
    @Autowired
    private HeartbeatOfflineServiceImpl heartbeatOfflineService;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    private Integer timeOut = 5;
    private String baseVideoUrl = "https://open.ys7.com/ezopen/h5/iframe?url=ezopen://%s@open.ys7.com/%s/1.live&autoplay=1&accessToken=%s";

    public ObjectResponse<List<ParkDeviceDto>> getDeviceByUser(Integer userId, Integer type) {
        ArrayList<ParkDeviceDto> list = new ArrayList<ParkDeviceDto>();
        String parkids = this.parkDao.selectParkOrgByUserId(userId, 2);
        if (parkids == null) {
            return ObjectResponse.success(list);
        }
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListBytype(type);
        for (int i = 0; i < parkDevices.size(); ++i) {
            ParkDevice parkDevice = parkDevices.get(i);
            if (!this.checkParkid(parkids, parkDevice.getParkId())) continue;
            ParkDeviceDto parkDeviceDto = new ParkDeviceDto();
            Park park = (Park)this.parkService.findByParkId(parkDevice.getParkId()).getData();
            parkDeviceDto.setParkName(park.getParkName());
            parkDeviceDto.setDeviceCode(parkDevice.getSerialNumber());
            ObjectResponse<ParkInoutdevice> parkInoutdeviceResp = this.parkService.getInoutDeviceById(parkDevice.getChannelId().longValue());
            if (!ObjectResponse.isSuccess(parkInoutdeviceResp)) continue;
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)parkInoutdeviceResp.getData();
            if (parkInoutdevice != null) {
                parkDeviceDto.setAisleName(parkInoutdevice.getInandoutName());
            }
            list.add(parkDeviceDto);
        }
        return ObjectResponse.success(list);
    }

    public ObjectResponse<List<ParkDevice>> getDeviceByParkChannel(Long parkId, Long channelId) {
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListByParkChannel(parkId, channelId);
        if (parkDevices == null || parkDevices.size() == 0) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success(parkDevices);
    }

    public ObjectResponse<ParkDevice> getDeviceByParkIdDevice(Long parkId, String deviceNo) {
        ParkDevice parkDevice = new ParkDevice();
        parkDevice.setParkId(parkId);
        parkDevice.setDeviceNo(deviceNo);
        ParkDevice parkDeviceRet = this.parkDeviceDao.selectByParam(parkDevice);
        if (parkDeviceRet != null) {
            return ObjectResponse.success((Object)parkDeviceRet);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<ParkDevice> getDeviceBySerialNumber(String serialNumber) {
        ParkDevice parkDeviceRet = this.cacheDeviceBySerialNumber(serialNumber);
        if (parkDeviceRet != null) {
            return ObjectResponse.success((Object)parkDeviceRet);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ParkDevice cacheDeviceBySerialNumber(String serialNumber) {
        String cacheKye = "park:device:serial_number:" + serialNumber;
        return (ParkDevice)this.redisHandle.cacheObject(cacheKye, ParkDevice.class, () -> {
            ParkDevice param = new ParkDevice();
            param.setSerialNumber(serialNumber);
            return this.parkDeviceDao.selectByParam(param);
        }, 604800000L);
    }

    public ObjectResponse<List<ParkDevice>> getDeviceByChannel(Long parkId, String channelCode, Integer type) {
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListByChannel(parkId, channelCode, type);
        if (parkDevices != null && parkDevices.size() > 0) {
            return ObjectResponse.success(parkDevices);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse addDevice(ParkDevice parkDevice) {
        int insert = this.parkDeviceDao.insert(parkDevice);
        if (insert > 0) {
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)"500");
    }

    public ObjectResponse updateDevice(ParkDevice parkDevice) {
        parkDevice.setDelFlag(null);
        int update = this.parkDeviceDao.updateById(parkDevice);
        if (update > 0) {
            String cacheKye = "park:device:serial_number:" + parkDevice.getSerialNumber();
            this.redisTemplate.delete((Object)cacheKye);
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)"500");
    }

    public ObjectResponse<ParkDevice> selectById(ParkDevice parkDevice) {
        ParkDevice device = this.parkDeviceDao.selectByParam(parkDevice);
        if (Objects.isNull(device)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)device);
    }

    public ObjectResponse<List<ParkDevice>> getDevicesByParkChannel(Long parkId, Long[] channelIds, Integer type) {
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDevicesByParkChannel(parkId, Arrays.asList(channelIds), type);
        if (parkDevices.size() > 0) {
            return ObjectResponse.success(parkDevices);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<com.icetech.common.domain.Page<DeviceListDTO>> upgradeDeviceList(DeviceListRequest deviceListRequest) {
        if (deviceListRequest == null) {
            deviceListRequest = new DeviceListRequest();
        }
        String productModel = null;
        if (deviceListRequest.getProductModelId() != null) {
            DictionaryItem dictionaryItem = this.dictionaryItemDao.selectOneItem(8, null, deviceListRequest.getProductModelId());
            if (dictionaryItem == null) {
                return ObjectResponse.failed((String)"404", (String)"\u8bbe\u5907\u578b\u53f7\u4e0d\u5b58\u5728");
            }
            productModel = dictionaryItem.getText();
        }
        PageHelper.startPage((int)deviceListRequest.getPageNo(), (int)deviceListRequest.getPageSize());
        List<DeviceListDTO> deviceListRespons = this.parkDeviceDao.selectUpgradeList(deviceListRequest.getParkIdList(), deviceListRequest.getDeviceType(), deviceListRequest.getDeviceStatus(), productModel, deviceListRequest.getSn());
        if (CollectionUtil.isEmpty(deviceListRespons)) {
            return ObjectResponse.failed((String)"404");
        }
        PageInfo pageInfo = new PageInfo(deviceListRespons);
        com.icetech.common.domain.Page page = new com.icetech.common.domain.Page();
        page.setRows(deviceListRespons);
        page.setTotal(Long.valueOf(pageInfo.getTotal()));
        page.setTotalPage(Integer.valueOf(pageInfo.getPages()));
        return ObjectResponse.success((Object)page);
    }

    public ObjectResponse<List<ProduceModel>> getProduceModelList() {
        List produceModels = this.redisHandle.cacheList("produce:model", ProduceModel.class, () -> this.produceModelDao.selectList((Wrapper)Wrappers.emptyWrapper()), 604800000L);
        return ObjectResponse.success((Object)produceModels);
    }

    public ParkDevice getDeviceByParkIdAndChannelId(Long parkId, Long channelId) {
        return this.parkDeviceDao.selectDeviceByAisleCode(parkId, channelId);
    }

    public ObjectResponse deviceStatusUpdate(String serialNumber, Long eventTime, Integer status, Integer deviceType) {
        ObjectResponse<ParkDevice> deviceObjectResponse = this.getDeviceBySerialNumber(serialNumber);
        if (!ObjectResponse.isSuccess(deviceObjectResponse) || !((ParkDevice)deviceObjectResponse.getData()).getType().equals(deviceType)) {
            log.warn("[\u8bbe\u5907\u72b6\u6001\u53d8\u5316] serialNumber[{}], \u8bbe\u5907\u4e0d\u5b58\u5728", (Object)serialNumber);
            return ObjectResponse.failed((String)"404");
        }
        ParkDevice parkDevice = (ParkDevice)deviceObjectResponse.getData();
        int currStatus = parkDevice.getStatus();
        if (status == 2 && currStatus != 2) {
            this.modifyStatus(parkDevice.getParkId(), parkDevice.getDeviceNo(), 2, "\u4e0b\u7ebf", DateTools.unixTimestamp());
            HeartbeatOffline heartbeatOffline = new HeartbeatOffline();
            heartbeatOffline.setParkId(parkDevice.getParkId());
            String key = null;
            if (deviceType == 1) {
                key = "p2c:heartbeat:time";
            } else if (deviceType == 5) {
                key = "p2r:heartbeat:time";
            } else if (deviceType == 8) {
                key = "itc:heartbeat:time";
            } else if (deviceType == 9) {
                key = "mor:heartbeat:time";
            }
            if (key != null) {
                Long lastHeartbeatTime = eventTime != null ? eventTime : (Long)this.redisUtils.hGet(key, serialNumber, Long.class);
                heartbeatOffline.setLastConnectionTime(Long.valueOf(lastHeartbeatTime == null ? DateTools.unixTimestamp() : lastHeartbeatTime));
                heartbeatOffline.setDeviceNo(parkDevice.getDeviceNo());
                this.heartbeatOfflineDao.insert(heartbeatOffline);
            }
        }
        if (status == 1 && currStatus != 1) {
            this.modifyStatus(parkDevice.getParkId(), parkDevice.getDeviceNo(), 1, null, null);
            HeartbeatOffline ret = this.heartbeatOfflineDao.selectLast(parkDevice.getParkId(), parkDevice.getDeviceNo());
            if (ret != null) {
                ret.setReconnectTime(eventTime);
                ret.setOffTime(Long.valueOf(eventTime - ret.getLastConnectionTime()));
                this.heartbeatOfflineDao.updateById(ret);
            }
        }
        return ObjectResponse.success();
    }

    private boolean checkParkid(String parkids, long parkid) {
        String[] userpark = parkids.split(",");
        for (int i = 0; i < userpark.length; ++i) {
            int integer = Integer.parseInt(userpark[i]);
            if ((long)integer != parkid) continue;
            return true;
        }
        return false;
    }

    public ObjectResponse operation(String deviceCode, Long parkId) {
        try {
            String accessToken;
            ParkDevice parkDevice2;
            boolean isDelete = false;
            ParkDevice parkDevice = new ParkDevice();
            parkDevice.setDeviceNo(deviceCode);
            parkDevice.setParkId(parkId);
            ParkDevice parkDevice1 = this.parkDeviceDao.selectByParam(parkDevice);
            if (Objects.isNull(parkDevice1) && !Objects.isNull(parkDevice2 = this.parkDeviceDao.selectDeleteById(parkDevice))) {
                parkDevice1 = parkDevice2;
                isDelete = true;
            }
            String cacheKye = "park:device:serial_number:" + parkDevice1.getSerialNumber();
            EnUser enUser = this.enUserDao.selectById(parkDevice1.getEzopenId().intValue());
            if (Objects.isNull(enUser)) {
                return ObjectResponse.failed((String)"404", (String)"\u8d26\u6237\u9519\u8bef");
            }
            String getTokenBaseUrl = "https://open.ys7.com/api/lapp/token/get?";
            String getDeviceBaseUrl = "https://open.ys7.com/api/lapp/device/info?";
            String addDeviceBaseUrl = "https://open.ys7.com/api/lapp/device/add?";
            String delTokenBaseUrl = "https://open.ys7.com/api/lapp/device/delete?";
            String offDeviceBaseUrl = "https://open.ys7.com/api/lapp/device/encrypt/off?";
            String enUrl = "https://open.ys7.com/ezopen/h5/iframe?url=ezopen://" + parkDevice1.getVerCode() + "@open.ys7.com/" + parkDevice1.getSerialNumber() + "/1.live&autoplay=1&accessToken=";
            String tokenRes = HttpTools.post((String)(getTokenBaseUrl + "appKey=" + enUser.getAppKey() + "&appSecret=" + enUser.getSecret()));
            Map tmap = (Map)JSON.parse((String)tokenRes);
            if ("200".equals(tmap.get("code"))) {
                String data = tmap.get("data").toString();
                Map map = (Map)JSON.parse((String)data);
                accessToken = map.get("accessToken").toString();
                log.info("\u83b7\u53d6\u5230taoken\uff1a{}", (Object)accessToken);
                if (isDelete) {
                    String post = HttpTools.post((String)(delTokenBaseUrl + "accessToken=" + accessToken + "&deviceSerial=" + parkDevice1.getSerialNumber()));
                    log.info("[\u76d1\u63a7\u76f8\u673a\u5220\u9664\u6210\u529f\uff0c\u8bbe\u5907\u5e8f\u5217\u53f7\uff1a] [{}]", (Object)parkDevice1.getSerialNumber());
                    return ObjectResponse.success();
                }
                String deviceRes = HttpTools.post((String)(getDeviceBaseUrl + "accessToken=" + accessToken + "&deviceSerial=" + parkDevice1.getSerialNumber()));
                Map dmap = (Map)JSON.parse((String)deviceRes);
                if ("200".equals(dmap.get("code"))) {
                    String off;
                    Map omap;
                    String data1 = dmap.get("data").toString();
                    Map dsmap = (Map)JSON.parse((String)data1);
                    parkDevice1.setStatus(Integer.valueOf(1));
                    if (Integer.parseInt(dsmap.get("status").toString()) == 0) {
                        parkDevice1.setStatus(Integer.valueOf(2));
                    }
                    if (Integer.parseInt(dsmap.get("isEncrypt").toString()) == 1 && "20010".equals((omap = (Map)JSON.parse((String)(off = HttpTools.post((String)(offDeviceBaseUrl + "accessToken=" + accessToken + "&deviceSerial=" + parkDevice1.getSerialNumber() + "&validateCode=" + parkDevice1.getVerCode()))))).get("code"))) {
                        log.info("\u8bf7\u6c42\u8424\u77f3\u7ed3\u679c[{}], sn[{}]", (Object)off, (Object)parkDevice1.getSerialNumber());
                        ParkDevrecord parkDevrecord = new ParkDevrecord();
                        parkDevrecord.setDeviceId(parkDevice1.getId());
                        parkDevrecord.setStatus(Integer.valueOf(3));
                        parkDevrecord.setWrongTime(new Date());
                        parkDevrecord.setReason(omap.get("msg").toString());
                        this.parkDevrecordDao.insert(parkDevrecord);
                        parkDevice1.setStatus(Integer.valueOf(2));
                        parkDevice1.setEndUpdatetime(new Date());
                    }
                    enUrl = enUrl + accessToken;
                    parkDevice1.setVideoUrl(enUrl);
                    ParkDevice parkDevice22 = parkDevice1;
                    this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.parkDeviceDao.updateById(parkDevice22)));
                    this.redisTemplate.delete((Object)cacheKye);
                    log.info("[\u76d1\u63a7\u76f8\u673a\u66f4\u65b0\u6210\u529f]\uff0c\u8bbe\u5907\u5e8f\u5217\u53f7[{}]\uff0c\u64ad\u653e\u5730\u5740\u5df2\u66f4\u65b0[{}]", (Object)parkDevice1.getSerialNumber(), (Object)parkDevice1.getVideoUrl());
                    return ObjectResponse.success();
                }
                String addRes = HttpTools.post((String)(addDeviceBaseUrl + "accessToken=" + accessToken + "&deviceSerial=" + parkDevice1.getSerialNumber() + "&validateCode=" + parkDevice1.getVerCode()));
                Map amap = (Map)JSON.parse((String)addRes);
                if ("200".equals(amap.get("code"))) {
                    parkDevice1.setStatus(Integer.valueOf(1));
                    parkDevice1.setEndUpdatetime(new Date());
                    log.info("[\u76d1\u63a7\u76f8\u673a\u6dfb\u52a0\u6210\u529f] \u8bbe\u5907\u5e8f\u5217\u53f7[{}]\uff0c\u64ad\u653e\u5730\u5740\u5df2\u66f4\u65b0[{}]", (Object)parkDevice1.getSerialNumber(), (Object)parkDevice1.getVideoUrl());
                } else {
                    ParkDevrecord parkDevrecord = new ParkDevrecord();
                    parkDevrecord.setDeviceId(parkDevice1.getId());
                    parkDevrecord.setStatus(Integer.valueOf(2));
                    parkDevrecord.setWrongTime(new Date());
                    parkDevrecord.setReason(amap.get("msg").toString());
                    this.parkDevrecordDao.insert(parkDevrecord);
                    parkDevice1.setStatus(Integer.valueOf(2));
                    parkDevice1.setEndUpdatetime(new Date());
                    log.info("[\u76d1\u63a7\u76f8\u673a\u6dfb\u52a0\u5931\u8d25] \u8bbe\u5907\u5e8f\u5217\u53f7[{}]\uff0c\u5931\u8d25\u539f\u56e0[{}]", (Object)parkDevice1.getSerialNumber(), amap.get("msg"));
                }
            } else {
                ParkDevrecord parkDevrecord = new ParkDevrecord();
                parkDevrecord.setDeviceId(parkDevice1.getId());
                parkDevrecord.setStatus(Integer.valueOf(2));
                parkDevrecord.setWrongTime(new Date());
                parkDevrecord.setReason("\u83b7\u53d6\u8d26\u6237TOKEN\u5931\u8d25");
                this.parkDevrecordDao.insert(parkDevrecord);
                return ObjectResponse.failed((String)"500", (String)"\u83b7\u53d6\u8d26\u6237TOKEN\u5931\u8d25");
            }
            enUrl = enUrl + accessToken;
            parkDevice1.setVideoUrl(enUrl);
            ParkDevice parkDevice23 = parkDevice1;
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.parkDeviceDao.updateById(parkDevice23)));
            this.redisTemplate.delete((Object)cacheKye);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5931\u8d25: {}. deviceCode[{}], parkId[{}]", new Object[]{e.getMessage(), deviceCode, parkId, e});
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<InOutYuneasyInfoVo> getInOutYuneasyInfoVo(Long parkId, String aisleCode) {
        ArrayList<Integer> deviceType = new ArrayList<Integer>();
        deviceType.add(1);
        deviceType.add(4);
        deviceType.add(6);
        ArrayList<String> aisleCodes = new ArrayList<String>();
        aisleCodes.add(aisleCode);
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceList(parkId, aisleCodes, null, deviceType);
        if (CollectionUtils.isEmpty(parkDevices)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        InOutYuneasyInfoVo inOutYuneasyInfoVo = new InOutYuneasyInfoVo();
        parkDevices.forEach(t -> {
            if (t.getType() == 1) {
                inOutYuneasyInfoVo.setSerialNumber(t.getSerialNumber());
            }
            if (t.getType() == 4 && Objects.nonNull(t.getVoicevendorType()) && t.getVoicevendorType() == 1) {
                inOutYuneasyInfoVo.setYuneasyNumber(t.getSerialNumber());
            }
        });
        return ObjectResponse.success((Object)inOutYuneasyInfoVo);
    }

    public ObjectResponse enDeviceStatus() {
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListBytype(6);
        if (parkDevices.size() == 0) {
            return ObjectResponse.success();
        }
        String getDeviceBaseUrl = "https://open.ys7.com/api/lapp/device/info?";
        for (ParkDevice parkDevice : parkDevices) {
            EnUser enUser;
            if (Objects.isNull(parkDevice.getEzopenId()) || Objects.isNull(enUser = this.enUserDao.selectById(parkDevice.getEzopenId().intValue()))) continue;
            String redisKey = "ysy:token:" + parkDevice.getParkId() + ":" + parkDevice.getDeviceNo();
            String accessToken = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
            log.info("token \u5185\u5bb9 [{}]", (Object)accessToken);
            if (!TextUtils.isEmpty((CharSequence)accessToken)) {
                String videoUrl = parkDevice.getVideoUrl();
                if (!videoUrl.contains("accessToken")) continue;
                if (!parkDevice.getVideoUrl().contains(accessToken)) {
                    parkDevice.setVideoUrl(videoUrl.substring(0, videoUrl.indexOf("accessToken=")) + "accessToken=" + accessToken);
                }
                String deviceRes = HttpTools.post((String)(getDeviceBaseUrl + "accessToken=" + accessToken + "&deviceSerial=" + parkDevice.getSerialNumber()));
                log.info("\u66f4\u65b0\u8424\u77f3\u4e91\u8bbe\u5907\u72b6\u6001 [{}]", (Object)deviceRes);
                Map dmap = (Map)JSON.parse((String)deviceRes);
                if ("200".equals(dmap.get("code"))) {
                    String data1 = dmap.get("data").toString();
                    Map dsmap = (Map)JSON.parse((String)data1);
                    this.modifyStatus(parkDevice.getParkId(), parkDevice.getDeviceNo(), Integer.parseInt(dsmap.get("status").toString()) == 1 ? 1 : 2, Integer.parseInt(dsmap.get("status").toString()) == 1 ? "\u8424\u77f3\u5728\u7ebf" : "\u8424\u77f3\u79bb\u7ebf", System.currentTimeMillis() / 1000L);
                    continue;
                }
                String msg = String.valueOf(dmap.get("msg"));
                if (msg != null && (msg.contains("Data error") || msg.contains("\u670d\u52a1\u5668\u9519\u8bef"))) {
                    return ObjectResponse.success();
                }
                this.modifyStatus(parkDevice.getParkId(), parkDevice.getDeviceNo(), 2, msg, System.currentTimeMillis() / 1000L);
                continue;
            }
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.updateConsoleTokenForRedis(parkDevice)));
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<String> updateConsoleTokenForRedis(ParkDevice parkDeviceFind) {
        if (Objects.isNull(parkDeviceFind)) {
            return ObjectResponse.failed((String)"404", (String)"\u672a\u627e\u5230\u8bbe\u5907");
        }
        log.info("updateConsoleTokenForRedis  >  {},{},{}", new Object[]{parkDeviceFind.getDeviceNo(), parkDeviceFind.getParkId(), parkDeviceFind.getVerCode()});
        if (TextUtils.isEmpty((CharSequence)parkDeviceFind.getVerCode())) {
            return ObjectResponse.failed((String)"400", (String)"VerCode \u4e3a\u7a7a");
        }
        EnUser enUser = this.enUserDao.selectById(parkDeviceFind.getEzopenId().intValue());
        if (Objects.isNull(enUser)) {
            return ObjectResponse.failed((String)"404", (String)"\u8d26\u6237\u9519\u8bef");
        }
        String getTokenBaseUrl = "https://open.ys7.com/api/lapp/token/get?";
        String tokenRes = HttpTools.post((String)(getTokenBaseUrl + "appKey=" + enUser.getAppKey() + "&appSecret=" + enUser.getSecret()));
        String accessToken = "";
        log.info("updateConsoleTokenForRedis  >  {}", (Object)tokenRes);
        Map tmap = (Map)JSON.parse((String)tokenRes);
        if ("200".equals(tmap.get("code"))) {
            String data = tmap.get("data").toString();
            Map map = (Map)JSON.parse((String)data);
            accessToken = map.get("accessToken").toString();
            log.info("\u83b7\u53d6\u5230token\uff1a{}", (Object)accessToken);
            String tokenKey = "ysy:token:" + parkDeviceFind.getParkId() + ":" + parkDeviceFind.getDeviceNo();
            this.redisTemplate.opsForValue().set((Object)tokenKey, (Object)accessToken, (long)this.timeOut.intValue(), TimeUnit.DAYS);
            String oldVideoUrl = parkDeviceFind.getVideoUrl();
            if (TextUtils.isEmpty((CharSequence)oldVideoUrl)) {
                parkDeviceFind.setVideoUrl(String.format(this.baseVideoUrl, parkDeviceFind.getVerCode(), parkDeviceFind.getSerialNumber(), accessToken));
            } else {
                parkDeviceFind.setVideoUrl(oldVideoUrl.substring(0, oldVideoUrl.indexOf("accessToken=")) + "accessToken=" + accessToken);
            }
            this.parkDeviceDao.updateById(parkDeviceFind);
            String cacheKye = "park:device:serial_number:" + parkDeviceFind.getSerialNumber();
            this.redisTemplate.delete((Object)cacheKye);
            return ObjectResponse.success((Object)accessToken);
        }
        return ObjectResponse.failed((String)"token \u66f4\u65b0\u5931\u8d25");
    }

    public ObjectResponse updateAccessToken(List<Map<String, String>> maps) {
        String baseurl = "https://open.ys7.com/api/lapp/token/get?";
        try {
            List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListBytype(6);
            if (parkDevices.size() == 0) {
                log.info("\u6ca1\u6709\u76d1\u63a7\u76f8\u673a");
                return ObjectResponse.success();
            }
            List<EzoVideoRequest> list = this.convertListMap2ListBean(maps, EzoVideoRequest.class);
            for (int i = 0; i < list.size(); ++i) {
                String data;
                Map map;
                EzoVideoRequest ezoVideoRequest = list.get(i);
                String post = HttpTools.post((String)(baseurl + "appKey=" + ezoVideoRequest.getAppKey() + "&appSecret=" + ezoVideoRequest.getSecret()));
                log.info("\u8bf7\u6c42\u5730\u5740{},\u8fd4\u56de{}", (Object)(baseurl + "appKey=" + ezoVideoRequest.getAppKey() + "&appSecret=" + ezoVideoRequest.getSecret()), (Object)post);
                String accessToken = "";
                Map map1 = (Map)JSON.parse((String)post);
                if (!"200".equals(map1.get("code")) || !this.isTokenTimeOut(parkDevices, accessToken = (map = (Map)JSON.parse((String)(data = map1.get("data").toString()))).get("accessToken").toString())) continue;
                this.updateToken(parkDevices, ezoVideoRequest, accessToken);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u8424\u77f3\u4e91token\u5f02\u5e38: {}. maps[{}]", new Object[]{e.getMessage(), maps, e});
        }
        return ObjectResponse.success();
    }

    public ObjectResponse reportDeviceStatus(String deviceNo, Integer deviceType, Integer state) {
        if (StringUtils.isEmpty((CharSequence)deviceNo)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
        }
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectWayDetailByvid(deviceNo);
        for (int i = 0; i < parkDevices.size(); ++i) {
            ParkDevice parkDevice = parkDevices.get(i);
            this.modifyStatus(parkDevice.getParkId(), parkDevice.getDeviceNo(), state, "", System.currentTimeMillis() / 1000L);
        }
        return ObjectResponse.success();
    }

    public List<ParkDevice> getDeviceListByParkId(Long parkId) {
        return this.parkDeviceDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkDevice.class).eq(ParkDevice::getParkId, (Object)parkId)).eq(ParkDevice::getDelFlag, (Object)0));
    }

    public ObjectResponse<List<ParkDevice>> getDeviceListByParkIdAndType(Long parkId, Integer type) {
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListByParkIdAndType(parkId, type);
        if (CollectionUtils.isEmpty(parkDevices)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkDevices);
    }

    public ObjectResponse<List<ParkDevice>> getDeviceListByChannelId(Long channelId, Integer type) {
        if (channelId == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListByChannelId(channelId, type);
        if (CollectionUtils.isEmpty(parkDevices)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkDevices);
    }

    public ObjectResponse<List<ParkDevice>> getDeviceListByChannelIds(List<Long> channelIds, Integer type) {
        if (CollectionUtils.isEmpty(channelIds)) {
            return ObjectResponse.failed((String)"404");
        }
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListByChannelIds(channelIds, type);
        if (CollectionUtils.isEmpty(parkDevices)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkDevices);
    }

    public ObjectResponse<List<ParkDevice>> getDeviceListByParkChannelId(Long parkId, Integer channelId, int deviceType) {
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListByParkIdAndChannelId(parkId, channelId, deviceType);
        if (parkDevices != null && parkDevices.size() > 0) {
            return ObjectResponse.success(parkDevices);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<ParkDevice>> getDeviceListByParkRegionId(Long parkId, Integer regionId, int deviceType) {
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListByParkIdAndRegionId(parkId, regionId, deviceType);
        if (parkDevices != null && parkDevices.size() > 0) {
            return ObjectResponse.success(parkDevices);
        }
        return ObjectResponse.failed((String)"404");
    }

    private void updateToken(List<ParkDevice> parkDevices, EzoVideoRequest ezoVideoRequest, String accessToken) {
        String[] split = ezoVideoRequest.getCamera().split(",");
        for (int i = 0; i < split.length; ++i) {
            for (int j = 0; j < parkDevices.size(); ++j) {
                String videoUrl;
                ParkDevice device = parkDevices.get(j);
                if (!split[i].equals(device.getSerialNumber()) || !(videoUrl = device.getVideoUrl()).contains("accessToken")) continue;
                device.setVideoUrl(videoUrl.substring(0, videoUrl.indexOf("accessToken=")) + "accessToken=" + accessToken);
                this.parkDeviceDao.updateById(device);
                String cacheKye = "park:device:serial_number:" + device.getSerialNumber();
                this.redisTemplate.delete((Object)cacheKye);
                log.info("\u8bbe\u5907\u5e8f\u5217\u53f7{}\u5df2\u66f4\u65b0token{},\u539f\u5730\u5740{},", new Object[]{split[i], accessToken, videoUrl});
            }
        }
    }

    private ParkDevice getDevice(List<ParkDevice> parkDevices, String serialNumber) {
        for (int i = 0; i < parkDevices.size(); ++i) {
            ParkDevice parkDevice = parkDevices.get(i);
            if (!serialNumber.equals(parkDevice.getSerialNumber())) continue;
            return parkDevice;
        }
        return null;
    }

    private boolean isTokenTimeOut(List<ParkDevice> parkDevices, String token) {
        boolean key = true;
        for (int j = 0; j < parkDevices.size(); ++j) {
            ParkDevice parkDevice = parkDevices.get(j);
            String videoUrl = parkDevice.getVideoUrl();
            if (StringUtils.isEmpty((CharSequence)videoUrl) || !videoUrl.contains(token)) continue;
            key = false;
            break;
        }
        return key;
    }

    @DS_SLAVE
    public ObjectResponse<Map<String, Object>> countDeviceAlarmList(QueryDeviceRequest queryDeviceRequest) {
        try {
            String[] split = queryDeviceRequest.getParkCode().split(",");
            String parkid = this.parkDao.selectByCodes(split);
            if (parkid != null && parkid.endsWith(",")) {
                parkid = parkid.substring(0, parkid.length() - 1);
            }
            int count = this.parkDevrecordDao.countDeviceAlarmList(parkid, queryDeviceRequest.getDeviceNo(), Objects.isNull(queryDeviceRequest.getStartTime()) ? null : DateTools.getFormat((Date)queryDeviceRequest.getStartTime()), Objects.isNull(queryDeviceRequest.getEndTime()) ? null : DateTools.getFormat((Date)queryDeviceRequest.getEndTime()), queryDeviceRequest.getDeviceType());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("count", count);
            return ObjectResponse.success(map);
        }
        catch (Exception e) {
            log.error("[\u83b7\u53d6\u8bbe\u5907\u62a5\u8b66\u4fe1\u606f]\u63a5\u53e3\u5f02\u5e38: {}. queryDeviceRequest[{}]", new Object[]{e.getMessage(), queryDeviceRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    @DS_SLAVE
    public ObjectResponse<List<ParkDevrecord>> getDeviceAlarmList(QueryDeviceRequest queryDeviceRequest) {
        List<Object> parkDevrecords = new ArrayList();
        try {
            if (StringUtils.isBlank((CharSequence)queryDeviceRequest.getParkCode())) {
                return ObjectResponse.failed((String)"404");
            }
            String[] split = queryDeviceRequest.getParkCode().split(",");
            String parkid = this.parkDao.selectByCodes(split);
            PageHelper.startPage((int)queryDeviceRequest.getPageNo(), (int)queryDeviceRequest.getPageSize());
            parkDevrecords = this.parkDevrecordDao.selectDeviceAlarmList(parkid, queryDeviceRequest.getDeviceNo(), Objects.isNull(queryDeviceRequest.getStartTime()) ? null : DateTools.getFormat((Date)queryDeviceRequest.getStartTime()), Objects.isNull(queryDeviceRequest.getEndTime()) ? null : DateTools.getFormat((Date)queryDeviceRequest.getEndTime()), queryDeviceRequest.getDeviceType());
        }
        catch (Exception e) {
            log.error("[\u83b7\u53d6\u8bbe\u5907\u62a5\u8b66\u4fe1\u606f]\u63a5\u53e3\u5f02\u5e38: {}. queryDeviceRequest[{}]", new Object[]{e.getMessage(), queryDeviceRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
        return ObjectResponse.success(parkDevrecords);
    }

    @SentinelResource(value="ParkDevice.getDeviceList", fallback="handleFallback")
    public ObjectResponse<List<ParkDeviceDto>> getDeviceList(QueryDeviceRequest queryDeviceRequest) {
        try {
            Park park = (Park)this.parkService.findByParkCode(queryDeviceRequest.getParkCode()).getData();
            PageHelper.startPage((int)queryDeviceRequest.getPageNo(), (int)queryDeviceRequest.getPageSize());
            List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceList(park.getId(), queryDeviceRequest.getAisleCode(), queryDeviceRequest.getStatus(), queryDeviceRequest.getDeviceType());
            if (CollectionUtils.isEmpty(parkDevices)) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            ArrayList deviceDtos = Lists.newArrayList();
            parkDevices.forEach(parkDevice -> {
                ParkDeviceDto parkDeviceDto = new ParkDeviceDto();
                parkDeviceDto.setId(parkDevice.getId());
                parkDeviceDto.setDeviceCode(parkDevice.getDeviceNo());
                parkDeviceDto.setDeviceType(parkDevice.getType());
                parkDeviceDto.setStatus(parkDevice.getStatus());
                ParkInoutdevice parkInoutdevice = (ParkInoutdevice)this.parkService.getInoutDeviceById(parkDevice.getChannelId().longValue()).getData();
                if (Objects.nonNull(parkInoutdevice)) {
                    parkDeviceDto.setAisleName(parkInoutdevice.getInandoutName());
                    parkDeviceDto.setAisleCode(parkInoutdevice.getInandoutCode());
                }
                if (parkDevice.getStatus() == 3) {
                    parkDeviceDto.setReason(this.parkDeviceDao.getDeviceReason(parkDevice.getId()));
                }
                parkDeviceDto.setUpdateTime(parkDevice.getUpdateTime());
                deviceDtos.add(parkDeviceDto);
            });
            return ObjectResponse.success((Object)deviceDtos);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5931\u8d25: {}. queryDeviceRequest[{}]", new Object[]{e.getMessage(), queryDeviceRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<List<ParkDeviceDto>> handleFallback(QueryDeviceRequest queryDeviceRequest) {
        return new ObjectResponse("200", "\u670d\u52a1\u964d\u7ea7\u8fd4\u56de");
    }

    public ObjectResponse<List<ParkDevice>> getDeviceListByType(Long parkId, int type) {
        List<ParkDevice> parkDevices = this.parkDeviceDao.selectDeviceListByParkIdAndType(parkId, type);
        if (parkDevices != null && parkDevices.size() > 0) {
            return ObjectResponse.success(parkDevices);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Boolean> isAllOnline(Long parkId, int type, int dataCollection) {
        if (dataCollection == 2) {
            Long heartbeatTime = (Long)this.redisUtils.hGet("pnc:heartbeat:time", parkId.toString(), Long.class);
            if (heartbeatTime == null || heartbeatTime < DateTools.unixTimestamp() - 70L) {
                return ObjectResponse.failed((String)"404");
            }
            return ObjectResponse.success((Object)true);
        }
        ObjectResponse<List<ParkDevice>> deviceListByType = this.getDeviceListByType(parkId, type);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)deviceListByType.getData()))) {
            return ObjectResponse.success((Object)((List)deviceListByType.getData()).stream().noneMatch(device -> device.getStatus() != 1));
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<ParkDeviceDto> getDeviceDetail(String parkCode, Integer recordId) {
        try {
            ParkDevice parkDevice = this.parkDeviceDao.load(recordId);
            ParkDeviceDto parkDeviceDto = new ParkDeviceDto();
            parkDeviceDto.setId(parkDevice.getId());
            parkDeviceDto.setDeviceCode(parkDevice.getDeviceNo());
            parkDeviceDto.setDeviceType(parkDevice.getType());
            parkDeviceDto.setStatus(parkDevice.getStatus());
            parkDeviceDto.setAisleName(this.parkInoutdeviceDao.selectChannelName(parkDevice.getChannelId()));
            if (parkDevice.getStatus() == 3) {
                parkDeviceDto.setReason(this.parkDeviceDao.getDeviceReason(parkDevice.getId()));
            }
            parkDeviceDto.setUpdateTime(parkDevice.getUpdateTime());
            return ObjectResponse.success((Object)parkDeviceDto);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u8bbe\u5907\u8be6\u60c5+\u63a5\u53e3\u5f02\u5e38] [{}][{}]", new Object[]{parkCode, recordId, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Void> modifyStatus(Long parkId, String deviceNo, Integer status, String reason, Long wrongTime) {
        ParkDevice parkDevice_para = new ParkDevice();
        parkDevice_para.setParkId(parkId);
        parkDevice_para.setDeviceNo(deviceNo);
        ParkDevice parkDevice_result = this.parkDeviceDao.selectByParam(parkDevice_para);
        log.info("modifyStatus => {}", (Object)parkDevice_result);
        if (parkDevice_result != null) {
            Integer oldStatus = parkDevice_result.getStatus();
            Date endUpdatetime = null;
            if (status == 1 || status == 2 && !status.equals(oldStatus)) {
                if (status == 1) {
                    endUpdatetime = new Date();
                    parkDevice_result.setEndUpdatetime(endUpdatetime);
                }
                parkDevice_result.setStatus(status);
                this.parkDeviceDao.updateStatus(parkId, deviceNo, status, endUpdatetime);
            }
            if (!status.equals(oldStatus)) {
                if (status != 1) {
                    this.parkDevrecordDao.insert(this.getInsertPara(status, reason, wrongTime, parkDevice_result.getId()));
                }
                this.deviceStatusSync(status, parkDevice_result);
            }
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)"404");
    }

    private void deviceStatusSync(Integer status, ParkDevice parkDevice) {
        String cacheKye = "park:device:serial_number:" + parkDevice.getSerialNumber();
        this.redisTemplate.delete((Object)cacheKye);
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            this.pushDeviceStatus(parkDevice.getParkId(), status, (long)parkDevice.getChannelId(), parkDevice.getType());
            this.mqPushService.pushDeviceStatus(parkDevice);
        }));
    }

    public void batchModifyStatus(List<String> snList, Map<String, Long> snHeartbeatMap, Integer deviceType, Integer status) {
        if (snList == null || snList.isEmpty()) {
            return;
        }
        if (status == 2) {
            this.parkDeviceDao.batchUpdateStatus(snList, deviceType, 1, 2);
            ArrayList parkDevrecordList = new ArrayList();
            List<ParkDevice> parkDevices = this.parkDeviceDao.selectListBySns(snList, deviceType);
            parkDevices.forEach(parkDevice -> this.deviceStatusSync(status, (ParkDevice)parkDevice));
            List offlineList = parkDevices.stream().map(parkDevice -> {
                HeartbeatOffline heartbeatOffline = new HeartbeatOffline();
                heartbeatOffline.setParkId(parkDevice.getParkId());
                heartbeatOffline.setLastConnectionTime((Long)snHeartbeatMap.get(parkDevice.getSerialNumber()));
                heartbeatOffline.setDeviceNo(parkDevice.getDeviceNo());
                ParkDevrecord parkDevrecord = new ParkDevrecord();
                parkDevrecord.setDeviceId(parkDevice.getId());
                parkDevrecord.setStatus(Integer.valueOf(2));
                parkDevrecord.setReason("\u4e0b\u7ebf");
                parkDevrecord.setWrongTime(new Date(heartbeatOffline.getLastConnectionTime() * 1000L));
                parkDevrecordList.add(parkDevrecord);
                return heartbeatOffline;
            }).collect(Collectors.toList());
            this.heartbeatOfflineService.saveBatch(offlineList);
            this.parkDevRecordService.saveBatch(parkDevrecordList);
        }
        if (status == 1) {
            this.parkDeviceDao.batchUpdateStatus(snList, deviceType, 2, 1);
            List<ParkDevice> parkDevices2 = this.parkDeviceDao.selectListBySns(snList, deviceType);
            parkDevices2.forEach(parkDevice -> this.deviceStatusSync(status, (ParkDevice)parkDevice));
            List<String> deviceNos = parkDevices2.stream().map(ParkDevice::getDeviceNo).collect(Collectors.toList());
            Map<String, String> deviceNoSnMap = parkDevices2.stream().collect(Collectors.toMap(ParkDevice::getDeviceNo, ParkDevice::getSerialNumber, (a, b) -> b));
            List<HeartbeatOffline> heartbeatOfflines = this.heartbeatOfflineService.getNoFinishLastByDeviceNo(deviceNos);
            Iterator<HeartbeatOffline> iterator = heartbeatOfflines.iterator();
            while (iterator.hasNext()) {
                HeartbeatOffline heartbeatOffline = iterator.next();
                Long lastHeartbeatTime = snHeartbeatMap.get(deviceNoSnMap.get(heartbeatOffline.getDeviceNo()));
                if (lastHeartbeatTime != null) {
                    heartbeatOffline.setReconnectTime(lastHeartbeatTime);
                    heartbeatOffline.setOffTime(Long.valueOf(lastHeartbeatTime - heartbeatOffline.getLastConnectionTime()));
                    continue;
                }
                iterator.remove();
            }
            this.heartbeatOfflineService.updateBatchById(heartbeatOfflines);
        }
    }

    public void batchModifyStatus2(List<ParkDevice> parkDeviceList, Map<String, Long> snHeartbeatMap, Integer status) {
        if (parkDeviceList == null || parkDeviceList.isEmpty()) {
            return;
        }
        if (status == 2) {
            parkDeviceList.forEach(parkDevice -> this.deviceStatusSync(status, (ParkDevice)parkDevice));
            ArrayList parkDevrecordList = new ArrayList();
            List offlineList = parkDeviceList.stream().map(parkDevice -> {
                HeartbeatOffline heartbeatOffline = new HeartbeatOffline();
                heartbeatOffline.setParkId(parkDevice.getParkId());
                heartbeatOffline.setLastConnectionTime((Long)snHeartbeatMap.get(parkDevice.getSerialNumber()));
                heartbeatOffline.setDeviceNo(parkDevice.getDeviceNo());
                ParkDevrecord parkDevrecord = new ParkDevrecord();
                parkDevrecord.setDeviceId(parkDevice.getId());
                parkDevrecord.setStatus(Integer.valueOf(2));
                parkDevrecord.setReason("\u4e0b\u7ebf");
                parkDevrecord.setWrongTime(new Date(heartbeatOffline.getLastConnectionTime() * 1000L));
                parkDevrecordList.add(parkDevrecord);
                return heartbeatOffline;
            }).collect(Collectors.toList());
            this.heartbeatOfflineService.saveBatch(offlineList);
            this.parkDevRecordService.saveBatch(parkDevrecordList);
        }
        if (status == 1) {
            parkDeviceList.forEach(parkDevice -> this.deviceStatusSync(status, (ParkDevice)parkDevice));
            List<String> deviceNos = parkDeviceList.stream().map(ParkDevice::getDeviceNo).collect(Collectors.toList());
            Map<String, String> deviceNoSnMap = parkDeviceList.stream().collect(Collectors.toMap(ParkDevice::getDeviceNo, ParkDevice::getSerialNumber, (a, b) -> b));
            List<HeartbeatOffline> heartbeatOfflines = this.heartbeatOfflineService.getNoFinishLastByDeviceNo(deviceNos);
            if (!heartbeatOfflines.isEmpty()) {
                Iterator<HeartbeatOffline> iterator = heartbeatOfflines.iterator();
                while (iterator.hasNext()) {
                    HeartbeatOffline heartbeatOffline = iterator.next();
                    Long lastHeartbeatTime = snHeartbeatMap.get(deviceNoSnMap.get(heartbeatOffline.getDeviceNo()));
                    if (lastHeartbeatTime != null) {
                        heartbeatOffline.setReconnectTime(lastHeartbeatTime);
                        heartbeatOffline.setOffTime(Long.valueOf(lastHeartbeatTime - heartbeatOffline.getLastConnectionTime()));
                        continue;
                    }
                    iterator.remove();
                }
                if (!heartbeatOfflines.isEmpty()) {
                    this.heartbeatOfflineService.updateBatchById(heartbeatOfflines);
                }
            }
        }
    }

    public void pushDeviceStatus(Long parkId, Integer status, Long channelId, Integer type) {
        ObjectResponse<Park> parkObjectResponse = this.parkService.findByParkId(parkId);
        ObjectResponse.notError(parkObjectResponse);
        ObjectResponse<ParkInoutdevice> objectResponse = this.parkService.getInoutDeviceById(channelId);
        ObjectResponse.notError(objectResponse);
        Park park = (Park)parkObjectResponse.getData();
        ParkInoutdevice parkInoutdevice = (ParkInoutdevice)objectResponse.getData();
        WebsocketPushData websocketPushData = new WebsocketPushData();
        websocketPushData.setRecordType(Integer.valueOf(3));
        websocketPushData.setType(Integer.valueOf(type + 200));
        websocketPushData.setDeviceStatus(status);
        websocketPushData.setChannelId(parkInoutdevice.getInandoutCode());
        websocketPushData.setEnterNo(parkInoutdevice.getInandoutName());
        websocketPushData.setParkCode(park.getParkCode());
        this.redisTemplate.convertAndSend("parkToWebscoket", (Object)JsonUtils.toString((Object)websocketPushData));
    }

    private ParkDevrecord getInsertPara(Integer status, String reason, Long wrongTime, int deviceId) {
        ParkDevrecord parkDevrecord = new ParkDevrecord();
        parkDevrecord.setDeviceId(Integer.valueOf(deviceId));
        parkDevrecord.setStatus(status);
        parkDevrecord.setReason(reason);
        parkDevrecord.setWrongTime(new Date(wrongTime * 1000L));
        return parkDevrecord;
    }

    private <T> List<T> convertListMap2ListBean(List<Map<String, String>> listMap, Class<T> T) throws Exception {
        ArrayList<T> beanList = new ArrayList<T>();
        if (listMap != null && !listMap.isEmpty()) {
            int n = listMap.size();
            for (int i = 0; i < n; ++i) {
                Map<String, String> map = listMap.get(i);
                T bean = this.convertMap2Bean(map, T);
                beanList.add(bean);
            }
            return beanList;
        }
        return beanList;
    }

    private <T> T convertMap2Bean(Map<String, String> map, Class<T> T) throws Exception {
        if (map == null || map.size() == 0) {
            return null;
        }
        String mvalue = null;
        HashMap<String, String> newMap = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            String key = it.next().getKey();
            mvalue = map.get(key);
            newMap.put(key.toUpperCase(Locale.US), mvalue);
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(T);
        T bean = T.newInstance();
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            String propertyName = descriptor.getName();
            String upperPropertyName = propertyName.toUpperCase();
            if (!newMap.keySet().contains(upperPropertyName)) continue;
            Object value = newMap.get(upperPropertyName);
            BeanUtils.copyProperty(bean, (String)propertyName, value);
        }
        return bean;
    }

    public ObjectResponse<List<ParkDeviceDto>> getUserDeviceList(QueryDeviceRequest queryDeviceRequest) {
        try {
            String[] split = queryDeviceRequest.getParkCode().split(",");
            String parkid = this.parkDao.selectByCodes(split);
            PageHelper.startPage((int)queryDeviceRequest.getPageNo(), (int)queryDeviceRequest.getPageSize());
            List<ParkDevice> parkDevices = this.parkDeviceDao.selectUserDeviceList(parkid, queryDeviceRequest.getAisleCode(), queryDeviceRequest.getStatus(), queryDeviceRequest.getDeviceType(), queryDeviceRequest.getDeviceNo());
            if (CollectionUtils.isEmpty(parkDevices)) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            ArrayList deviceDtos = Lists.newArrayList();
            parkDevices.forEach(parkDevice -> {
                ParkInoutdevice parkInoutdevice;
                ParkDeviceDto parkDeviceDto = new ParkDeviceDto();
                parkDeviceDto.setId(parkDevice.getId());
                parkDeviceDto.setDeviceCode(parkDevice.getDeviceNo());
                parkDeviceDto.setSerialNumber(parkDevice.getSerialNumber());
                parkDeviceDto.setDeviceType(parkDevice.getType());
                parkDeviceDto.setStatus(parkDevice.getStatus());
                parkDeviceDto.setProductModel(parkDevice.getProductModel());
                parkDeviceDto.setFirmwareVersion(parkDevice.getFirmwareVersion());
                Park park = (Park)this.parkService.findByParkId(parkDevice.getParkId()).getData();
                if (park != null) {
                    parkDeviceDto.setParkName(park.getParkName());
                }
                if ((parkInoutdevice = (ParkInoutdevice)this.parkService.getInoutDeviceById((long)parkDevice.getChannelId()).getData()) != null) {
                    parkDeviceDto.setAisleName(parkInoutdevice.getInandoutName());
                    parkDeviceDto.setAisleCode(parkInoutdevice.getInandoutCode());
                }
                if (parkDevice.getStatus() == 3) {
                    parkDeviceDto.setReason(this.parkDeviceDao.getDeviceReason(parkDevice.getId()));
                }
                parkDeviceDto.setUpdateTime(parkDevice.getEndUpdatetime());
                deviceDtos.add(parkDeviceDto);
            });
            return ObjectResponse.success((Object)deviceDtos);
        }
        catch (Exception e) {
            log.error("[\u5750\u5e2d\u4e2d\u5fc3\u83b7\u53d6\u8bbe\u5907\u63a5\u53e3\u5f02\u5e38] [{}]", (Object)queryDeviceRequest, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Map<String, Object>> countUserDeviceList(QueryDeviceRequest queryDeviceRequest) {
        try {
            String[] split = queryDeviceRequest.getParkCode().split(",");
            String parkid = this.parkDao.selectByCodes(split);
            int count = this.parkDeviceDao.countUserDeviceList(parkid, queryDeviceRequest.getAisleCode(), queryDeviceRequest.getStatus(), queryDeviceRequest.getDeviceType(), queryDeviceRequest.getDeviceNo());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("count", count);
            return ObjectResponse.success(map);
        }
        catch (Exception e) {
            log.error("[\u83b7\u53d6\u8bbe\u5907\u63a5\u53e3]\u64cd\u4f5c\u5931\u8d25: {}. queryDeviceRequest[{}]", new Object[]{e.getMessage(), queryDeviceRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<ParkChannelListPage<ParkChannelInfo>> selectByParkCode(List<String> parkCodeList, Integer pageIndex, Integer pageSize) {
        Page parkListPage = PageHelper.startPage((int)pageIndex, (int)pageSize);
        List<ParkChannelInfo> parkInoutdeviceList = this.parkInoutdeviceDao.selectByParkCode(parkCodeList);
        return ObjectResponse.success((Object)new ParkChannelListPage(parkListPage.getTotal(), String.valueOf(parkListPage.getPages()), parkInoutdeviceList));
    }

    public ObjectResponse<ParkChannelListPage<ParkInoutDeviceInfo>> selectChannelInfoByParkCode(String parkCode, Integer pageIndex, Integer pageSize) {
        Page parkListPage = PageHelper.startPage((int)pageIndex, (int)pageSize);
        List<ParkInoutDeviceInfo> parkInoutDeviceInfoList = this.parkInoutdeviceDao.selectChannelInfoByParkCode(parkCode);
        return ObjectResponse.success((Object)new ParkChannelListPage(parkListPage.getTotal(), String.valueOf(parkListPage.getPages()), parkInoutDeviceInfoList));
    }

    public ObjectResponse<ParkChannelListPage<ParkChannelInfo>> selectParkChannelInfoByParkId(List<Integer> parkIdList, Integer pageIndex, Integer pageSize) {
        Page parkListPage = PageHelper.startPage((int)pageIndex, (int)pageSize);
        List<ParkChannelInfo> parkInoutdeviceList = this.parkInoutdeviceDao.selectParkChannelInfoByParkId(parkIdList);
        return ObjectResponse.success((Object)new ParkChannelListPage(parkListPage.getTotal(), String.valueOf(parkListPage.getPages()), parkInoutdeviceList));
    }

    public ObjectResponse<ParkInoutdevice> selectParkInoutdeviceByChannelCode(String channelCode) {
        ParkInoutdevice parkInoutdevice = (ParkInoutdevice)this.parkService.getInoutDeviceByCode(channelCode).getData();
        ArrayList<String> channelCodes = new ArrayList<String>(1);
        channelCodes.add(parkInoutdevice.getInandoutCode());
        List<Integer> statusList = Arrays.asList(0, 1, 2);
        List<Integer> deviceList = Arrays.asList(1, 5, 6, 4);
        List<ParkDevice> parkDeviceList = this.parkDeviceDao.selectDeviceSimpleList(parkInoutdevice.getParkId(), channelCodes, statusList, deviceList);
        parkInoutdevice.setParkId(null);
        parkInoutdevice.setDevices(parkDeviceList);
        return ObjectResponse.success((Object)parkInoutdevice);
    }

    public ObjectResponse<ParkChannelListPage<ParkDeviceInfo>> selectDeviceInfoSimpleList(List<Integer> parkId, List<Integer> statusList, Integer pageIndex, Integer pageSize) {
        List<Integer> deviceStatusList = Arrays.asList(1, 5, 4, 6);
        Page parkListPage = PageHelper.startPage((int)pageIndex, (int)pageSize);
        List<ParkDeviceInfo> parkDeviceInfoList = this.parkDeviceDao.selectDeviceInfoSimpleList(parkId, statusList, deviceStatusList);
        log.info("selectDeviceInfoSimpleList  parkDeviceInfoList [{}]", parkDeviceInfoList);
        return ObjectResponse.success((Object)new ParkChannelListPage(parkListPage.getTotal(), String.valueOf(parkListPage.getPages()), parkDeviceInfoList));
    }

    @Transactional
    public ObjectResponse<ParkInoutdevice> createChannel(ParkInoutdevice parkInoutdevice) {
        ParkRegion region;
        List parkDeviceList = parkInoutdevice.getDevices();
        ObjectResponse<Park> parkObjectResponse = this.parkService.findByParkCode(parkInoutdevice.getParkCode());
        Park park = (Park)parkObjectResponse.getData();
        if (park == null) {
            return ObjectResponse.failed((String)"400", (String)"\u8f66\u573a\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        ParkInoutdevice parkInoutdeviceFind = this.parkInoutdeviceDao.checkChannelNameByParkId(park.getId(), parkInoutdevice.getInandoutName());
        if (Objects.nonNull(parkInoutdeviceFind)) {
            return ObjectResponse.failed((String)"400", (String)"\u901a\u9053\u540d\u79f0\u91cd\u590d");
        }
        parkInoutdevice.setParkId(park.getId());
        parkInoutdevice.setStatus(Integer.valueOf(0));
        parkInoutdevice.setAdder(StringUtils.isBlank((CharSequence)parkInoutdevice.getAdder()) ? "third" : parkInoutdevice.getAdder());
        this.checkParkInoutDeviceVipType(parkInoutdevice, park.getId());
        parkInoutdevice.setCreateTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)parkDeviceList)) {
            for (ParkDevice parkDevice : parkDeviceList) {
                Integer checkDevie = this.checkCreateParkDeviceBefore(parkInoutdevice, parkDevice);
                if (new Integer(0).equals(checkDevie)) continue;
                return ObjectResponse.failed((String)"400", (String)this.parserErrorType(checkDevie));
            }
        }
        if (Objects.nonNull(region = this.parkRegionDao.selectOutByParkid(park.getId()))) {
            parkInoutdevice.setRegionId(region.getId());
        }
        this.parkInoutdeviceDao.insert(parkInoutdevice);
        this.sendInfoService.save((Object)new SendInfo(park.getId(), parkInoutdevice.getId(), DownServiceEnum.\u901a\u9053\u4fe1\u606f.getServiceType()));
        this.removeChannelInfoFromRedis(parkInoutdevice.getId(), parkInoutdevice.getInandoutCode());
        if (CollectionUtils.isNotEmpty((Collection)parkDeviceList)) {
            for (ParkDevice parkDevice : parkDeviceList) {
                this.createParkDevice(parkInoutdevice, parkDevice);
            }
        }
        log.info("createChannel data [{}]", (Object)parkInoutdevice);
        this.clearParkInoutdevice(parkInoutdevice);
        return ObjectResponse.success((Object)parkInoutdevice);
    }

    @Transactional
    public ObjectResponse<ParkInoutdevice> updateChannel(ParkInoutdevice parkInoutdevice) {
        log.info("parkInoutdevice [{}]", (Object)parkInoutdevice);
        Park park = (Park)this.parkService.findByParkCode(parkInoutdevice.getParkCode()).getData();
        if (park == null || StringUtils.isBlank((CharSequence)parkInoutdevice.getInandoutCode())) {
            return ObjectResponse.failed((String)"400", (String)"\u8f66\u573a\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        parkInoutdevice.setUpdateTime(new Date());
        parkInoutdevice.setParkId(park.getId());
        ParkInoutdevice parkInoutdeviceCheck = this.parkInoutdeviceDao.checkChannelNameByParkId(park.getId(), parkInoutdevice.getInandoutName());
        if (Objects.nonNull(parkInoutdeviceCheck) && !parkInoutdeviceCheck.getInandoutCode().equals(parkInoutdevice.getInandoutCode())) {
            return ObjectResponse.failed((String)"400", (String)"\u901a\u9053\u540d\u79f0\u91cd\u590d");
        }
        ObjectResponse<ParkInoutdevice> channelResp = this.parkService.getInOutDeviceByCode(park.getId(), parkInoutdevice.getInandoutCode());
        if (!ObjectResponse.isSuccess(channelResp)) {
            return ObjectResponse.failed((String)"400", (String)"\u901a\u9053\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        parkInoutdevice.setId(((ParkInoutdevice)channelResp.getData()).getId());
        List parkDeviceList = parkInoutdevice.getDevices();
        if (Objects.nonNull(parkDeviceList)) {
            for (ParkDevice parkDevice : parkDeviceList) {
                if (StringUtils.isEmpty((CharSequence)parkDevice.getDeviceNo())) {
                    Integer checkDevie = this.checkCreateParkDeviceBefore(parkInoutdevice, parkDevice);
                    if (new Integer(0).equals(checkDevie)) continue;
                    return ObjectResponse.failed((String)"400", (String)this.parserErrorType(checkDevie));
                }
                ParkDevice parkDeviceCheck = this.parkDeviceDao.selectDeviceOnlyBySerialNumber(parkDevice.getSerialNumber());
                log.info("parkDeviceCheck [{}]", (Object)parkDeviceCheck);
                ParkDevice parkDeviceCheckIp = this.parkDeviceDao.checkDeviceByIP(park.getId(), parkDevice.getIp());
                log.info("parkDeviceCheckIp [{}]", (Object)parkDeviceCheckIp);
                ParkDevice parkDeviceMaster = this.parkDeviceDao.checkDeviceByMaster(parkInoutdevice.getParkId(), parkInoutdevice.getId());
                log.info("parkDeviceMaster [{}]", (Object)parkDeviceMaster);
                boolean checkSerial = Objects.nonNull(parkDeviceCheck) && !parkDeviceCheck.getDeviceNo().equals(parkDevice.getDeviceNo());
                boolean checkIp = Objects.nonNull(parkDeviceCheckIp) && !parkDeviceCheckIp.getDeviceNo().equals(parkDevice.getDeviceNo());
                boolean checkMaster = Objects.nonNull(parkDeviceMaster) && !parkDeviceMaster.getDeviceNo().equals(parkDevice.getDeviceNo()) && new Integer(1).equals(parkDevice.getIsMaster());
                log.info("parkDevice [{}]", (Object)parkDevice);
                if (!checkSerial && !checkIp && !checkMaster) continue;
                return ObjectResponse.failed((String)"400", (String)(checkSerial ? "\u8bbe\u5907\u5e8f\u5217\u53f7\u91cd\u590d" : (checkIp ? "\u8bbe\u5907ip\u91cd\u590d" : "\u4e3b\u76f8\u673a\u914d\u7f6e\u91cd\u590d")));
            }
        }
        this.checkParkInoutDeviceVipType(parkInoutdevice, park.getId());
        this.parkInoutdeviceDao.updateById(parkInoutdevice);
        this.sendInfoService.save((Object)new SendInfo(park.getId(), parkInoutdevice.getId(), DownServiceEnum.\u901a\u9053\u4fe1\u606f.getServiceType()));
        this.removeChannelInfoFromRedis(parkInoutdevice.getId(), parkInoutdevice.getInandoutCode());
        if (Objects.nonNull(parkDeviceList)) {
            for (ParkDevice parkDevice : parkDeviceList) {
                parkDevice.setParkId(parkInoutdevice.getParkId());
                if (StringUtils.isEmpty((CharSequence)parkDevice.getDeviceNo())) {
                    this.createParkDevice(parkInoutdevice, parkDevice);
                    continue;
                }
                if (new Integer(1).equals(parkDevice.getType())) {
                    ParkDevice parkDeviceGate;
                    ParkDevice parkDeviceScreen;
                    ParkDevice parkDeviceIndex = new ParkDevice();
                    parkDeviceIndex.setType(Integer.valueOf(1));
                    parkDeviceIndex.setDeviceNo(parkDevice.getDeviceNo());
                    ParkDevice parkDeviceFindIn = this.parkDeviceDao.selectByParam(parkDeviceIndex);
                    log.info("parkDeviceFindIn [{}]", (Object)parkDeviceFindIn);
                    if (new Integer(1).equals(parkDevice.getIsVoiceLed())) {
                        parkDeviceScreen = this.parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(), 3, Objects.nonNull(parkDeviceFindIn) ? parkDeviceFindIn.getIp() : parkDevice.getIp());
                        log.info("parkDeviceScreen [{}]", (Object)parkDeviceScreen);
                        if (Objects.isNull(parkDeviceScreen)) {
                            this.createDeviceOfScreenAndGate(parkInoutdevice, parkDevice, 3);
                        } else {
                            parkDeviceScreen.setIp(parkDevice.getIp());
                            this.parkDeviceDao.updateByDeviceNo(parkDeviceScreen);
                            this.removeDeviceInfoFromRedis(parkDeviceScreen.getSerialNumber());
                        }
                    } else {
                        parkDeviceScreen = this.parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(), 3, Objects.nonNull(parkDeviceFindIn) ? parkDeviceFindIn.getIp() : parkDevice.getIp());
                        if (Objects.nonNull(parkDeviceScreen)) {
                            parkDeviceScreen.setDelFlag(Integer.valueOf(1));
                            this.parkDeviceDao.updateByDeviceNo(parkDeviceScreen);
                            this.removeDeviceInfoFromRedis(parkDeviceScreen.getSerialNumber());
                        }
                    }
                    if (new Integer(1).equals(parkDevice.getIsParkGate())) {
                        parkDeviceGate = this.parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(), 2, Objects.nonNull(parkDeviceFindIn) ? parkDeviceFindIn.getIp() : parkDevice.getIp());
                        log.info("parkDeviceGate [{}]  [{}]", (Object)parkDeviceGate, (Object)Objects.isNull(parkDeviceGate));
                        if (Objects.isNull(parkDeviceGate)) {
                            this.createDeviceOfScreenAndGate(parkInoutdevice, parkDevice, 2);
                        } else {
                            parkDeviceGate.setIp(parkDevice.getIp());
                            this.parkDeviceDao.updateByDeviceNo(parkDeviceGate);
                            this.removeDeviceInfoFromRedis(parkDeviceGate.getSerialNumber());
                        }
                    } else {
                        parkDeviceGate = this.parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(), 2, Objects.nonNull(parkDeviceFindIn) ? parkDeviceFindIn.getIp() : parkDevice.getIp());
                        if (Objects.nonNull(parkDeviceGate)) {
                            parkDeviceGate.setDelFlag(Integer.valueOf(1));
                            this.parkDeviceDao.updateByDeviceNo(parkDeviceGate);
                            this.removeDeviceInfoFromRedis(parkDeviceGate.getSerialNumber());
                        }
                    }
                }
                this.parkDeviceDao.updateByDeviceNo(parkDevice);
                this.removeDeviceInfoFromRedis(parkDevice.getSerialNumber());
                this.clearParkDevice(parkDevice);
            }
        }
        this.clearParkInoutdevice(parkInoutdevice);
        return ObjectResponse.success((Object)parkInoutdevice);
    }

    private void removeChannelInfoFromRedis(Long channelId, String channelCode) {
        this.redisTemplate.delete(Arrays.asList("park:channel:id:" + channelId, "park:channel:code:" + channelCode, "gray:park:channel:id:" + channelId, "gray:park:channel:code:" + channelCode));
    }

    private void removeDeviceInfoFromRedis(String serialNumber) {
        if (!StringUtils.isEmpty((CharSequence)serialNumber)) {
            this.redisTemplate.delete((Object)("park:device:serial_number:" + serialNumber));
        }
    }

    private void checkParkInoutDeviceVipType(ParkInoutdevice parkInoutdevice, Long parkId) {
        List<Integer> integerList;
        if (new Integer(1).equals(parkInoutdevice.getIsAllowVipCar()) && Objects.nonNull(integerList = this.vipTypeDao.selectByParkId(parkId))) {
            ArrayList<String> stringList = new ArrayList<String>(integerList.size());
            for (Integer i : integerList) {
                if (!Objects.nonNull(i)) continue;
                stringList.add(String.valueOf(i));
            }
            String ids = String.join((CharSequence)",", stringList);
            log.info("checkParkInoutDeviceVipType vip\u7c7b\u578b ids [{}]", (Object)ids);
            parkInoutdevice.setVipCarTypeId(ids);
        }
    }

    private Integer checkCreateParkDeviceBefore(ParkInoutdevice parkInoutdevice, ParkDevice parkDevice) {
        ParkDevice parkDeviceType;
        ParkDevice parkDeviceCheckIp;
        ParkDevice parkDeviceCheck;
        if (!StringUtils.isEmpty((CharSequence)parkDevice.getSerialNumber()) && Objects.nonNull(parkDeviceCheck = this.parkDeviceDao.selectDeviceOnlyBySerialNumber(parkDevice.getSerialNumber()))) {
            return 1;
        }
        if (Objects.nonNull(parkDevice.getIp()) && Objects.nonNull(parkDeviceCheckIp = this.parkDeviceDao.checkDeviceByIP(parkInoutdevice.getParkId(), parkDevice.getIp()))) {
            return 2;
        }
        if (new Integer(1).equals(parkDevice.getType())) {
            if (new Integer(1).equals(parkDevice.getIsMaster())) {
                ParkDevice parkDeviceMaster = this.parkDeviceDao.checkDeviceByMaster(parkInoutdevice.getParkId(), parkInoutdevice.getId());
                if (Objects.nonNull(parkDeviceMaster)) {
                    return 3;
                }
            } else {
                ParkDevice parkDeviceSecond = this.parkDeviceDao.checkDeviceBySecond(parkInoutdevice.getParkId(), parkInoutdevice.getId());
                if (Objects.nonNull(parkDeviceSecond)) {
                    return 5;
                }
            }
        }
        if (Objects.nonNull(parkInoutdevice.getId()) && !new Integer(1).equals(parkDevice.getType()) && Objects.nonNull(parkDeviceType = this.parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(), parkDevice.getType(), null))) {
            return 4;
        }
        return 0;
    }

    private String parserErrorType(Integer type) {
        String codeContent;
        switch (type) {
            case 1: {
                codeContent = "\u8bbe\u5907\u5e8f\u5217\u53f7\u91cd\u590d";
                break;
            }
            case 2: {
                codeContent = "\u8bbe\u5907ip\u91cd\u590d";
                break;
            }
            case 3: {
                codeContent = "\u4e3b\u76f8\u673a\u914d\u7f6e\u91cd\u590d";
                break;
            }
            case 4: {
                codeContent = "\u5df2\u5b58\u5728\u540c\u7c7b\u578b\u8bbe\u5907";
                break;
            }
            case 5: {
                codeContent = "\u4ece\u76f8\u673a\u914d\u7f6e\u91cd\u590d";
                break;
            }
            default: {
                codeContent = "default";
            }
        }
        return codeContent;
    }

    public ObjectResponse<ParkDevice> createParkDevice(ParkInoutdevice parkInoutdevice, ParkDevice parkDevice) {
        parkDevice.setParkId(parkInoutdevice.getParkId());
        parkDevice.setChannelId(Integer.valueOf(parkInoutdevice.getId().intValue()));
        parkDevice.setStatus(Integer.valueOf(1));
        parkDevice.setLinetype(Integer.valueOf(Objects.isNull(parkDevice.getLinetype()) ? 0 : parkDevice.getLinetype()));
        parkDevice.setDelFlag(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkDevice.getDelFlag())));
        parkDevice.setModelType(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkDevice.getModelType(), (int)1)));
        parkDevice.setCallMethods(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkDevice.getCallMethods(), (int)2)));
        parkDevice.setIsMaster(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkDevice.getIsMaster(), (int)1)));
        parkDevice.setIsDualcamera(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkDevice.getIsDualcamera())));
        parkDevice.setAdder(StringUtils.isBlank((CharSequence)parkDevice.getAdder()) ? "third" : parkDevice.getAdder());
        parkDevice.setDeviceNo("D" + System.currentTimeMillis() + new Random().nextInt(99));
        parkDevice.setCreateTime(new Date());
        this.parkDeviceDao.insert(parkDevice);
        this.removeDeviceInfoFromRedis(parkDevice.getSerialNumber());
        this.createGateAndScreen(parkInoutdevice, parkDevice);
        this.clearParkDevice(parkDevice);
        return ObjectResponse.success((Object)parkDevice);
    }

    private void createDeviceOfScreenAndGate(ParkInoutdevice parkInoutdevice, ParkDevice parkDevice, Integer type) {
        log.info("createDeviceOfScreenAndGate parkDevice [{}] type [{}]", (Object)parkDevice, (Object)type);
        ParkDevice parkDeviceScreen = new ParkDevice();
        parkDeviceScreen.setParkId(parkInoutdevice.getParkId());
        parkDeviceScreen.setChannelId(Integer.valueOf(parkInoutdevice.getId().intValue()));
        parkDeviceScreen.setType(type);
        parkDeviceScreen.setModelType(parkDevice.getModelType());
        parkDeviceScreen.setDeviceNo("D" + System.currentTimeMillis() + new Random().nextInt(99));
        parkDeviceScreen.setSerialNumber("" + System.currentTimeMillis() + new Random().nextInt(99));
        parkDeviceScreen.setIp(parkDevice.getIp());
        parkDeviceScreen.setCallMethods(parkDevice.getCallMethods());
        parkDeviceScreen.setStatus(Integer.valueOf(1));
        parkDeviceScreen.setCreateTime(new Date());
        parkDeviceScreen.setUpdateTime(new Date());
        parkDeviceScreen.setAdder(parkDevice.getAdder());
        parkDeviceScreen.setDelFlag(Integer.valueOf(0));
        this.parkDeviceDao.insert(parkDeviceScreen);
        this.removeDeviceInfoFromRedis(parkDeviceScreen.getSerialNumber());
    }

    private void createGateAndScreen(ParkInoutdevice parkInoutdevice, ParkDevice parkDevice) {
        if (new Integer(1).equals(parkDevice.getType())) {
            if (new Integer(1).equals(parkDevice.getIsVoiceLed())) {
                this.createDeviceOfScreenAndGate(parkInoutdevice, parkDevice, 3);
            }
            if (new Integer(1).equals(parkDevice.getIsParkGate())) {
                this.createDeviceOfScreenAndGate(parkInoutdevice, parkDevice, 2);
            }
        }
    }

    private void clearParkDevice(ParkDevice parkDevice) {
        parkDevice.setAdder(null);
        parkDevice.setLinetype(null);
        parkDevice.setEzopenId(null);
        parkDevice.setDelFlag(null);
        parkDevice.setModelType(null);
        parkDevice.setCallMethods(null);
        parkDevice.setCreateTime(null);
        parkDevice.setUpdateTime(null);
        parkDevice.setParkId(null);
        parkDevice.setId(null);
        parkDevice.setIsDualcamera(null);
        parkDevice.setChannelId(null);
        parkDevice.setStatus(null);
    }

    private void clearParkInoutdevice(ParkInoutdevice parkInoutdevice) {
        parkInoutdevice.setParkId(null);
        parkInoutdevice.setId(null);
    }

    public ObjectResponse<Integer> updateParkDevice(ParkDevice parkDevice) {
        ParkDevice parkDeviceFind = this.parkDeviceDao.selectByParam(parkDevice);
        parkDevice.setId(parkDeviceFind.getId());
        this.removeDeviceInfoFromRedis(parkDeviceFind.getSerialNumber());
        return ObjectResponse.success((Object)this.parkDeviceDao.updateByDeviceNo(parkDevice));
    }

    public ObjectResponse<ParkDeviceVo> getParkDeviceVo(String serialNumber) {
        ObjectResponse<ParkInoutdevice> inoutDeviceObjectResponse;
        ObjectResponse<ParkDevice> parkDeviceResp = this.getDeviceBySerialNumber(serialNumber);
        ParkDevice parkDevice = (ParkDevice)parkDeviceResp.getData();
        if (Objects.isNull(parkDevice)) {
            return ObjectResponse.success();
        }
        ParkDeviceVo parkDeviceVo = new ParkDeviceVo();
        org.springframework.beans.BeanUtils.copyProperties((Object)parkDevice, (Object)parkDeviceVo);
        ObjectResponse<Park> parkObjectResponse = this.parkService.findByParkId(parkDevice.getParkId());
        if (ObjectResponse.isSuccess(parkObjectResponse)) {
            Park park = (Park)parkObjectResponse.getData();
            parkDeviceVo.setParkName(park.getParkName());
            parkDeviceVo.setParkCode(park.getParkCode());
            ParkTrusteeship parkTrusteeship = (ParkTrusteeship)((IParkTrusteeshipService)SpringUtils.getBean(IParkTrusteeshipService.class)).getParkTrusteeshipByParkId(park.getId()).getData();
            if (Objects.nonNull(parkTrusteeship)) {
                Date currentDate = new Date();
                parkDeviceVo.setTrusteeshipStatus(Integer.valueOf(DateUtil.compare((Date)currentDate, (Date)parkTrusteeship.getStartTime()) < 0 ? 1 : (DateUtil.compare((Date)currentDate, (Date)parkTrusteeship.getStartTime()) > 0 && DateUtil.compare((Date)currentDate, (Date)parkTrusteeship.getEndTime()) < 0 ? 2 : 3)));
                parkDeviceVo.setTrusteeshipEndTime(parkTrusteeship.getEndTime());
            } else {
                parkDeviceVo.setTrusteeshipStatus(Integer.valueOf(0));
            }
        }
        if (ObjectResponse.isSuccess(inoutDeviceObjectResponse = this.parkService.getInoutDeviceById((long)parkDevice.getChannelId()))) {
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)inoutDeviceObjectResponse.getData();
            parkDeviceVo.setAisleCode(parkInoutdevice.getInandoutCode());
            parkDeviceVo.setAisleName(parkInoutdevice.getInandoutName());
            parkDeviceVo.setAisleType(parkInoutdevice.getInandoutType());
        }
        return ObjectResponse.success((Object)parkDeviceVo);
    }
}

