/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.basics.service.apk;

import cn.hutool.core.util.StrUtil;
import com.icetech.basics.api.apk.ApkVersionService;
import com.icetech.basics.dao.apk.ApkVersionDao;
import com.icetech.basics.domain.entity.ApkVersion;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.oss.OssService;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApkVersionServiceImpl
implements ApkVersionService {
    private static final Logger log = LoggerFactory.getLogger(ApkVersionServiceImpl.class);
    @Resource
    private ApkVersionDao apkVersionDao;
    @Resource
    private OssService ossService;

    public ObjectResponse<ApkVersion> getLastVersion(Integer userId) {
        ApkVersion lastVersion = this.apkVersionDao.getLastVersion();
        if (Objects.isNull(lastVersion)) {
            log.warn("[\u5f53\u524d\u6ca1\u6709\u6700\u65b0\u7248\u672c]");
            return ObjectResponse.success();
        }
        if (StrUtil.isNotBlank((CharSequence)lastVersion.getApkPath())) {
            lastVersion.setApkPath(this.ossService.getImageUrlTime(lastVersion.getApkPath(), Long.valueOf(604800L)));
        }
        if (StrUtil.isNotBlank((CharSequence)lastVersion.getRemark())) {
            String[] split = lastVersion.getRemark().split("##");
            lastVersion.setRemarks(Arrays.asList(split));
        }
        return ObjectResponse.success((Object)lastVersion);
    }
}

