package com.icetech.park.service.freespace;

import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.park.dao.park.ParkFreespaceDao;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Slf4j
@Service("updateRegionFreeSpaceService")
public class UpdateRegionFreeSpaceServiceImpl implements UpdateFreeSpaceService {

    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;

    @Override
    public int resetFreeSpace(Long parkId) {
        List<ParkRegion> parkRegions = parkRegionDao.selectByParkid(parkId);
        int i = 0;
        if (parkRegions != null && !parkRegions.isEmpty()) {
            for (ParkRegion parkRegion : parkRegions) {
                i += parkRegionDao.updateFreeParkById(parkRegion.getId());
            }
            if (i > 0) {
                parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(parkId));
            }
        }
        return i;
    }

    @Override
    public int updateFreeSpace(Long parkId, Long regionId, int freeSpace) {
        if (regionId == null) {
            return 0;
        }
        ParkRegion parkRegionUpdate = new ParkRegion();
        parkRegionUpdate.setId(regionId);
        parkRegionUpdate.setFreePark(freeSpace);
        parkRegionUpdate.setRealFreePark(freeSpace);
        int i = parkRegionDao.updateById(parkRegionUpdate);
        if (i > 0) {
            parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(parkId));
        }
        return i;
    }

    @Override
    public int addFreeSpace(Long parkId, Long regionId, int num) {
        if (regionId == null) {
            return 0;
        }
        int i = parkRegionDao.addFreeSpaceByPark(regionId, num);
        if (i > 0) {
            parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(parkId));
        }
        return i;
    }

    @Override
    public int syncFreeSpace(Long parkId, Long regionId) {
        if (regionId == null) {
            return 0;
        }
        int i = parkRegionDao.updateFreeParkById(regionId);
        if (i > 0) {
            parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(parkId));
        }
        return i;
    }

    @Override
    public int syncFreeSpaceByRegions(Collection<Long> parkIds, Collection<Long> regionIds) {
        int i = parkRegionDao.updateFreeParkByIds(regionIds);
        if (i > 0) {
            parkFreespaceDao.calculateFreeSpaceByParks(parkIds);
        }
        return i;
    }

}
